/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEvent;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEventHistory;
import com.helpsystems.enterprise.core.dm.EnterpriseLicenseInfoAM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventDM;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventHistoryDM;
import com.helpsystems.enterprise.core.remoteserver.RBTNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventSource;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteScheduleServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerNotConfiguredException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.remoteserver.RemoteScheduleServerInstaller;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RemoteServerNotificationMonitor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RemoteServerNotificationMonitor.class);
    private long remoteServerID;
    private RemoteServerDM remoteServerDM = null;
    private static final String NOTIF_Q_NAME = "NOTIFQ";
    public static int QUEUE_TIMEOUT = 25;
    private AS400 as400 = null;
    private DataQueue notifQ;
    private RemoteScheduleServer remoteServer = null;
    private final RemoteScheduleServerInstaller rmScheduleServerInstaller = new RemoteScheduleServerInstaller();
    private boolean endRemoteServerNotificationMonitor = false;
    private boolean robotScheduleInterfaceLicensed;
    private Map<Long, Thread> registeredMonitorMap = null;
    private long lastReadTime = 0L;

    public RemoteServerNotificationMonitor(long l, RemoteServerDM remoteServerDM, Map<Long, Thread> map) {
        this.remoteServerID = l;
        this.remoteServerDM = remoteServerDM;
        this.registeredMonitorMap = map;
    }

    public void endMonitor() {
        this.endRemoteServerNotificationMonitor = true;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public void run() {
        LOGGER.info((Object)("Starting Remote Server Notification Monitor: " + this.remoteServerID));
        RemoteServerNotificationDQMonitor remoteServerNotificationDQMonitor = new RemoteServerNotificationDQMonitor(this, Thread.currentThread());
        String string = "RemoteServerNotificationDQMonitor_" + this.remoteServerID;
        Thread thread = new Thread((Runnable)remoteServerNotificationDQMonitor, string);
        thread.start();
        try {
            do {
                this.processNotifications();
                if (this.endRemoteServerNotificationMonitor) continue;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.endRemoteServerNotificationMonitor) continue;
                boolean bl = this.endRemoteServerNotificationMonitor = !this.retryConnectionAllowed();
            } while (!this.endRemoteServerNotificationMonitor);
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)"Remote Server Notification Monitor error.", throwable);
        }
        LOGGER.info((Object)("Ending Remote Server Notification Monitor: " + this.remoteServerID));
        this.unregisterMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotifications() {
        try {
            this.confirmConnection(this.remoteServerID);
            while (!this.endRemoteServerNotificationMonitor) {
                long l = this.process();
                boolean bl = false;
                boolean bl2 = false;
                while (!(bl || bl2 || this.endRemoteServerNotificationMonitor)) {
                    this.confirmConnection(this.remoteServerID);
                    if (this.notifQ == null) {
                        this.notifQ = this.rmScheduleServerInstaller.getDataQueue(this.remoteServer.getLibrary(), NOTIF_Q_NAME, this.as400);
                    }
                    this.lastReadTime = System.currentTimeMillis();
                    DataQueueEntry dataQueueEntry = this.notifQ.read(QUEUE_TIMEOUT);
                    this.lastReadTime = 0L;
                    boolean bl3 = bl = dataQueueEntry != null;
                    if (bl) {
                        try {
                            this.notifQ.clear();
                        }
                        catch (Exception exception) {
                            LOGGER.warn((Object)"Error clearing notification queue.", (Throwable)exception);
                        }
                        continue;
                    }
                    bl2 = this.elapsedTimeExceeded(l);
                }
            }
        }
        catch (RemoteServerException remoteServerException) {
            LOGGER.error((Object)("RemoteServerException: Remote server notification error for remote Server ID: " + this.remoteServerID), (Throwable)remoteServerException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            LOGGER.error((Object)("ResourceUnavailableException: Remote server notification error for remote Server ID: " + this.remoteServerID), (Throwable)resourceUnavailableException);
        }
        catch (Exception exception) {
            String string = "";
            if (this.remoteServer != null) {
                string = this.remoteServer.getLibrary();
            }
            String string2 = "Error reading data from notification queue " + string + "/" + NOTIF_Q_NAME;
            LOGGER.error((Object)string2, (Throwable)exception);
        }
        finally {
            this.lastReadTime = 0L;
            if (this.as400 != null) {
                this.as400.disconnectAllServices();
            }
        }
    }

    private long process() throws RemoteServerUnreachableException, RemoteServerNotConfiguredException, ResourceUnavailableException {
        List list;
        int n = 200;
        do {
            list = this.remoteServerDM.getNotificationList(this.remoteServer.getInstalledDateTime(), n);
            if (this.isValidLicense()) {
                this.makeDBsUpdated(list);
                continue;
            }
            try {
                this.deleteOnRemoteServer(list);
            }
            catch (Exception exception) {
                LOGGER.error((Object)MessageUtil.formatMsg((String)"Even though the interface to remote server {0} is currently unlicensed, that server attempted to notify this server of one or more events. An error occurred while trying to delete the event notification(s) on the remote server.", (Object[])new Object[]{this.remoteServer.getName()}), (Throwable)exception);
            }
        } while (list.size() == n);
        return System.currentTimeMillis();
    }

    private boolean elapsedTimeExceeded(long l) {
        long l2 = TimeUnit.MINUTES.toMillis(30L);
        return System.currentTimeMillis() - l > l2;
    }

    private void unregisterMonitor() {
        if (this.registeredMonitorMap != null) {
            Long l = this.remoteServerID;
            this.registeredMonitorMap.remove(l);
        }
    }

    private void makeDBsUpdated(List<RBTNotification> list) throws RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        RemoteEventHistoryDM remoteEventHistoryDM = (RemoteEventHistoryDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteEventHistoryDM");
        RemoteEventDM remoteEventDM = (RemoteEventDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteEventDM");
        ReactivityAM reactivityAM = (ReactivityAM)ManagerRegistry.getManager((String)"ENTERPRISE.ReactivityAM");
        for (RBTNotification rBTNotification : list) {
            RemoteEventHistory remoteEventHistory = new RemoteEventHistory();
            RemoteEventType remoteEventType = rBTNotification.getObjectType();
            RemoteEvent remoteEvent = null;
            try {
                String string;
                if (rBTNotification.getServerID() != this.remoteServer.getInstalledDateTime()) {
                    string = "Wrong server notification warning. InstalledDateTime=" + this.remoteServer.getInstalledDateTime() + rBTNotification.getTextDescription();
                    LOGGER.warn((Object)string);
                } else if (rBTNotification.isValid()) {
                    try {
                        remoteEvent = remoteEventDM.get(this.remoteServerID, rBTNotification.getObjectID(), remoteEventType);
                    }
                    catch (NoDataException noDataException) {
                        LOGGER.warn((Object)("Remote event definition was not found for remote event notification: " + rBTNotification.getTextDescription()), (Throwable)noDataException);
                        int n = this.remoteServerDM.removeDependency(rBTNotification.getObjectID(), remoteEventType, this.remoteServer.getInstalledDateTime());
                        LOGGER.info((Object)("Remote dependencies removed (" + rBTNotification.getObjectID() + "/" + remoteEventType + "/" + this.remoteServer.getInstalledDateTime() + "/" + this.remoteServerID + "): " + n));
                    }
                    if (remoteEvent != null) {
                        remoteEventHistory.setRemoteEventID(remoteEvent.getId());
                        remoteEventHistory.setRemoteServerID(remoteEvent.getRemoteServerID());
                        remoteEventHistory.setType(remoteEvent.getEventType());
                        remoteEventHistory.setStatus(rBTNotification.getStatus());
                        remoteEventHistory.setServerTime(System.currentTimeMillis());
                        remoteEventHistory.setAgentName("");
                        remoteEventHistory.setSource(RemoteEventSource.REMOTE_SERVER);
                        remoteEventHistory.setSourceKey((long)rBTNotification.getSourceKey());
                        remoteEventHistory.setSourceName(rBTNotification.getSourceInfo());
                        remoteEventHistory.setObjectID(rBTNotification.getObjectID());
                        remoteEventHistory.setObjectName(rBTNotification.getObjectName());
                        remoteEventHistory.setRemoteSystemTime(rBTNotification.getStatusTime());
                        string = remoteEventHistoryDM.save(remoteEventHistory);
                        reactivityAM.notifyRemoteEvent((RemoteEventHistory)string);
                        this.checkRemoteObjectName(remoteEvent, rBTNotification.getObjectName(), remoteEventDM);
                    }
                } else {
                    LOGGER.warn((Object)("Ignoring invalid Robot notification: " + rBTNotification.getTextDescription()));
                }
                this.remoteServerDM.removeNotificationById(rBTNotification.getId());
            }
            catch (DataException dataException) {
                LOGGER.error((Object)("Data Exception processing remote server notification: " + rBTNotification.getTextDescription()), (Throwable)dataException);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error processing remote server notification: " + rBTNotification.getTextDescription()), (Throwable)exception);
            }
        }
    }

    private void checkRemoteObjectName(RemoteEvent remoteEvent, String string, RemoteEventDM remoteEventDM) {
        String string2 = remoteEvent.getRemoteObjectName();
        string2 = string2 != null ? string2.trim().toUpperCase() : "";
        String string3 = string;
        if (string3 != null && (string3 = string3.trim().toUpperCase()).length() > 0 && !string2.equals(string3)) {
            remoteEvent.setRemoteObjectName(string3);
            try {
                LOGGER.info((Object)("Updating remote object name: " + string2 + " --> " + string3));
                remoteEventDM.save(remoteEvent);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Error updating remote object name: " + string2 + "-->" + string3), (Throwable)exception);
            }
        }
    }

    private boolean retryConnectionAllowed() throws ResourceUnavailableException {
        RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServersDM");
        RemoteScheduleServer remoteScheduleServer = (RemoteScheduleServer)remoteServersDM.getServer(this.remoteServerID);
        if (remoteScheduleServer == null) {
            LOGGER.info((Object)("Remote Server was not found. " + this.getClass().getSimpleName() + " process will end."));
            return false;
        }
        if (remoteScheduleServer.getInstalledDateTime() == 0L) {
            LOGGER.info((Object)("Remote Server " + remoteScheduleServer.getName() + " is not registered. " + this.getClass().getSimpleName() + " process will end."));
            return false;
        }
        return true;
    }

    private void confirmConnection(long l) throws ResourceUnavailableException, RemoteServerException {
        RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServersDM");
        RemoteScheduleServer remoteScheduleServer = (RemoteScheduleServer)remoteServersDM.getServer(l);
        if (remoteScheduleServer == null) {
            throw new ResourceUnavailableException("Remote Server not found for ID: " + l);
        }
        if (this.remoteServer == null) {
            this.remoteServer = remoteScheduleServer;
            this.closeConnection();
        } else {
            String string = this.cleanString(remoteScheduleServer.getAspGroup());
            String string2 = this.cleanString(this.remoteServer.getAspGroup());
            String string3 = this.cleanString(remoteScheduleServer.getLibrary());
            String string4 = this.cleanString(this.remoteServer.getLibrary());
            String string5 = this.cleanString(remoteScheduleServer.getSystemName());
            String string6 = this.cleanString(this.remoteServer.getSystemName());
            String string7 = this.cleanString(remoteScheduleServer.getUser());
            String string8 = this.cleanString(this.remoteServer.getUser());
            String string9 = this.cleanString(remoteScheduleServer.getPwd());
            String string10 = this.cleanString(this.remoteServer.getPwd());
            if (!(string.equals(string2) && string3.equals(string4) && string5.equals(string6) && string7.equals(string8) && string9.equals(string10))) {
                LOGGER.debug((Object)("Change detected for remote server " + remoteScheduleServer.getName() + "."));
                this.closeConnection();
                this.remoteServer = remoteScheduleServer;
            }
        }
        if (this.as400 == null) {
            this.as400 = this.rmScheduleServerInstaller.establishConnection(this.remoteServer);
        }
    }

    private String cleanString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private void closeConnection() {
        this.notifQ = null;
        if (this.as400 != null) {
            try {
                this.as400.disconnectAllServices();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.as400 = null;
        }
    }

    private boolean isValidLicense() {
        if (!this.robotScheduleInterfaceLicensed) {
            this.robotScheduleInterfaceLicensed = this.isRobotScheduleInterfaceLicensed();
        }
        return this.robotScheduleInterfaceLicensed;
    }

    private boolean isRobotScheduleInterfaceLicensed() {
        EnterpriseLicenseInfoAM enterpriseLicenseInfoAM;
        try {
            enterpriseLicenseInfoAM = (EnterpriseLicenseInfoAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseLicenseInfoAM");
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Unable to validate the Robot SCHEDULE interface license. Error retrieving the Action Manager.", (Throwable)exception);
            return false;
        }
        try {
            EnterpriseLicenseInfo enterpriseLicenseInfo = enterpriseLicenseInfoAM.getLicenseInfo();
            if (enterpriseLicenseInfo.isValidTrialLicense()) {
                return true;
            }
            EnterpriseProductLicense enterpriseProductLicense = enterpriseLicenseInfo.getPrimaryLicense();
            return enterpriseProductLicense != null && enterpriseProductLicense.isRobotScheduleInterfaceEnabled();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Unable to validate the Robot SCHEDULE interface license, due to an error.", (Throwable)exception);
            return false;
        }
    }

    private void deleteOnRemoteServer(List<RBTNotification> list) throws RemoteServerUnreachableException, RemoteServerNotConfiguredException, ResourceUnavailableException {
        for (RBTNotification rBTNotification : list) {
            this.remoteServerDM.removeNotificationById(rBTNotification.getId());
        }
    }

    private class RemoteServerNotificationDQMonitor
    implements Runnable {
        private final Logger logger = Logger.getLogger(RemoteServerNotificationDQMonitor.class);
        RemoteServerNotificationMonitor rsnm = null;
        Thread monitoredThread = null;
        long SLEEP_TIME = 10000L;
        long INTERRUPT_TIME = QUEUE_TIMEOUT * 4 * 1000;

        public RemoteServerNotificationDQMonitor(RemoteServerNotificationMonitor remoteServerNotificationMonitor2, Thread thread) {
            this.rsnm = remoteServerNotificationMonitor2;
            this.monitoredThread = thread;
        }

        @Override
        public void run() {
            try {
                this.logger.info((Object)("Starting " + Thread.currentThread().getName() + " thread..."));
                while (true) {
                    try {
                        Thread.sleep(this.SLEEP_TIME);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.monitoredThread.isAlive()) {
                        return;
                    }
                    long l = this.rsnm.getLastReadTime();
                    if (l == 0L) continue;
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 > this.INTERRUPT_TIME) {
                        this.logger.warn((Object)("Detected frozen monitor thread. Initiating thread interruption after " + l2 + " milliseconds."));
                        this.monitoredThread.interrupt();
                        continue;
                    }
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)("Monitor thread is current. Last Read Duration: " + l2 + " milliseconds."));
                }
            }
            catch (Throwable throwable) {
                try {
                    this.logger.error((Object)"DQ Monitor Error.", throwable);
                }
                catch (Throwable throwable2) {
                    System.out.println("DQ Monitor Error.");
                    throwable.printStackTrace();
                }
                return;
            }
        }
    }
}

