/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.busobj.OS400Object;
import com.helpsystems.common.as400.busobj.OS400ObjectDescription;
import com.helpsystems.common.as400.util.OS400ObjectDescriptionParameters;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import org.apache.log4j.Logger;

public class OS400ObjectDescriptionAPI {
    private static final Logger logger = Logger.getLogger(OS400ObjectDescriptionAPI.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(OS400ObjectDescriptionAPI.class);
    private AS400 as400;
    private final int ccsid;

    public OS400ObjectDescriptionAPI(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(rbh.getText("the_system_is_null"));
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
    }

    public OS400ObjectDescription runAPI(OS400Object oS400Object) {
        if (oS400Object == null) {
            throw new NullPointerException(rbh.getText("object_list_filter_is_null"));
        }
        OS400ObjectDescriptionParameters oS400ObjectDescriptionParameters = new OS400ObjectDescriptionParameters(this.as400);
        ProgramParameter[] programParameterArray = oS400ObjectDescriptionParameters.getParms(oS400Object);
        try {
            return this.callQUSROBJD(programParameterArray);
        }
        catch (AS400Exception aS400Exception) {
            String string = "(" + aS400Exception.getAS400Message().getID() + ") " + aS400Exception.getAS400Message().getText();
            logger.debug((Object)string, (Throwable)aS400Exception);
            throw new RuntimeException(string, aS400Exception);
        }
    }

    private OS400ObjectDescription callQUSROBJD(ProgramParameter[] programParameterArray) throws AS400Exception {
        ProgramCall programCall = new ProgramCall(this.as400, "/QSYS.LIB/QUSROBJD.PGM", programParameterArray);
        boolean bl = false;
        try {
            bl = programCall.run();
        }
        catch (Exception exception) {
            String string = rbh.getText("error_retrieving_object_description");
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        if (!bl) {
            logger.debug((Object)"QUSROBJD call failed.");
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                logger.debug((Object)(" ** " + aS400MessageArray[i].getID() + " ** " + aS400MessageArray[i].getText()));
            }
            throw new AS400Exception(aS400MessageArray);
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        OS400ObjectDescription oS400ObjectDescription = this.processDescription(this.as400, byArray);
        return oS400ObjectDescription;
    }

    private OS400ObjectDescription processDescription(AS400 aS400, byte[] byArray) {
        CharConverter charConverter;
        OS400ObjectDescription oS400ObjectDescription = new OS400ObjectDescription();
        try {
            charConverter = new CharConverter(this.ccsid, aS400);
        }
        catch (Exception exception) {
            String string = rbh.getText("character_converter_error");
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        String string = charConverter.byteArrayToString(byArray, 8, 10).trim();
        oS400ObjectDescription.setObject(string);
        string = charConverter.byteArrayToString(byArray, 18, 10).trim();
        oS400ObjectDescription.setLibrary(string);
        string = charConverter.byteArrayToString(byArray, 28, 10).trim();
        oS400ObjectDescription.setType(string);
        int n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)48);
        oS400ObjectDescription.setAsp(n);
        string = charConverter.byteArrayToString(byArray, 52, 10).trim();
        oS400ObjectDescription.setOwner(string);
        string = charConverter.byteArrayToString(byArray, 64, 13).trim();
        oS400ObjectDescription.setCreateDate(string);
        string = charConverter.byteArrayToString(byArray, 77, 13).trim();
        oS400ObjectDescription.setChangeDate(string);
        string = charConverter.byteArrayToString(byArray, 90, 10).trim();
        oS400ObjectDescription.setAttribute(string);
        string = charConverter.byteArrayToString(byArray, 100, 50).trim();
        oS400ObjectDescription.setText(string);
        string = charConverter.byteArrayToString(byArray, 193, 13).trim();
        oS400ObjectDescription.setSaveDate(string);
        string = charConverter.byteArrayToString(byArray, 206, 13).trim();
        oS400ObjectDescription.setRestoreDate(string);
        string = charConverter.byteArrayToString(byArray, 219, 10).trim();
        oS400ObjectDescription.setCreatedByUser(string);
        string = charConverter.byteArrayToString(byArray, 229, 8).trim();
        oS400ObjectDescription.setCreatedOnSystem(string);
        string = charConverter.byteArrayToString(byArray, 460, 7).trim();
        oS400ObjectDescription.setLastUsedDate(string);
        n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)468);
        oS400ObjectDescription.setDaysUsed(n);
        n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)472);
        oS400ObjectDescription.setSizeUnits(n);
        n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)476);
        oS400ObjectDescription.setSizeMultiplier(n);
        string = charConverter.byteArrayToString(byArray, 493, 1).trim();
        boolean bl = string.equals("1");
        oS400ObjectDescription.setAspOverflowed(bl);
        n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)564);
        oS400ObjectDescription.setSaveSizeUnits(n);
        n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)568);
        oS400ObjectDescription.setSaveSizeMultiplier(n);
        if (byArray.length <= 572) {
            oS400ObjectDescription.setLibraryASP(0);
            oS400ObjectDescription.setAspDevice("");
            oS400ObjectDescription.setLibraryASPDevice("");
        } else {
            n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)572);
            oS400ObjectDescription.setLibraryASP(n);
            string = charConverter.byteArrayToString(byArray, 576, 10).trim();
            oS400ObjectDescription.setAspDevice(string);
            string = charConverter.byteArrayToString(byArray, 586, 10).trim();
            oS400ObjectDescription.setLibraryASPDevice(string);
        }
        return oS400ObjectDescription;
    }
}

