/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.busobj.ASPListFilter;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ProgramParameter;

public class ASPListParameters {
    private static final AS400Bin4 bin4_ = new AS400Bin4();
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(ASPListParameters.class);
    private AS400 as400;
    private final int ccsid;
    public static final String NAME_GROUP = "YASP0100";
    public static final int NAME_GROUP_SIZE = 28;
    public static final String ASP_INFO = "YASP0200";
    public static final int ASP_INFO_SIZE = 124;
    public static final String NO_FORMAT = rbh.getText("the_format_name_is_missing_or_not_supported");
    public static final String SYSTEM_NULL = rbh.getText("the_system_is_null");

    public ASPListParameters(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(SYSTEM_NULL);
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
    }

    public ProgramParameter[] getParms(ASPListFilter aSPListFilter, String string) {
        int n = 1;
        int n2 = 0;
        if (string == null || !string.equals(NAME_GROUP) && !string.equals(ASP_INFO)) {
            throw new IllegalArgumentException(NO_FORMAT);
        }
        if (string.equals(NAME_GROUP)) {
            n2 = n * 28;
        }
        if (string.equals(ASP_INFO)) {
            n2 = n * 124;
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(bin4_.toBytes(n2)), new ProgramParameter(80), this.getRecordCountParm(), this.getNumFilters(aSPListFilter), this.getFilterInfo(aSPListFilter), this.getFormat(string), this.getErrorParm()};
        return programParameterArray;
    }

    private ProgramParameter getRecordCountParm() {
        int n = -1;
        return new ProgramParameter(bin4_.toBytes(n));
    }

    private ProgramParameter getNumFilters(ASPListFilter aSPListFilter) {
        byte[] byArray = null;
        byArray = aSPListFilter == null || !aSPListFilter.isValid() ? bin4_.toBytes(0) : bin4_.toBytes(1);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getFilterInfo(ASPListFilter aSPListFilter) {
        int n = 16;
        int n2 = 4;
        AS400Text aS400Text = new AS400Text(4, this.ccsid, this.as400);
        byte[] byArray = new byte[n];
        BinaryConverter.intToByteArray((int)n, (byte[])byArray, (int)0);
        BinaryConverter.intToByteArray((int)aSPListFilter.getAspKey(), (byte[])byArray, (int)4);
        BinaryConverter.intToByteArray((int)n2, (byte[])byArray, (int)8);
        BinaryConverter.intToByteArray((int)aSPListFilter.getAspNumber(), (byte[])byArray, (int)12);
        return new ProgramParameter(byArray);
    }

    public ProgramParameter getFormat(String string) {
        AS400Text aS400Text = new AS400Text(8, this.ccsid, this.as400);
        byte[] byArray = new byte[10];
        aS400Text.toBytes((Object)string, byArray, 0);
        return new ProgramParameter(byArray);
    }

    public ProgramParameter getString(String string, int n) {
        AS400Text aS400Text = new AS400Text(n, this.ccsid, this.as400);
        byte[] byArray = new byte[n];
        aS400Text.toBytes((Object)string, byArray, 0);
        return new ProgramParameter(byArray);
    }

    public ProgramParameter getErrorParm() {
        return new ProgramParameter(bin4_.toBytes(0));
    }
}

