/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.busobj.ASP;
import com.helpsystems.common.as400.busobj.ASPListFilter;
import com.helpsystems.common.as400.util.ASPListParameters;
import com.helpsystems.common.as400.util.ListInformation;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ASPAPI {
    private static final Logger logger = Logger.getLogger(ASPAPI.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)ASPAPI.class.getName());
    public static final int ASP_ALL = -1;
    public static final int ASP_ALL_USER = -2;
    public static final int ASP_ALL_IASP = -3;
    private static final String ASP_INFO = "YASP0200";
    private static final String NAME_GROUP = "YASP0100";
    public static final String UNPR_FMT = "SSTS0200";
    private static final String PGM = "/QSYS.LIB/QGY.LIB/QYASPOL.PGM";
    private static final String READ_LIST_PGM = "/QSYS.LIB/QGY.LIB/QGYGTLE.PGM";
    private static final String CLOSE_PGM = "/QSYS.LIB/QGY.LIB/QGYCLST.PGM";
    private static final String UNPR_PGM = "/QSYS.LIB/QWCRSSTS.PGM";
    public static final String KEY_INVALID = rbh.getText("the_list_type_is_not_valid");
    public static final String BAD_SYSTEM = rbh.getText("the_system_is_null");
    public static final String BAD_LIST = rbh.getText("system_asp_list_filter_is_not_valid");
    public static final String NO_HEADER = rbh.getText("open_list_information_not_available");
    public static final String CLOSE_ERR = rbh.getText("error_closing_object_list");
    public static final String READ_DATA_ERR = rbh.getText("error_processing_object_list_segment");
    public static final String OPEN_ERROR = rbh.getText("error_opening_object_list");
    public static final String ASP_ERROR = rbh.getText("asp_list_failed");
    public static final String BAD_CONVERTER = rbh.getText("character_converter_error");
    private static final AS400Bin4 bin4_ = new AS400Bin4();
    private CharConverter converter;
    private AS400 as400;
    private final int ccsid;
    private Vector<ASP> asps;
    private static final String NOT_FOUND = rbh.getText("asp_not_available");

    public ASPAPI(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(BAD_SYSTEM);
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
        this.asps = new Vector(1);
        try {
            this.converter = new CharConverter(this.ccsid);
        }
        catch (Exception exception) {
            String string = BAD_CONVERTER + "  " + exception.toString();
            logger.debug((Object)string);
            throw new RuntimeException(string);
        }
    }

    public ASP getAsp(int n) throws ResourceUnavailableException {
        if (n < 1 || n > 255) {
            throw new IllegalArgumentException("The ASP number is not supported.  The valid range is 1 to 255.");
        }
        ASP[] aSPArray = this.getAspList(n);
        if (aSPArray.length < 1) {
            throw new ResourceUnavailableException(NOT_FOUND + " ASP: " + n, null);
        }
        return aSPArray[0];
    }

    public ASP[] getAspList(int n) {
        ASP[] aSPArray = null;
        ASPListFilter aSPListFilter = this.getFilter(n);
        ASPListParameters aSPListParameters = new ASPListParameters(this.as400);
        ProgramParameter[] programParameterArray = aSPListParameters.getParms(aSPListFilter, NAME_GROUP);
        try {
            this.buildList(programParameterArray);
            this.updateList();
        }
        catch (AS400Exception aS400Exception) {
            logger.debug((Object)ASP_ERROR, (Throwable)aS400Exception);
            throw new RuntimeException(ASP_ERROR, aS400Exception);
        }
        if (!this.asps.isEmpty()) {
            aSPArray = new ASP[this.asps.size()];
            for (int i = 0; i < this.asps.size(); ++i) {
                aSPArray[i] = this.asps.get(i);
            }
        } else {
            aSPArray = new ASP[]{};
        }
        return aSPArray;
    }

    private ASPListFilter getFilter(int n) {
        ASPListFilter aSPListFilter = new ASPListFilter();
        aSPListFilter.setAspNumber(n);
        if (!aSPListFilter.isValid()) {
            throw new IllegalArgumentException("The ASP number is not supported.  The valid range is 1 to 255.");
        }
        return aSPListFilter;
    }

    private void updateList() {
        int n = this.asps.size();
        for (int i = 0; i < n; ++i) {
            ASP aSP = this.asps.get(i);
            if (aSP.getAspStatus() == 1) {
                logger.debug((Object)("ASP " + aSP.getAspNumber() + " is not available for updating statistics."));
                continue;
            }
            this.getAspInfo(aSP);
        }
    }

    private void buildList(ProgramParameter[] programParameterArray) throws AS400Exception {
        Object object;
        try {
            object = new ProgramCall(this.as400, PGM, programParameterArray);
            if (!object.run()) {
                throw new AS400Exception(object.getMessageList());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(OPEN_ERROR + exception.toString());
        }
        object = new ListInformation();
        ((ListInformation)object).setList(this.as400, programParameterArray[2].getOutputData(), programParameterArray[0].getOutputData());
        if (((ListInformation)object).getTotalRecords() > 0) {
            object = this.readList((ListInformation)object, 255);
            this.processList((ListInformation)object);
        }
        this.closeList((ListInformation)object);
    }

    public ASP getAspInfo(ASP aSP) {
        ASPListFilter aSPListFilter = this.getFilter(aSP.getAspNumber());
        ASPListParameters aSPListParameters = new ASPListParameters(this.as400);
        try {
            ProgramParameter[] programParameterArray = aSPListParameters.getParms(aSPListFilter, ASP_INFO);
            this.updateASP(programParameterArray, aSP);
        }
        catch (AS400Exception aS400Exception) {
            logger.debug((Object)ASP_ERROR, (Throwable)aS400Exception);
            throw new RuntimeException(ASP_ERROR, aS400Exception);
        }
        return aSP;
    }

    private ASP updateASP(ProgramParameter[] programParameterArray, ASP aSP) throws AS400Exception {
        Object object;
        try {
            object = new ProgramCall(this.as400, PGM, programParameterArray);
            if (!object.run()) {
                throw new AS400Exception(object.getMessageList());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(OPEN_ERROR + exception.toString());
        }
        object = new ListInformation();
        ((ListInformation)object).setList(this.as400, programParameterArray[2].getOutputData(), programParameterArray[0].getOutputData());
        if (((ListInformation)object).getTotalRecords() > 0) {
            object = this.readList((ListInformation)object, 1);
            this.processRecord((ListInformation)object, aSP);
        }
        this.closeList((ListInformation)object);
        if (aSP.getAspNumber() == 1) {
            this.getUnprotected(aSP);
        }
        return aSP;
    }

    private void processList(ListInformation listInformation) {
        int n = listInformation.getRecordLength();
        byte[] byArray = listInformation.getListData();
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < listInformation.getRecordsReturned(); ++i) {
            System.arraycopy(byArray, i * n, byArray2, 0, n);
            this.asps.addElement(this.getFormat100(byArray2));
        }
    }

    private ASP processRecord(ListInformation listInformation, ASP aSP) {
        int n = listInformation.getRecordLength();
        byte[] byArray = listInformation.getListData();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return this.getFormat200(byArray2, aSP);
    }

    private ASP getFormat100(byte[] byArray) {
        int n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)0);
        String string = this.converter.byteArrayToString(byArray, 4, 10).trim();
        String string2 = this.converter.byteArrayToString(byArray, 14, 10).trim();
        int n2 = 0;
        int n3 = 0;
        if (byArray.length >= 32) {
            n2 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)28);
            n3 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)32);
        }
        ASP aSP = new ASP();
        aSP.setAspNumber(n);
        aSP.setAspGroup(string);
        aSP.setAspDevice(string2);
        aSP.setAspUsage(n2);
        aSP.setAspStatus(n3);
        return aSP;
    }

    private ASP getFormat200(byte[] byArray, ASP aSP) {
        ASP aSP2 = aSP;
        int n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)0);
        int n2 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)8);
        int n3 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)12);
        int n4 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)16);
        int n5 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)20);
        int n6 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)24);
        int n7 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)28);
        if (aSP2 == null) {
            aSP2 = new ASP();
        }
        aSP2.setAspNumber(n);
        aSP2.setTotalSize(n2);
        aSP2.setTotalFree(n3);
        aSP2.setProtectedTotal(n4);
        aSP2.setProtectedFree(n5);
        aSP2.setUnprotectedTotal(n6);
        aSP2.setUnprotectedFree(n7);
        return aSP2;
    }

    private ListInformation readList(ListInformation listInformation, int n) throws AS400Exception {
        Object object;
        int n2 = n * listInformation.getRecordLength();
        int n3 = 1;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(bin4_.toBytes(n2)), new ProgramParameter(listInformation.getRequestHandle()), new ProgramParameter(80), new ProgramParameter(bin4_.toBytes(n)), new ProgramParameter(bin4_.toBytes(n3)), new ProgramParameter(bin4_.toBytes(0))};
        try {
            object = new ProgramCall(this.as400, READ_LIST_PGM, programParameterArray);
            if (!object.run()) {
                throw new AS400Exception(object.getMessageList());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(READ_DATA_ERR + "  " + exception.toString());
        }
        object = new ListInformation();
        ((ListInformation)object).setList(this.as400, programParameterArray[3].getOutputData(), programParameterArray[0].getOutputData());
        return object;
    }

    private void closeList(ListInformation listInformation) {
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(listInformation.getRequestHandle()), new ProgramParameter(bin4_.toBytes(0))};
        try {
            ProgramCall programCall = new ProgramCall(this.as400, CLOSE_PGM, programParameterArray);
            programCall.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getUnprotected(ASP aSP) {
        ASPListParameters aSPListParameters = new ASPListParameters(this.as400);
        byte[] byArray = new byte[76];
        byte[] byArray2 = new byte[128];
        BinaryConverter.intToByteArray((int)byArray2.length, (byte[])byArray2, (int)0);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray.length), new ProgramParameter(bin4_.toBytes(byArray.length)), aSPListParameters.getFormat(UNPR_FMT), aSPListParameters.getString("*NO", 10), new ProgramParameter(byArray2)};
        try {
            ProgramCall programCall = new ProgramCall(this.as400, UNPR_PGM, programParameterArray);
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = BinaryConverter.byteArrayToInt((byte[])programParameterArray[0].getOutputData(), (int)60);
        int n2 = BinaryConverter.byteArrayToInt((byte[])programParameterArray[0].getOutputData(), (int)64);
        if (n2 > 0) {
            aSP.setUnprotectedTotal(n2);
            aSP.setUnprotectedFree(n2 - n);
        }
    }
}

