/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter;

import com.helpsystems.common.as400.access.CommonPCMLLoader;
import com.helpsystems.common.as400.access.OS400CommandInfoPCML;
import com.helpsystems.common.as400.prompter.busobj.PromptedCommand;
import com.helpsystems.common.as400.prompter.parser.CommandParser;
import com.helpsystems.common.as400.service.AS400ServiceDescriptor;
import com.helpsystems.common.as400.service.AS400ServiceStarter;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.xml.XMLUtil;
import java.util.StringTokenizer;

public class PromptTest {
    private static String AS400_POOL_NAME = "AS400_POOL";

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Gimme a command.");
            return;
        }
        PromptTest.createAS400Pool();
        CommonPCMLLoader commonPCMLLoader = new CommonPCMLLoader(AS400_POOL_NAME, null);
        commonPCMLLoader.loadAll();
        OS400CommandInfoPCML oS400CommandInfoPCML = (OS400CommandInfoPCML)ManagerRegistry.getManagerOrFail((String)"COMMON.OS400CommandInfoDM");
        String string = null;
        String string2 = "qsys";
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], "/", false);
        switch (stringTokenizer.countTokens()) {
            case 1: {
                string = stringTokenizer.nextToken();
                break;
            }
            case 2: {
                string2 = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                break;
            }
            default: {
                System.err.println("Invalid library/Command: " + stringArray[0]);
                return;
            }
        }
        String string3 = oS400CommandInfoPCML.getCommandInfo(UserIdentity.NO_USER_SPECIFIED, null, string, string2);
        PromptedCommand promptedCommand = CommandParser.parse(XMLUtil.stringToDocument((String)string3));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[i]);
        }
        promptedCommand.setCommandString(stringBuffer.toString());
        System.out.println("Regurgitated: " + promptedCommand.getCommandString());
    }

    private static void createAS400Pool() throws Exception {
        AS400ServiceDescriptor aS400ServiceDescriptor = new AS400ServiceDescriptor();
        aS400ServiceDescriptor.setIPAddress("cybrking");
        aS400ServiceDescriptor.setUsername("benportal");
        aS400ServiceDescriptor.setEncryptedPassword("benp0rtal");
        aS400ServiceDescriptor.setName(AS400_POOL_NAME);
        aS400ServiceDescriptor.setMaxConnections(5);
        AS400ServiceStarter aS400ServiceStarter = new AS400ServiceStarter();
        aS400ServiceStarter.startService(aS400ServiceDescriptor);
    }
}

