/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.dataset;

import com.helpsystems.common.as400.access.OS400JobDMAS400;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400ActiveJobProxy;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobList;
import java.util.Vector;

public class JobListDataSet
implements DataSet {
    public static final int DEFAULT_THRESHOLD = 200;
    private WrappedAS400 as400;
    private JobList jobList;
    private boolean isClosed = false;
    private OS400JobDMAS400 mgr;
    Job[] theirArray;
    int numberOfFilteredJobs;
    String subsystemFilter = null;
    String userFilter = null;
    Job[] filteredList = null;

    private JobListDataSet(WrappedAS400 wrappedAS400, JobList jobList, OS400JobDMAS400 oS400JobDMAS400, DataFilter dataFilter) throws DataSetException {
        FilterCriteria[] filterCriteriaArray;
        if (wrappedAS400 == null) {
            throw new NullPointerException("The AS400 object passed in is null.");
        }
        this.as400 = wrappedAS400;
        if (jobList == null) {
            throw new NullPointerException("The job list passed in is null.");
        }
        if (oS400JobDMAS400 == null) {
            throw new NullPointerException("The OS400JobDM passed in is null.");
        }
        this.mgr = oS400JobDMAS400;
        this.jobList = jobList;
        if (dataFilter != null && (filterCriteriaArray = dataFilter.getCriteria()) != null && filterCriteriaArray.length > 0) {
            for (int i = 0; i < filterCriteriaArray.length; ++i) {
                if (filterCriteriaArray[i].getFieldName().equalsIgnoreCase("subsystem")) {
                    this.subsystemFilter = (String)((Object)filterCriteriaArray[i].getValue());
                }
                if (!filterCriteriaArray[i].getFieldName().equalsIgnoreCase("jobuser")) continue;
                this.userFilter = (String)((Object)filterCriteriaArray[i].getValue());
            }
        }
        try {
            jobList.load();
        }
        catch (Exception exception) {
            throw new DataSetException("There was a problem loading the job list.", (Throwable)exception);
        }
        if (this.subsystemFilter != null || this.userFilter != null) {
            filterCriteriaArray = null;
            try {
                filterCriteriaArray = jobList.getJobs(0, jobList.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (filterCriteriaArray != null && filterCriteriaArray.length > 0) {
                Vector<FilterCriteria> vector = new Vector<FilterCriteria>();
                for (int i = 0; i < filterCriteriaArray.length; ++i) {
                    FilterCriteria filterCriteria = filterCriteriaArray[i];
                    try {
                        if ((this.subsystemFilter == null || !filterCriteria.getSubsystem().contains(this.subsystemFilter)) && (this.userFilter == null || !filterCriteria.getUser().equalsIgnoreCase(this.userFilter))) continue;
                        vector.add(filterCriteria);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.filteredList = new Job[vector.size()];
                if (vector.size() > 0) {
                    vector.toArray(this.filteredList);
                }
            }
        }
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, JobList jobList, OS400JobDMAS400 oS400JobDMAS400, DataFilter dataFilter) throws DataSetException {
        return JobListDataSet.createDataSet(wrappedAS400, jobList, oS400JobDMAS400, 100, dataFilter);
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, JobList jobList, OS400JobDMAS400 oS400JobDMAS400, int n, DataFilter dataFilter) throws DataSetException {
        JobListDataSet jobListDataSet = new JobListDataSet(wrappedAS400, jobList, oS400JobDMAS400, dataFilter);
        return ArrayDataSet.checkThreshold((DataSet)jobListDataSet, (int)n);
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, JobList jobList, OS400JobDMAS400 oS400JobDMAS400, int n) throws DataSetException {
        JobListDataSet jobListDataSet = new JobListDataSet(wrappedAS400, jobList, oS400JobDMAS400, null);
        return ArrayDataSet.checkThreshold((DataSet)jobListDataSet, (int)n);
    }

    public Object[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        int n3 = n;
        int n4 = n2;
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        OS400ActiveJobProxy[] oS400ActiveJobProxyArray = null;
        ErrorTable errorTable = new ErrorTable();
        int n5 = 0;
        int n6 = 0;
        if (this.subsystemFilter != null) {
            int n7 = n + n2;
            if (n7 > this.filteredList.length) {
                n7 = this.filteredList.length;
            }
            oS400ActiveJobProxyArray = new OS400ActiveJobProxy[n7 - n];
            for (int i = n; i < n7; ++i) {
                OS400ActiveJobProxy oS400ActiveJobProxy = null;
                try {
                    oS400ActiveJobProxyArray[i] = oS400ActiveJobProxy = this.mgr.copyToProxy(this.filteredList[i], null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (this.userFilter != null) {
            int n8 = n + n2;
            if (n8 > this.filteredList.length) {
                n8 = this.filteredList.length;
            }
            oS400ActiveJobProxyArray = new OS400ActiveJobProxy[n8 - n];
            for (int i = n; i < n8; ++i) {
                OS400ActiveJobProxy oS400ActiveJobProxy = null;
                try {
                    oS400ActiveJobProxyArray[i] = oS400ActiveJobProxy = this.mgr.copyToProxy(this.filteredList[i], null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            try {
                int n9 = 0;
                while (n5 < n4) {
                    ++n9;
                    n6 = n4 -= n5;
                    this.theirArray = this.jobList.getJobs(n3 += n6, n4);
                    oS400ActiveJobProxyArray = new OS400ActiveJobProxy[this.theirArray.length];
                    for (int i = 0; i < this.theirArray.length; ++i) {
                        try {
                            if (this.subsystemFilter != null) continue;
                            OS400ActiveJobProxy oS400ActiveJobProxy = this.mgr.copyToProxy(this.theirArray[i], null);
                            oS400ActiveJobProxyArray[n5++] = oS400ActiveJobProxy;
                            continue;
                        }
                        catch (BadDataException badDataException) {
                            errorTable.addException(i + n3, (Exception)((Object)badDataException));
                            oS400ActiveJobProxyArray[n5 - 1] = badDataException.getLoadedObject();
                        }
                    }
                    if (oS400ActiveJobProxyArray.length < n4) continue;
                }
            }
            catch (Exception exception) {
                throw new DataSetException("Unable to retrieve the Job info.", (Throwable)exception);
            }
        }
        if (errorTable.getBadObjectCount() > 0) {
            throw new BadDataArrayException("A data error occurred.", (Object[])oS400ActiveJobProxyArray, errorTable);
        }
        return oS400ActiveJobProxyArray;
    }

    public int size() throws DataSetException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        if (this.subsystemFilter != null || this.userFilter != null) {
            return this.filteredList.length;
        }
        return this.jobList.getLength();
    }

    public void close() throws DataSetException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.as400.close();
        }
        catch (Exception exception) {
            throw new DataSetException("Unable to close the AS400 connection.", (Throwable)exception);
        }
    }
}

