/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.busobj.Proxy;

public class IFSObject
extends Proxy {
    private static final long serialVersionUID = -1176529566896313884L;
    String path = null;
    boolean directory = false;

    public IFSObject() {
    }

    public IFSObject(String string, boolean bl) {
        this.directory = bl;
        this.setPath(string);
    }

    public String toString() {
        return this.path;
    }

    public String getName() {
        int n = this.path.lastIndexOf("/");
        if (n == 0) {
            if (this.path.length() == 0) {
                return "/";
            }
            return this.path.substring(n + 1);
        }
        if (n > 0) {
            return this.path.substring(n + 1);
        }
        throw new RuntimeException("Invalid IFS object path.  There are no seperators.");
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        int n = this.path.lastIndexOf("/");
        if (n == -1) {
            throw new RuntimeException("IFS Object is not valid.  The path does not contain a /.");
        }
        if (this.path.equals("/")) {
            return null;
        }
        return this.path.substring(0, n);
    }

    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("IFS Object path cannot be null.");
        }
        String string2 = string;
        if (string2.length() == 0) {
            throw new IllegalArgumentException("An IFS Object path cannot be blank.");
        }
        if (!string2.startsWith("/")) {
            throw new IllegalArgumentException(string2 + " does not start with /.");
        }
        if (string2.length() == 1) {
            this.path = string2;
            return;
        }
        if (string2.indexOf("//") != -1) {
            throw new IllegalArgumentException(string2 + " is not valid.  The are two consecutive seperators.");
        }
        if (string2.endsWith("/")) {
            throw new IllegalArgumentException(string2 + " is not valid.  It ends with a path seperator.");
        }
        this.path = string2;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean bl) {
        this.directory = bl;
    }
}

