/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.dm.OS400UtilitiesAM;
import com.helpsystems.common.as400.util.OS400Utilities;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.SystemValue;
import java.util.Arrays;
import java.util.Calendar;

public class OS400UtilitiesAMAS400
extends AbstractAS400Manager
implements OS400UtilitiesAM {
    private static String sysDateSeparator;
    private static String sysDateFormat;
    private static String sysTimeSeparator;

    public OS400UtilitiesAMAS400(String string, String string2) throws ResourceUnavailableException {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
        this.loadDateTimeFormat();
    }

    private void loadDateTimeFormat() throws ResourceUnavailableException {
        if (sysDateFormat != null && sysDateFormat.length() > 0) {
            return;
        }
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            SystemValue systemValue = new SystemValue((AS400)wrappedAS400, "QDATFMT");
            sysDateFormat = systemValue.getValue().toString();
            systemValue = new SystemValue((AS400)wrappedAS400, "QDATSEP");
            sysDateSeparator = systemValue.getValue().toString();
            systemValue = new SystemValue((AS400)wrappedAS400, "QTIMSEP");
            sysTimeSeparator = systemValue.getValue().toString();
        }
        catch (AS400Exception aS400Exception) {
            AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
            StringBuffer stringBuffer = new StringBuffer();
            String string = System.getProperty("line.separator");
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                String string2 = aS400MessageArray[i].getID();
                String string3 = aS400MessageArray[i].getText();
                stringBuffer.append(string2 + " - " + string3 + string);
            }
            throw new ResourceUnavailableException(stringBuffer.toString(), (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve the system's date/time format info.", (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    @Override
    public String convertDateToString(Object object) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        String string = null;
        if (object == null) {
            return null;
        }
        String string2 = object.toString().trim();
        if (string2.equals("")) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        try {
            if (string2.trim().length() == 7) {
                n = Integer.parseInt(string2.substring(0, 3)) + 1900;
                n2 = Integer.parseInt(string2.substring(3, 5));
                n3 = Integer.parseInt(string2.substring(5, 7));
                calendar.set(n, n2 - 1, n3);
                bl = false;
            } else if (string2.trim().length() == 13) {
                n = Integer.parseInt(string2.substring(0, 3)) + 1900;
                n2 = Integer.parseInt(string2.substring(3, 5));
                n3 = Integer.parseInt(string2.substring(5, 7));
                n4 = Integer.parseInt(string2.substring(7, 9));
                n5 = Integer.parseInt(string2.substring(9, 11));
                n6 = Integer.parseInt(string2.substring(11, 13));
                calendar.set(n, n2 - 1, n3, n4, n5, n6);
                bl = true;
            } else {
                return null;
            }
            string = this.formatDate(calendar, bl);
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convertSystemDateToString(Object object) throws ResourceUnavailableException {
        if (object == null) {
            return null;
        }
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray2 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray3 = (byte[])object;
        if (Arrays.equals(byArray3, byArray) || Arrays.equals(byArray3, byArray2)) {
            return null;
        }
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        String string = null;
        try {
            DateTimeConverter dateTimeConverter = new DateTimeConverter((AS400)wrappedAS400);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateTimeConverter.convert(byArray3, "*DTS"));
            string = this.formatDate(calendar, true);
        }
        catch (Exception exception) {
            String string2 = null;
            return string2;
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return string;
    }

    @Override
    public String formatDate(Calendar calendar, boolean bl) {
        String string = null;
        String string2 = Integer.toString(calendar.get(1));
        String string3 = OS400Utilities.convertIntToString(calendar.get(2) + 1);
        String string4 = OS400Utilities.convertIntToString(calendar.get(5));
        String string5 = OS400Utilities.convertIntToString(calendar.get(11));
        String string6 = OS400Utilities.convertIntToString(calendar.get(12));
        String string7 = OS400Utilities.convertIntToString(calendar.get(13));
        string = sysDateFormat.equals("MDY") ? string3 + sysDateSeparator + string4 + sysDateSeparator + string2 : (sysDateFormat.equals("DMY") ? string4 + sysDateSeparator + string3 + sysDateSeparator + string2 : (sysDateFormat.equals("JUL") ? string2 + sysDateSeparator + OS400Utilities.convertIntToString(calendar.get(6)) : string2 + sysDateSeparator + string3 + sysDateSeparator + string4));
        if (bl) {
            string = string + " " + string5 + sysTimeSeparator + string6 + sysTimeSeparator + string7;
        }
        return string;
    }

    @Override
    public boolean objectExists(UserIdentity userIdentity, String string, String string2, String string3) {
        WrappedAS400 wrappedAS400 = null;
        boolean bl = false;
        if (string == null || string2 == null || string3 == null) {
            return false;
        }
        String string4 = null;
        String string5 = string3.substring(0, 1);
        string4 = string5.equals("*") ? string3 : "*" + string3;
        String string6 = "CHKOBJ OBJ(" + string2 + "/" + string + ") OBJTYPE(" + string4 + ")";
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            bl = OS400UtilitiesAMAS400.runCommand(string6, new CommandCall((AS400)wrappedAS400));
        }
        catch (AS400Exception aS400Exception) {
            String string7 = OS400Utilities.convertAS400ExceptionToString(aS400Exception);
            throw new RuntimeException(string7, aS400Exception);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error checking object.", exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return bl;
    }
}

