/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.busobj.OS400ProductLicense;
import com.helpsystems.common.as400.busobj.OS400ProductLicense_Validated;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.ProgramCallDocument;
import org.apache.log4j.Logger;

public class OS400ProductLicenseAccess {
    private static final Logger logger = Logger.getLogger(OS400ProductLicenseAccess.class);
    private static final String PCML_FILE = "com.helpsystems.common.as400.access.rsl8072";
    private static final String RSL8072 = "RSL8072";
    private static final String RSL8072V = "RSL8072V";
    private static final int GET_LICENSE = 0;
    private static final int SET_LICENSE = 1;
    private static final int VERIFY_LICENSE = 2;
    private String RBTSYSLIB = "*LIBL";
    protected ProgramCallDocument pcml;

    private void loadPCML(AS400 aS400) {
        if (this.pcml == null) {
            try {
                this.pcml = new ProgramCallDocument(aS400, PCML_FILE);
            }
            catch (Exception exception) {
                logger.error((Object)"Error loading product license access pcml.", (Throwable)exception);
            }
        }
    }

    public OS400ProductLicense_Validated getProductLicense_Validated(AS400 aS400, String string, long l) throws ResourceUnavailableException {
        return this.getProductLicense_Validated(aS400, string, "", l);
    }

    public OS400ProductLicense_Validated getProductLicense_Validated(AS400 aS400, String string, String string2, long l) throws ResourceUnavailableException {
        OS400ProductLicense_Validated oS400ProductLicense_Validated = (OS400ProductLicense_Validated)this.getLicense(true, aS400, string, string2, l);
        return oS400ProductLicense_Validated;
    }

    public OS400ProductLicense getProductLicense(AS400 aS400, String string) throws ResourceUnavailableException {
        return this.getProductLicense(aS400, string, "");
    }

    public OS400ProductLicense getProductLicense(AS400 aS400, String string, String string2) throws ResourceUnavailableException {
        long l = 0L;
        return this.getLicense(false, aS400, string, string2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OS400ProductLicense getLicense(boolean bl, AS400 aS400, String string, String string2, long l) throws ResourceUnavailableException {
        String string3 = null;
        OS400ProductLicense oS400ProductLicense = null;
        OS400ProductLicense_Validated oS400ProductLicense_Validated = null;
        ValidationHelper.checkForNullAndBlank((String)"Product Code", (String)string);
        ValidationHelper.checkForNull((String)"Product Library", (Object)string2);
        this.loadPCML(aS400);
        if (bl) {
            oS400ProductLicense_Validated = new OS400ProductLicense_Validated(string);
            oS400ProductLicense_Validated.setSeed(l);
            oS400ProductLicense = oS400ProductLicense_Validated;
            string3 = RSL8072V;
        } else {
            oS400ProductLicense = new OS400ProductLicense(string);
            string3 = RSL8072;
        }
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                int n;
                this.pcml.setSystem(aS400);
                String string4 = "/QSYS.LIB/" + this.RBTSYSLIB.trim() + ".LIB/" + string3 + ".PGM";
                this.pcml.setPath(string3, string4);
                logger.trace((Object)("Getting license with: " + string4));
                int n2 = 256;
                StringBuffer stringBuffer = new StringBuffer(n2);
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(' ');
                }
                n = 0;
                String string5 = "00200";
                stringBuffer.replace(n, n + string5.length(), string5);
                n = 255;
                String string6 = "X";
                stringBuffer.replace(n, n + string6.length(), string6);
                this.pcml.setValue(string3 + ".licensedata", (Object)stringBuffer.toString());
                this.pcml.setValue(string3 + ".productcode", (Object)string);
                this.pcml.setValue(string3 + ".productlibovr", (Object)string2);
                this.pcml.setIntValue(string3 + ".functioncode", 0);
                if (bl) {
                    this.pcml.setValue(string3 + ".seed", (Object)String.valueOf(l));
                }
                AbstractProgramCallManager.doCallAndReturn(this.pcml, string3, null);
                String string7 = (String)this.pcml.getValue(string3 + ".licensedata");
                if (string7.length() != 256) {
                    throw new RuntimeException("Invalid license data length: " + string7.length());
                }
                String string8 = (String)this.pcml.getValue(string3 + ".countmessage");
                String string9 = (String)this.pcml.getValue(string3 + ".message");
                oS400ProductLicense.setCountMessage(string8);
                oS400ProductLicense.setMessage(string9);
                String string10 = string7.substring(0, 5);
                if (!string10.equals("00200")) {
                    throw new RuntimeException("Unsupported license data version: " + string10);
                }
                this.load_00200_license(oS400ProductLicense, string7);
                if (bl) {
                    oS400ProductLicense_Validated.setReturnKey((String)this.pcml.getValue(string3 + ".returnkey"));
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to retrieve the product license.", (Throwable)exception);
        }
        return oS400ProductLicense;
    }

    public OS400ProductLicense saveProductLicense(AS400 aS400, OS400ProductLicense oS400ProductLicense, String string) throws ResourceUnavailableException {
        return this.saveProductLicense(aS400, oS400ProductLicense, string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OS400ProductLicense saveProductLicense(AS400 aS400, OS400ProductLicense oS400ProductLicense, String string, String string2) throws ResourceUnavailableException {
        ValidationHelper.checkForNullAndBlank((String)"Product Code", (String)string);
        ValidationHelper.checkForNull((String)"Product Library", (Object)string2);
        String string3 = oS400ProductLicense.getLicenseCode();
        ValidationHelper.checkForNullAndBlank((String)"License code", (String)string3);
        this.loadPCML(aS400);
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                int n;
                this.pcml.setSystem(aS400);
                String string4 = "/QSYS.LIB/" + this.RBTSYSLIB.trim() + ".LIB/RSL8072.PGM";
                this.pcml.setPath(RSL8072, string4);
                logger.trace((Object)("Saving license with: " + string4));
                int n2 = 256;
                StringBuffer stringBuffer = new StringBuffer(n2);
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(' ');
                }
                n = 0;
                String string5 = "00200";
                stringBuffer.replace(n, n + string5.length(), string5);
                if (string3.length() > 55) {
                    throw new IllegalArgumentException("The license code exceeds 55 characters.");
                }
                n = 5;
                stringBuffer.replace(n, n + string3.length(), string3);
                n = 255;
                String string6 = "X";
                stringBuffer.replace(n, n + string6.length(), string6);
                this.pcml.setValue("RSL8072.licensedata", (Object)stringBuffer.toString());
                this.pcml.setValue("RSL8072.productcode", (Object)string);
                this.pcml.setValue("RSL8072.productlibovr", (Object)string2);
                this.pcml.setIntValue("RSL8072.functioncode", 1);
                AbstractProgramCallManager.doCallAndReturn(this.pcml, RSL8072, null);
                String string7 = (String)this.pcml.getValue("RSL8072.licensedata");
                if (string7.length() != 256) {
                    throw new RuntimeException("Invalid license data length: " + string7.length());
                }
                String string8 = (String)this.pcml.getValue("RSL8072.countmessage");
                String string9 = (String)this.pcml.getValue("RSL8072.message");
                oS400ProductLicense.setCountMessage(string8);
                oS400ProductLicense.setMessage(string9);
                String string10 = string7.substring(0, 5);
                if (!string10.equals("00200")) {
                    throw new RuntimeException("Unsupported license data version: " + string10);
                }
                this.load_00200_license(oS400ProductLicense, string7);
            }
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Error saving product License.", (Throwable)exception);
        }
        return oS400ProductLicense;
    }

    public OS400ProductLicense verifyProductLicense(AS400 aS400, OS400ProductLicense oS400ProductLicense, String string) throws ResourceUnavailableException {
        return this.verifyProductLicense(aS400, oS400ProductLicense, string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OS400ProductLicense verifyProductLicense(AS400 aS400, OS400ProductLicense oS400ProductLicense, String string, String string2) throws ResourceUnavailableException {
        ValidationHelper.checkForNullAndBlank((String)"Product code", (String)string);
        ValidationHelper.checkForNull((String)"Product Library", (Object)string2);
        String string3 = oS400ProductLicense.getLicenseCode();
        ValidationHelper.checkForNullAndBlank((String)"License code", (String)string3);
        this.loadPCML(aS400);
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                int n;
                this.pcml.setSystem(aS400);
                String string4 = "/QSYS.LIB/" + this.RBTSYSLIB.trim() + ".LIB/RSL8072.PGM";
                this.pcml.setPath(RSL8072, string4);
                logger.trace((Object)("Verifying license with: " + string4));
                int n2 = 256;
                StringBuffer stringBuffer = new StringBuffer(n2);
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(' ');
                }
                n = 0;
                String string5 = "00200";
                stringBuffer.replace(n, n + string5.length(), string5);
                if (string3.length() > 55) {
                    throw new IllegalArgumentException("The license code exceeds 55 characters.");
                }
                n = 5;
                stringBuffer.replace(n, n + string3.length(), string3);
                n = 255;
                String string6 = "X";
                stringBuffer.replace(n, n + string6.length(), string6);
                this.pcml.setValue("RSL8072.licensedata", (Object)stringBuffer.toString());
                this.pcml.setValue("RSL8072.productcode", (Object)string);
                this.pcml.setValue("RSL8072.productlibovr", (Object)string2);
                this.pcml.setIntValue("RSL8072.functioncode", 2);
                AbstractProgramCallManager.doCallAndReturn(this.pcml, RSL8072, null);
                String string7 = (String)this.pcml.getValue("RSL8072.licensedata");
                if (string7.length() != 256) {
                    throw new RuntimeException("Invalid license data length: " + string7.length());
                }
                String string8 = (String)this.pcml.getValue("RSL8072.countmessage");
                String string9 = (String)this.pcml.getValue("RSL8072.message");
                oS400ProductLicense.setCountMessage(string8);
                oS400ProductLicense.setMessage(string9);
                String string10 = string7.substring(0, 5);
                if (!string10.equals("00200")) {
                    throw new RuntimeException("Unsupported license data version: " + string10);
                }
                this.load_00200_license(oS400ProductLicense, string7);
            }
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Error verifying product License.", (Throwable)exception);
        }
        return oS400ProductLicense;
    }

    private void load_00200_license(OS400ProductLicense oS400ProductLicense, String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string2 = string.substring(5, 60);
        String string3 = string.substring(60, 69);
        try {
            n6 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Invalid license type: " + string3);
        }
        String string4 = string.substring(69, 75);
        String string5 = null;
        try {
            string5 = string.substring(75, 84).trim();
            n5 = string5.length() > 0 ? Integer.parseInt(string5) : 0;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid days to expire: " + string5, exception);
        }
        String string6 = null;
        try {
            string6 = string.substring(84, 93).trim();
            n4 = string6.length() > 0 ? Integer.parseInt(string6) : 0;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid license count: " + string6, exception);
        }
        String string7 = null;
        try {
            string7 = string.substring(93, 102).trim();
            n3 = string7.length() > 0 ? Integer.parseInt(string7) : 0;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid processor limit: " + string6, exception);
        }
        String string8 = string.substring(102, 103).trim();
        String string9 = null;
        try {
            string9 = string.substring(103, 109).trim();
            n2 = string9.length() > 0 ? Integer.parseInt(string9) : 0;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid last date over processor limit: " + string6, exception);
        }
        String string10 = null;
        try {
            string10 = string.substring(109, 112).trim();
            n = string10.length() > 0 ? Integer.parseInt(string10) : 0;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid days over processor limit: " + string6, exception);
        }
        boolean bl = false;
        try {
            String string11 = string.substring(112, 113).trim();
            bl = "1".equals(string11);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid indicator for serial specific temp license.", exception);
        }
        oS400ProductLicense.setLicenseCode(string2);
        oS400ProductLicense.setCodeType(n6);
        oS400ProductLicense.setExpirationDate(string4);
        oS400ProductLicense.setDaysToExpire(n5);
        oS400ProductLicense.setLicenseCount(n4);
        if (n4 > 0) {
            oS400ProductLicense.setUseLicenseCount(true);
        } else {
            oS400ProductLicense.setUseLicenseCount(false);
        }
        oS400ProductLicense.setProcessorLimit(n3);
        oS400ProductLicense.setProcessorType(string8);
        oS400ProductLicense.setLastDateOverPrcLimit(n2);
        oS400ProductLicense.setDaysOverPrcLimit(n);
        oS400ProductLicense.setSystemSpecificTempCode(bl);
    }
}

