/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400ActiveJobProxy;
import com.helpsystems.common.as400.busobj.OS400Job;
import com.helpsystems.common.as400.busobj.OS400JobDescriptor;
import com.helpsystems.common.as400.dataset.JobListDataSet;
import com.helpsystems.common.as400.dm.OS400JobDM;
import com.helpsystems.common.as400.ex.JobException;
import com.helpsystems.common.as400.ex.JobNotFoundException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.LocalizedDate;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobList;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SystemValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OS400JobDMAS400
extends AbstractAS400Manager
implements OS400JobDM {
    private static final Logger logger = Logger.getLogger(OS400JobDMAS400.class);
    private static final long UNSIGNED_INT_MAX_VALUE = (long)(Math.pow(2.0, 32.0) - 1.0);
    private SortField[] SORT_FIELDS = new SortField[]{new GenericSortField(1, 0), new GenericSortField(2, 0), new GenericSortField(3, 0), new GenericSortField(4, 0), new GenericSortField(5, 1), new GenericSortField(7, 0), new GenericSortField(6, 0), new GenericSortField(8, 1), new GenericSortField(9, 1)};
    private String sysDateSeparator;
    private String sysDateFormat;
    private String sysTimeSeparator;
    private HashMap<String, Integer> activeJobStatusMap = new HashMap(55);
    private int osVersionNumber;
    private int osReleaseNumber;

    public OS400JobDMAS400(String string, String string2) throws ResourceUnavailableException {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
        this.fetchVersion();
        this.loadHashMaps();
    }

    private void fetchVersion() throws ResourceUnavailableException {
        try (WrappedAS400 wrappedAS400 = null;){
            wrappedAS400 = this.borrowConnection();
            this.osVersionNumber = wrappedAS400.getVersion();
            this.osReleaseNumber = wrappedAS400.getRelease();
        }
    }

    private void loadHashMaps() {
        int n = 1;
        this.activeJobStatusMap.put("GRP ", new Integer(n++));
        this.activeJobStatusMap.put("HLD ", new Integer(n++));
        this.activeJobStatusMap.put("HLDT", new Integer(n++));
        this.activeJobStatusMap.put("BSCA", new Integer(n++));
        this.activeJobStatusMap.put("BSCW", new Integer(n++));
        this.activeJobStatusMap.put("CMNA", new Integer(n++));
        this.activeJobStatusMap.put("CMNW", new Integer(n++));
        this.activeJobStatusMap.put("CMTW", new Integer(n++));
        this.activeJobStatusMap.put("CNDW", new Integer(n++));
        this.activeJobStatusMap.put("CPCW", new Integer(n++));
        this.activeJobStatusMap.put("DLYW", new Integer(n++));
        this.activeJobStatusMap.put("DEQA", new Integer(n++));
        this.activeJobStatusMap.put("DEQW", new Integer(n++));
        this.activeJobStatusMap.put("DKTA", new Integer(n++));
        this.activeJobStatusMap.put("DKTW", new Integer(n++));
        this.activeJobStatusMap.put("DLYW", new Integer(n++));
        this.activeJobStatusMap.put("DSC ", new Integer(n++));
        this.activeJobStatusMap.put("DSPA", new Integer(n++));
        this.activeJobStatusMap.put("DSPW", new Integer(n++));
        this.activeJobStatusMap.put("END ", new Integer(n++));
        this.activeJobStatusMap.put("EOFA", new Integer(n++));
        this.activeJobStatusMap.put("EOFW", new Integer(n++));
        this.activeJobStatusMap.put("EOJ ", new Integer(n++));
        this.activeJobStatusMap.put("EVTW", new Integer(n++));
        this.activeJobStatusMap.put("ICFA", new Integer(n++));
        this.activeJobStatusMap.put("ICFW", new Integer(n++));
        this.activeJobStatusMap.put("INEL", new Integer(n++));
        this.activeJobStatusMap.put("JVAA", new Integer(n++));
        this.activeJobStatusMap.put("JVAW", new Integer(n++));
        this.activeJobStatusMap.put("LCKW", new Integer(n++));
        this.activeJobStatusMap.put("MLTA", new Integer(n++));
        this.activeJobStatusMap.put("MLTW", new Integer(n++));
        this.activeJobStatusMap.put("MSGW", new Integer(n++));
        this.activeJobStatusMap.put("MTXW", new Integer(n++));
        this.activeJobStatusMap.put("MXDW", new Integer(n++));
        this.activeJobStatusMap.put("OPTA", new Integer(n++));
        this.activeJobStatusMap.put("OPTW", new Integer(n++));
        this.activeJobStatusMap.put("OSIW", new Integer(n++));
        this.activeJobStatusMap.put("PRTA", new Integer(n++));
        this.activeJobStatusMap.put("PRTW", new Integer(n++));
        this.activeJobStatusMap.put("PSRW", new Integer(n++));
        this.activeJobStatusMap.put("RUN ", new Integer(n++));
        this.activeJobStatusMap.put("SELW", new Integer(n++));
        this.activeJobStatusMap.put("SEMW", new Integer(n++));
        this.activeJobStatusMap.put("SIGS", new Integer(n++));
        this.activeJobStatusMap.put("SIGW", new Integer(n++));
        this.activeJobStatusMap.put("SRQ ", new Integer(n++));
        this.activeJobStatusMap.put("SVFA", new Integer(n++));
        this.activeJobStatusMap.put("SVFW", new Integer(n++));
        this.activeJobStatusMap.put("TAPA", new Integer(n++));
        this.activeJobStatusMap.put("TAPW", new Integer(n++));
        this.activeJobStatusMap.put("THDW", new Integer(n++));
        this.activeJobStatusMap.put("TIMA", new Integer(n++));
        this.activeJobStatusMap.put("TIMW", new Integer(n++));
        this.activeJobStatusMap.put("    ", new Integer(n++));
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        return this.getActiveJobProxyList(userIdentity, dataFilter, sortField);
    }

    @Override
    public OS400Job getOS400Job(UserIdentity userIdentity, String string, String string2, String string3) throws ResourceUnavailableException, JobException {
        OS400Job oS400Job = new OS400Job();
        oS400Job.setJobName(string);
        oS400Job.setJobNumber(string3);
        oS400Job.setJobUser(string2);
        this.loadEntireJob(userIdentity, oS400Job);
        return oS400Job;
    }

    @Override
    public void reloadJob(UserIdentity userIdentity, OS400Job oS400Job) throws ResourceUnavailableException, JobException {
        this.loadEntireJob(userIdentity, oS400Job);
    }

    @Override
    public DataSet getActiveJobProxyList(UserIdentity userIdentity, SortField sortField) throws ResourceUnavailableException {
        return this.getActiveJobProxyList(userIdentity, null, sortField);
    }

    @Override
    public DataSet getActiveJobProxyList(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection(userIdentity);
        JobList jobList = new JobList((AS400)wrappedAS400);
        SortField sortField2 = sortField;
        if (sortField2 == null) {
            sortField2 = new GenericSortField(1, 0);
        }
        try {
            this.loadDateTimeFormat(wrappedAS400);
            jobList.addJobSelectionCriteria(5, (Object)Boolean.TRUE);
            jobList.addJobSelectionCriteria(7, (Object)Boolean.FALSE);
            jobList.addJobSelectionCriteria(6, (Object)Boolean.FALSE);
            int n = sortField2.getField();
            boolean bl = sortField2.isAscending();
            switch (n) {
                case 1: {
                    jobList.addJobAttributeToSortOn(11001, bl);
                    break;
                }
                case 2: {
                    jobList.addJobAttributeToSortOn(11002, bl);
                    break;
                }
                case 3: {
                    jobList.addJobAttributeToSortOn(11006, bl);
                    break;
                }
                case 4: {
                    jobList.addJobAttributeToSortOn(11005, bl);
                    break;
                }
                case 5: {
                    jobList.addJobAttributeToSortOn(2004, bl);
                    break;
                }
                case 6: {
                    jobList.addJobAttributeToSortOn(101, bl);
                    break;
                }
                case 7: {
                    jobList.addJobAttributeToSortOn(1802, bl);
                    break;
                }
                case 8: {
                    jobList.addJobAttributeToSortOn(304, bl);
                    break;
                }
                case 9: {
                    if (this.isBeforeV5R3()) {
                        throw new IllegalArgumentException("The Subsystem sort  cannot be used on OS400 v" + this.osVersionNumber + "r" + this.osReleaseNumber);
                    }
                    jobList.addJobAttributeToSortOn(1906, bl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The sort field " + n + " cannot be used.");
                }
            }
            jobList.addJobAttributeToRetrieve(11001);
            jobList.addJobAttributeToRetrieve(11002);
            jobList.addJobAttributeToRetrieve(11006);
            jobList.addJobAttributeToRetrieve(11005);
            jobList.addJobAttributeToRetrieve(2004);
            jobList.addJobAttributeToRetrieve(101);
            jobList.addJobAttributeToRetrieve(1802);
            jobList.addJobAttributeToRetrieve(304);
            jobList.addJobAttributeToRetrieve(1906);
            jobList.addJobAttributeToRetrieve(101);
            jobList.addJobAttributeToRetrieve(1406);
            jobList.addJobAttributeToRetrieve(313);
            jobList.addJobAttributeToRetrieve(305);
            jobList.addJobAttributeToRetrieve(401);
            jobList.addJobAttributeToRetrieve(602);
            jobList.addJobAttributeToRetrieve(601);
            jobList.addJobAttributeToRetrieve(1402);
            if (!this.isBeforeV5R3()) {
                jobList.addJobAttributeToRetrieve(11007);
            }
            jobList.addJobAttributeToRetrieve(11003);
            jobList.addJobAttributeToRetrieve(11005);
            jobList.addJobAttributeToRetrieve(11004);
            jobList.addJobAttributeToRetrieve(1307);
            jobList.addJobAttributeToRetrieve(1302);
            jobList.addJobAttributeToRetrieve(1305);
            jobList.addJobAttributeToRetrieve(1304);
            jobList.addJobAttributeToRetrieve(1802);
            jobList.addJobAttributeToRetrieve(1907);
            jobList.addJobAttributeToRetrieve(2009);
            jobList.addJobAttributeToRetrieve(2008);
            jobList.addJobAttributeToRetrieve(2002);
            return JobListDataSet.createDataSet(wrappedAS400, jobList, this, dataFilter);
        }
        catch (Exception exception) {
            try {
                jobList.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
            String string = "Error retrieving OS400 active job proxy list.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    public OS400ActiveJobProxy copyToProxy(Job job, OS400ActiveJobProxy oS400ActiveJobProxy) throws BadDataException, ResourceUnavailableException {
        if (job == null) {
            throw new NullPointerException("The job passed in is null.");
        }
        AS400 aS400 = job.getSystem();
        OS400ActiveJobProxy oS400ActiveJobProxy2 = oS400ActiveJobProxy;
        if (oS400ActiveJobProxy2 == null) {
            oS400ActiveJobProxy2 = new OS400ActiveJobProxy();
        }
        try {
            oS400ActiveJobProxy2.setSystemName(aS400.getSystemName());
            oS400ActiveJobProxy2.setJobName(job.getName());
            oS400ActiveJobProxy2.setJobNumber(job.getNumber());
            oS400ActiveJobProxy2.setJobUser(job.getUser());
            oS400ActiveJobProxy2.setActiveJobStatus(job.getValue(101).toString().trim());
            Object object = this.activeJobStatusMap.get(oS400ActiveJobProxy2.getActiveJobStatus());
            if (object == null || object.toString().length() < 1) {
                object = "999";
            }
            oS400ActiveJobProxy2.setActiveJobStatusCode(this.convertObjectToInt(object));
            oS400ActiveJobProxy2.setAuxiliaryIORequests(this.convertObjectToLong(job.getValue(1406)));
            oS400ActiveJobProxy2.setCpuTimeUsed(this.convertObjectToLong(job.getValue(312)));
            oS400ActiveJobProxy2.setCpuTimeUsedForDB(this.convertObjectToLong(job.getValue(313)));
            oS400ActiveJobProxy2.setCurrentUser(job.getValue(305).toString().trim());
            oS400ActiveJobProxy2.setDateActive(this.convertDateToJavaDate(job.getValue(401)));
            oS400ActiveJobProxy2.setFunction(this.resolveFunction(job));
            oS400ActiveJobProxy2.setFunctionName(job.getValue(601).toString().trim());
            oS400ActiveJobProxy2.setInteractiveTransactions(this.convertObjectToInt(job.getValue(1402)));
            if (!this.isBeforeV5R3()) {
                oS400ActiveJobProxy2.setInternalJobID(job.getInternalJobIdentifier());
            }
            oS400ActiveJobProxy2.setJobStatus(job.getValue(11003).toString().trim());
            oS400ActiveJobProxy2.setJobSubtype(this.resolveJobSubType(job));
            oS400ActiveJobProxy2.setJobType(this.resolveJobType(job));
            oS400ActiveJobProxy2.setMaxCPUTime(this.convertObjectToInt(job.getValue(1302)));
            oS400ActiveJobProxy2.setMaxTempStorage(this.convertObjectToLong(job.getValue(1305)));
            oS400ActiveJobProxy2.setMaxThreads(this.convertObjectToInt(job.getValue(1304)));
            oS400ActiveJobProxy2.setRunPriority(this.convertObjectToInt(job.getValue(1802)));
            oS400ActiveJobProxy2.setSystemPoolID(this.convertObjectToInt(job.getValue(1907)));
            oS400ActiveJobProxy2.setSubsystemName(this.formatFullyQualifiedName(job.getSubsystem()));
            oS400ActiveJobProxy2.setTempStorageUsed(this.convertObjectToLong(job.getValue(2009)));
            oS400ActiveJobProxy2.setThreadCount(this.convertObjectToInt(job.getValue(2008)));
            oS400ActiveJobProxy2.setTimeSlice(this.convertObjectToInt(job.getValue(2002)));
            if (oS400ActiveJobProxy2.getActiveJobStatus().equals("MSGW") && job.getValue(1307).toString().equals("1")) {
                oS400ActiveJobProxy2.setMessageReplyWaiting(true);
            } else {
                oS400ActiveJobProxy2.setMessageReplyWaiting(false);
            }
        }
        catch (RuntimeException runtimeException) {
            ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
            exceptionErrorList.addException((Exception)runtimeException);
            BadDataException badDataException = new BadDataException("Error copying fields into the job.", (Object)oS400ActiveJobProxy2, (ErrorList)exceptionErrorList);
            badDataException.initCause((Throwable)runtimeException);
            throw badDataException;
        }
        catch (AS400Exception aS400Exception) {
            boolean bl;
            String string = aS400Exception.getMessage();
            boolean bl2 = bl = string.indexOf("CPF3C53") > -1;
            if (bl) {
                oS400ActiveJobProxy2.setActiveJobStatus("ENDED");
                return oS400ActiveJobProxy2;
            }
            throw new ResourceUnavailableException("Error retrieving job information.", (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error retrieving job information.", (Throwable)exception);
        }
        return oS400ActiveJobProxy2;
    }

    private void loadEntireJob(UserIdentity userIdentity, OS400Job oS400Job) throws ResourceUnavailableException, JobException {
        WrappedAS400 wrappedAS400 = this.borrowConnection(userIdentity);
        Job job = new Job((AS400)wrappedAS400, oS400Job.getJobName(), oS400Job.getJobUser(), oS400Job.getJobNumber());
        try {
            this.loadDateTimeFormat(wrappedAS400);
            this.loadAlways(oS400Job, job);
            this.loadBasicPerformanceInfo(oS400Job, job);
            this.loadAdditionalPerformanceInfo(oS400Job, job);
            this.loadWorkActiveJobInfo(oS400Job, job);
            this.loadQueueInfo(oS400Job, job, wrappedAS400);
            this.loadJobAttributeInfo(oS400Job, job, wrappedAS400);
            this.loadMessageLoggingInfo(oS400Job, job);
            this.loadActiveJobInfo(oS400Job, job);
            this.loadLibraryListInfo(oS400Job, job);
        }
        catch (AS400Exception aS400Exception) {
            AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
            StringBuffer stringBuffer = new StringBuffer();
            String string = System.getProperty("line.separator");
            boolean bl = false;
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                String string2 = aS400MessageArray[i].getID();
                if (string2.equals("CPF3C53")) {
                    bl = true;
                }
                String string3 = aS400MessageArray[i].getText();
                stringBuffer.append(string2 + " - " + string3 + string);
            }
            logger.debug((Object)stringBuffer.toString(), (Throwable)aS400Exception);
            if (bl) {
                throw new JobNotFoundException(new OS400JobDescriptor(oS400Job.getJobName(), oS400Job.getJobUser(), oS400Job.getJobNumber()), (Exception)((Object)aS400Exception));
            }
            throw new ResourceUnavailableException(stringBuffer.toString(), (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string = "Error retrieving job information for job - " + oS400Job.getJobName() + " " + oS400Job.getJobUser() + " " + oS400Job.getJobNumber();
            logger.debug((Object)string, (Throwable)exception);
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private void loadAlways(OS400Job oS400Job, Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        if (!this.isBeforeV5R3()) {
            oS400Job.setInternalJobID(job.getInternalJobIdentifier());
        }
        oS400Job.setJobStatus(job.getValue(11003).toString().trim());
        oS400Job.setJobSubtype(this.resolveJobSubType(job));
        oS400Job.setJobType(this.resolveJobType(job));
    }

    private void loadBasicPerformanceInfo(OS400Job oS400Job, Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setDefaultWaitTime(this.convertObjectToInt(job.getValue(409)));
        oS400Job.setEligibleForPurge(job.getValue(1604).toString().trim());
        oS400Job.setRunPriority(this.convertObjectToInt(job.getValue(1802)));
        oS400Job.setTimeSlice(this.convertObjectToInt(job.getValue(2002)));
    }

    private void loadAdditionalPerformanceInfo(OS400Job oS400Job, Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setCpuTimeUsed(this.convertObjectToLong(job.getValue(312)));
        oS400Job.setMaxCPUTime(this.convertObjectToInt(job.getValue(1302)));
        oS400Job.setMaxTempStorage(this.convertObjectToLong(job.getValue(1305)));
        oS400Job.setMaxThreads(this.convertObjectToInt(job.getValue(1304)));
        oS400Job.setSystemPoolID(this.convertObjectToInt(job.getValue(1907)));
        oS400Job.setTempStorageUsed(this.convertObjectToLong(job.getValue(2009)));
        if (job.getValue(11003).equals("*JOBQ") || job.getValue(11003).equals("*OUTQ")) {
            oS400Job.setThreadCount(0);
        } else {
            oS400Job.setThreadCount(this.convertObjectToInt(job.getValue(2008)));
        }
        oS400Job.setTimeSliceEndPool(job.getValue(2003).toString().trim());
    }

    private void loadWorkActiveJobInfo(OS400Job oS400Job, Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setActiveJobStatus(job.getValue(101).toString().trim());
        oS400Job.setActiveJobStatusForJobsEnding(job.getValue(103).toString().trim());
        oS400Job.setAuxiliaryIORequests(this.convertObjectToLong(job.getValue(1406)));
        oS400Job.setCpuTimeUsedForDB(this.convertObjectToLong(job.getValue(313)));
        oS400Job.setCurrentSystemPoolID(this.convertObjectToInt(job.getValue(307)));
        oS400Job.setFunction(this.resolveFunction(job));
        oS400Job.setFunctionName(job.getValue(601).toString().trim());
        oS400Job.setInteractiveTransactions(this.convertObjectToInt(job.getValue(1402)));
        oS400Job.setMemoryPool(job.getValue(1306).toString().trim());
        oS400Job.setMessageReply(this.resolveMessageReply(job));
        oS400Job.setSubsystemName(this.formatFullyQualifiedName(job.getValue(1906).toString().trim()));
        oS400Job.setTotalResponseTime(this.convertObjectToInt(job.getValue(1801)));
    }

    private void loadQueueInfo(OS400Job oS400Job, Job job, AS400 aS400) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setDateJobQueue(this.convertSystemDateToDate(job.getValue(404), aS400));
        oS400Job.setJobDate(this.convertDateToString(job.getValue(1002)));
        oS400Job.setJobQueue(this.formatQualifiedName(job.getValue(1004).toString()));
        oS400Job.setJobQueuePriority(job.getValue(1005).toString().trim());
        oS400Job.setJobQueueStatus(job.getValue(1903).toString().trim());
        oS400Job.setOutputQueue(this.formatQualifiedName(job.getValue(1501).toString().trim()));
        oS400Job.setOutputQueuePriority(job.getValue(1502).toString().trim());
        oS400Job.setPrinterDeviceName(job.getValue(1603).toString().trim());
        oS400Job.setSubmittedByJobName(job.getValue(1904).toString().trim());
        oS400Job.setSubmittedByJobNumber(job.getValue(10005).toString().trim());
        oS400Job.setSubmittedByUser(job.getValue(10006).toString().trim());
    }

    private void loadJobAttributeInfo(OS400Job oS400Job, Job job, AS400 aS400) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setAccountingCode(job.getValue(1001).toString().trim());
        oS400Job.setAllowMultipleThreads(this.convertObjectToInt(job.getValue(102)) == 1);
        oS400Job.setBreakMessageHandling(job.getValue(201).toString().trim());
        oS400Job.setCcsid(this.convertObjectToInt(job.getValue(302)));
        oS400Job.setCharacterIDControl(job.getValue(311).toString().trim());
        oS400Job.setCompletionStatus(job.getValue(306).toString().trim());
        oS400Job.setCountryID(job.getValue(303).toString().trim());
        oS400Job.setDDMConversationHandling(job.getValue(408).toString().trim());
        oS400Job.setDateActive(this.convertDateToJavaDate(job.getValue(401)));
        oS400Job.setDateEnded(this.convertDateToJavaDate(job.getValue(418)));
        oS400Job.setDateEnteredSystem(this.convertDateToJavaDate(job.getValue(402)));
        oS400Job.setDateFormat(job.getValue(405).toString().trim());
        oS400Job.setDateScheduled(this.convertSystemDateToDate(job.getValue(403), aS400));
        String string = job.getValue(406).toString().trim();
        if (string.equals(" ")) {
            oS400Job.setDateSeparator("*Blank");
        } else if (string.equals("S")) {
            oS400Job.setDateSeparator("*SYSVAL");
        } else {
            oS400Job.setDateSeparator(string);
        }
        String string2 = job.getValue(413).toString().trim();
        if (string2.equals("")) {
            oS400Job.setDecimalFormat("*Blank");
        } else {
            oS400Job.setDecimalFormat(string2);
        }
        oS400Job.setDefaultCCSID(this.convertObjectToInt(job.getValue(412)));
        oS400Job.setDeviceRecoveryAction(job.getValue(410).toString().trim());
        oS400Job.setInquiryMessageReply(job.getValue(901).toString().trim());
        oS400Job.setJobDescription(this.formatQualifiedName(job.getValue(1003).toString()));
        oS400Job.setJobEndReason(this.convertObjectToInt(job.getValue(1014)));
        oS400Job.setJobLogPending(this.convertObjectToInt(job.getValue(1015)) == 1);
        oS400Job.setJobSwitches(job.getValue(1006).toString().trim());
        oS400Job.setLanguageID(job.getValue(1201).toString().trim());
        oS400Job.setLogCLPrograms(job.getValue(1203).toString().trim());
        oS400Job.setMessageQueueAction(job.getValue(1007).toString().trim());
        oS400Job.setMessageQueueMaxSize(this.convertObjectToInt(job.getValue(1008)));
        oS400Job.setMode(job.getValue(1301).toString().trim());
        oS400Job.setPrintKeyFormat(job.getValue(1601).toString().trim());
        oS400Job.setPrintText(job.getValue(1602).toString().trim());
        oS400Job.setRoutingData(job.getValue(1803).toString().trim());
        oS400Job.setServerType(job.getValue(1911).toString().trim());
        oS400Job.setSignedOnJob(this.convertObjectToInt(job.getValue(701)) == 1);
        oS400Job.setSortSequenceTable(this.formatQualifiedName(job.getValue(1901).toString()));
        oS400Job.setStatusMessageHandling(job.getValue(1902).toString().trim());
        String string3 = job.getValue(2001).toString().trim();
        if (string3.equals(" ")) {
            oS400Job.setTimeSeparator("*Blank");
        } else if (string3.equals("S")) {
            oS400Job.setTimeSeparator("*SYSVAL");
        } else {
            oS400Job.setTimeSeparator(string3);
        }
        oS400Job.setUnitOfWorkID(job.getValue(2101).toString().trim());
    }

    private void loadMessageLoggingInfo(OS400Job oS400Job, Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setEndSeverity(this.convertObjectToInt(job.getValue(501)));
        oS400Job.setLoggingLevel(job.getValue(1202).toString().trim());
        oS400Job.setLoggingSeverity(this.convertObjectToInt(job.getValue(1204)));
        oS400Job.setLoggingText(job.getValue(1205).toString().trim());
    }

    private void loadActiveJobInfo(OS400Job oS400Job, Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setClientIPAddress(job.getValue(318).toString().trim());
        if (job.getValue(502).toString().trim().equals("1")) {
            oS400Job.setControlledEndRequest(true);
        } else {
            oS400Job.setControlledEndRequest(false);
        }
        oS400Job.setCurrentUser(job.getValue(305).toString().trim());
        String string = job.getValue(407).toString().trim();
        if (string.equals("1")) {
            oS400Job.setDbcsCapable(true);
        } else {
            oS400Job.setDbcsCapable(false);
        }
        oS400Job.setJobUserIdentity(job.getValue(1012).toString().trim());
        oS400Job.setJobUserIdentitySetting(this.resolveUserIdentitySetting(job));
        oS400Job.setProductReturnCode(this.convertObjectToInt(job.getValue(1605)));
        oS400Job.setProgramReturnCode(this.convertObjectToInt(job.getValue(1606)));
        oS400Job.setSpecialEnvironment(job.getValue(1908).toString().trim());
        oS400Job.setUserReturnCode(this.convertObjectToInt(job.getValue(2102)));
    }

    private void loadLibraryListInfo(OS400Job oS400Job, Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception, ResourceUnavailableException {
        oS400Job.setCurrentLibrary(job.getValue(10000).toString().trim());
        oS400Job.setCurrentLibraryExistence(this.convertObjectToInt(job.getValue(10001)) == 1);
        oS400Job.setProductLibrary(job.getValue(10002).toString().trim());
        oS400Job.setSystemLibraryList(this.parseLibraryList(job.getValue(10003).toString()));
        oS400Job.setUserLibraryList(this.parseLibraryList(job.getValue(10004).toString()));
    }

    @Override
    public SortField[] getSortFields() {
        SortField[] sortFieldArray = this.SORT_FIELDS;
        if (this.isBeforeV5R3()) {
            ArrayList<SortField> arrayList = new ArrayList<SortField>();
            for (int i = 0; i < sortFieldArray.length; ++i) {
                if (sortFieldArray[i].getField() == 9) continue;
                arrayList.add(sortFieldArray[i]);
            }
            sortFieldArray = new SortField[arrayList.size()];
            arrayList.toArray(sortFieldArray);
        }
        return sortFieldArray;
    }

    private int convertObjectToInt(Object object) {
        return new Integer(object.toString().trim());
    }

    private long convertObjectToLong(Object object) {
        long l = new Long(object.toString().trim());
        if (l == UNSIGNED_INT_MAX_VALUE) {
            l = -1L;
        }
        return l;
    }

    private Date convertDateToJavaDate(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.equals("")) {
            return null;
        }
        try {
            if (string.length() == 7) {
                return Convert.getDate((int)Integer.parseInt(string));
            }
            if (string.length() == 13) {
                return Convert.getDateFromTimestamp((long)Long.parseLong(string));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String convertDateToString(Object object) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        String string = null;
        if (object == null) {
            return null;
        }
        String string2 = object.toString().trim();
        if (string2.equals("")) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        try {
            if (string2.trim().length() == 7) {
                n = Integer.parseInt(string2.substring(0, 3)) + 1900;
                n2 = Integer.parseInt(string2.substring(3, 5));
                n3 = Integer.parseInt(string2.substring(5, 7));
                calendar.set(n, n2 - 1, n3);
                bl = false;
            } else if (string2.trim().length() == 13) {
                n = Integer.parseInt(string2.substring(0, 3)) + 1900;
                n2 = Integer.parseInt(string2.substring(3, 5));
                n3 = Integer.parseInt(string2.substring(5, 7));
                n4 = Integer.parseInt(string2.substring(7, 9));
                n5 = Integer.parseInt(string2.substring(9, 11));
                n6 = Integer.parseInt(string2.substring(11, 13));
                calendar.set(n, n2 - 1, n3, n4, n5, n6);
                bl = true;
            } else {
                return null;
            }
            string = this.formatDate(calendar, bl);
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    private Date convertSystemDateToDate(Object object, AS400 aS400) {
        if (object == null) {
            return null;
        }
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray2 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray3 = (byte[])object;
        if (Arrays.equals(byArray3, byArray) || Arrays.equals(byArray3, byArray2)) {
            return null;
        }
        try {
            DateTimeConverter dateTimeConverter = new DateTimeConverter(aS400);
            LocalizedDate localizedDate = new LocalizedDate(dateTimeConverter.convert(byArray3, "*DTS"));
            LocalizedDate.correctTime((Date)localizedDate);
            return localizedDate;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String formatDate(Calendar calendar, boolean bl) {
        if (this.sysDateFormat == null || this.sysDateFormat.equals("")) {
            throw new NullPointerException("The date/time format information has not been loaded.");
        }
        String string = null;
        String string2 = Integer.toString(calendar.get(1));
        String string3 = this.convertIntToString(calendar.get(2) + 1);
        String string4 = this.convertIntToString(calendar.get(5));
        String string5 = this.convertIntToString(calendar.get(11));
        String string6 = this.convertIntToString(calendar.get(12));
        String string7 = this.convertIntToString(calendar.get(13));
        string = this.sysDateFormat.equals("MDY") ? string3 + this.sysDateSeparator + string4 + this.sysDateSeparator + string2 : (this.sysDateFormat.equals("DMY") ? string4 + this.sysDateSeparator + string3 + this.sysDateSeparator + string2 : (this.sysDateFormat.equals("JUL") ? string2 + this.sysDateSeparator + this.convertIntToString(calendar.get(6)) : string2 + this.sysDateSeparator + string3 + this.sysDateSeparator + string4));
        if (bl) {
            string = string + " " + string5 + this.sysTimeSeparator + string6 + this.sysTimeSeparator + string7;
        }
        return string;
    }

    private void loadDateTimeFormat(AS400 aS400) throws ResourceUnavailableException {
        if (this.sysDateFormat != null && this.sysDateFormat.length() > 0) {
            return;
        }
        try {
            SystemValue systemValue = new SystemValue(aS400, "QDATFMT");
            this.sysDateFormat = systemValue.getValue().toString();
            systemValue = new SystemValue(aS400, "QDATSEP");
            this.sysDateSeparator = systemValue.getValue().toString();
            systemValue = new SystemValue(aS400, "QTIMSEP");
            this.sysTimeSeparator = systemValue.getValue().toString();
        }
        catch (AS400Exception aS400Exception) {
            AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
            StringBuffer stringBuffer = new StringBuffer();
            String string = System.getProperty("line.separator");
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                String string2 = aS400MessageArray[i].getID();
                String string3 = aS400MessageArray[i].getText();
                stringBuffer.append(string2 + " - " + string3 + string);
            }
            throw new ResourceUnavailableException(stringBuffer.toString(), (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve the system's date/time format info.", (Throwable)exception);
        }
    }

    private String convertIntToString(int n) {
        String string = null;
        string = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        return string;
    }

    private int resolveFunction(Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception {
        String string = (String)job.getValue(602);
        if ("C".equals(string)) {
            return 1;
        }
        if ("D".equals(string)) {
            return 2;
        }
        if ("G".equals(string)) {
            return 3;
        }
        if ("I".equals(string)) {
            return 4;
        }
        if ("O".equals(string)) {
            return 5;
        }
        if ("L".equals(string)) {
            return 6;
        }
        if ("N".equals(string)) {
            return 7;
        }
        if ("M".equals(string)) {
            return 8;
        }
        if ("R".equals(string)) {
            return 9;
        }
        if ("P".equals(string)) {
            return 10;
        }
        if ("*".equals(string)) {
            return 11;
        }
        return 0;
    }

    private int resolveJobSubType(Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception {
        String string = (String)job.getValue(11004);
        if ("D".equals(string)) {
            return 1;
        }
        if ("E".equals(string)) {
            return 2;
        }
        if ("F".equals(string)) {
            return 3;
        }
        if ("J".equals(string)) {
            return 4;
        }
        if ("P".equals(string)) {
            return 5;
        }
        if ("T".equals(string)) {
            return 6;
        }
        if ("U".equals(string)) {
            return 7;
        }
        if ("".equals(string)) {
            return 8;
        }
        return 0;
    }

    private int resolveJobType(Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception {
        String string = (String)job.getValue(11005);
        if ("A".equals(string)) {
            return 1;
        }
        if ("B".equals(string)) {
            return 2;
        }
        if ("I".equals(string)) {
            return 3;
        }
        if ("M".equals(string)) {
            return 4;
        }
        if ("R".equals(string)) {
            return 5;
        }
        if ("S".equals(string)) {
            return 6;
        }
        if ("W".equals(string)) {
            return 7;
        }
        if ("X".equals(string)) {
            return 8;
        }
        if ("".equals(string)) {
            return 9;
        }
        return 0;
    }

    private int resolveMessageReply(Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception {
        String string = (String)job.getValue(1307);
        if ("0".equals(string)) {
            return 1;
        }
        if ("1".equals(string)) {
            return 2;
        }
        if ("2".equals(string)) {
            return 3;
        }
        if ("".equals(string)) {
            return 4;
        }
        return 0;
    }

    private int resolveUserIdentitySetting(Job job) throws ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException, ConnectionDroppedException, AS400SecurityException, AS400Exception {
        String string = (String)job.getValue(1013);
        if ("0".equals(string)) {
            return 1;
        }
        if ("".equals(string)) {
            return 1;
        }
        if ("1".equals(string)) {
            return 2;
        }
        if ("2".equals(string)) {
            return 3;
        }
        return 0;
    }

    private String formatQualifiedName(String string) {
        String string2 = string.trim();
        String string3 = "";
        if (string2.length() > 10) {
            String string4 = string2.substring(0, 10);
            String string5 = string2.substring(10);
            string3 = string5.trim() + "/" + string4.trim();
        } else {
            string3 = string2;
        }
        return string3;
    }

    private String formatFullyQualifiedName(String string) {
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        String string4 = "";
        int n = stringBuffer.lastIndexOf(".");
        int n2 = stringBuffer.lastIndexOf("/");
        if (n == -1) {
            return this.formatQualifiedName(string);
        }
        if (n2 == -1) {
            n2 = 0;
        }
        if (stringBuffer.length() > 10) {
            string3 = stringBuffer.substring(n2 + 1, n);
            string2 = null;
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(0, n2));
            if (stringBuffer2.length() < 1) {
                return string3.trim();
            }
            n = stringBuffer2.lastIndexOf(".");
            n2 = stringBuffer2.lastIndexOf("/");
            if (n == -1 && n2 == -1) {
                string2 = stringBuffer2.toString();
            } else {
                if (n == -1) {
                    n = stringBuffer2.length();
                }
                if (n2 == -1) {
                    n2 = 0;
                }
                string2 = stringBuffer2.substring(n2 + 1, n);
            }
        } else {
            return stringBuffer.toString();
        }
        string4 = string2.trim() + "/" + string3.trim();
        return string4;
    }

    private String[] parseLibraryList(String string) {
        String[] stringArray = null;
        int n = string.length();
        int n2 = n / 11;
        int n3 = n % 11;
        stringArray = n3 > 0 ? new String[n2 + 1] : new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = string.substring(i * 11, i * 11 + 11).trim();
        }
        if (n3 > 0) {
            stringArray[n2] = string.substring(n2 * 11).trim();
        }
        return stringArray;
    }

    public boolean isBeforeV5R3() {
        if (this.osVersionNumber > 5) {
            return false;
        }
        if (this.osVersionNumber < 5) {
            return true;
        }
        return this.osReleaseNumber <= 2;
    }
}

