/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.dm.ILibraryManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import java.util.Properties;

public class LibraryManager
extends AbstractProgramCallManager
implements ILibraryManager {
    private static final String PCML_RESOURCE = "com.helpsystems.common.as400.access.common";

    public LibraryManager(String string) throws PcmlException {
        super(PCML_RESOURCE, string);
        this.setName("COMMON.AS400LibraryManager." + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLibraryName(String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        String string2 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                string2 = LibraryManager.getLibraryName(wrappedAS400, this.pcml, string);
            }
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return string2;
    }

    public static String getLibraryName(AS400 aS400, ProgramCallDocument programCallDocument, String string) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"AS400 connection", (Object)aS400);
        String string2 = null;
        ProgramCallDocument programCallDocument2 = programCallDocument;
        if (programCallDocument2 == null) {
            try {
                programCallDocument2 = new ProgramCallDocument(aS400, PCML_RESOURCE);
            }
            catch (PcmlException pcmlException) {
                throw new ResourceUnavailableException("Unable to load the PCML resource.");
            }
        }
        try {
            programCallDocument2.setSystem(aS400);
            programCallDocument2.setValue("rsl038.App", (Object)string.toUpperCase());
            programCallDocument2.setValue("rsl038.Command", (Object)"G");
            Object object = LibraryManager.doCallAndReturn(programCallDocument2, "rsl038", "Library");
            if (object != null) {
                string2 = object.toString();
            }
        }
        catch (PcmlException pcmlException) {
            throw new ResourceUnavailableException("Program call to RSL038 failed", (Throwable)pcmlException);
        }
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties listProductLibraries() throws ResourceUnavailableException {
        String[] stringArray = InstalledProduct.getProductCodes();
        WrappedAS400 wrappedAS400 = null;
        String string = null;
        Properties properties = new Properties();
        try {
            wrappedAS400 = this.borrowConnection();
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem((AS400)wrappedAS400);
                this.pcml.setValue("rsl038.Command", (Object)"G");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].toUpperCase();
                    this.pcml.setValue("rsl038.App", (Object)string2);
                    Object object = this.doCallAndReturn("rsl038", "Library");
                    if (object == null || (string = object.toString().trim()).length() <= 0) continue;
                    properties.setProperty(string2, string);
                }
            }
        }
        catch (PcmlException pcmlException) {
            throw new ResourceUnavailableException("Program call to RSL038 failed", (Throwable)pcmlException);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return properties;
    }
}

