/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.scheduler;

import java.util.List;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.scheduler.Job;
import org.apache.log4j.scheduler.ScheduledJobEntry;

public class Scheduler
extends Thread {
    List jobList = new Vector();
    boolean shutdown = false;

    int findIndex(Job job) {
        int i;
        int size = this.jobList.size();
        boolean found = false;
        for (i = 0; i < size; ++i) {
            ScheduledJobEntry se = (ScheduledJobEntry)this.jobList.get(i);
            if (se.job != job) continue;
            found = true;
            break;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public synchronized boolean delete(Job job) {
        int i = this.findIndex(job);
        if (i != -1) {
            ScheduledJobEntry se = (ScheduledJobEntry)this.jobList.remove(i);
            if (se.job != job) {
                new IllegalStateException("Internal programming error");
            }
            if (i == 0) {
                this.notify();
            }
            return true;
        }
        return false;
    }

    public synchronized void schedule(Job job, long desiredTime) {
        this.schedule(new ScheduledJobEntry(job, desiredTime));
    }

    public synchronized void schedule(Job job, long desiredTime, long period) {
        this.schedule(new ScheduledJobEntry(job, desiredTime, period));
    }

    public synchronized boolean changePeriod(Job job, long newPeriod) {
        if (newPeriod <= 0L) {
            throw new IllegalArgumentException("Period must be an integer langer than zero");
        }
        int i = this.findIndex(job);
        if (i == -1) {
            return false;
        }
        ScheduledJobEntry se = (ScheduledJobEntry)this.jobList.get(i);
        se.period = newPeriod;
        return true;
    }

    private synchronized void schedule(ScheduledJobEntry newSJE) {
        int i;
        int max = this.jobList.size();
        long desiredExecutionTime = newSJE.desiredExecutionTime;
        for (i = 0; i < max; ++i) {
            ScheduledJobEntry sje = (ScheduledJobEntry)this.jobList.get(i);
            if (desiredExecutionTime < sje.desiredExecutionTime) break;
        }
        this.jobList.add(i, newSJE);
        if (i == 0) {
            this.notify();
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public synchronized void run() {
        while (!this.shutdown) {
            if (this.jobList.isEmpty()) {
                this.linger();
                continue;
            }
            ScheduledJobEntry sje = (ScheduledJobEntry)this.jobList.get(0);
            long now = System.currentTimeMillis();
            if (now >= sje.desiredExecutionTime) {
                this.executeInABox(sje.job);
                this.jobList.remove(0);
                if (sje.period <= 0L) continue;
                sje.desiredExecutionTime = now + sje.period;
                this.schedule(sje);
                continue;
            }
            this.linger(sje.desiredExecutionTime - now);
        }
        System.out.println("Leaving scheduler run method");
    }

    void executeInABox(Job job) {
        try {
            job.execute();
        }
        catch (Exception e) {
            LogLog.error("The execution of the job threw an exception", e);
        }
    }

    void linger() {
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            this.shutdown = true;
        }
    }

    void linger(long timeToLinger) {
        try {
            this.wait(timeToLinger);
        }
        catch (InterruptedException ie) {
            this.shutdown = true;
        }
    }
}

