/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class LikeRule
extends AbstractRule {
    static final long serialVersionUID = -3375458885595683156L;
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private transient Pattern pattern;
    private transient Perl5Matcher matcher = new Perl5Matcher();
    private transient String field;

    private LikeRule(String string, Pattern pattern) {
        if (!resolver.isField(string)) {
            throw new IllegalArgumentException("Invalid LIKE rule - " + string + " is not a supported field");
        }
        this.field = string;
        this.pattern = pattern;
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid LIKE rule - expected two parameters but received " + stack.size());
        }
        String string = stack.pop().toString();
        String string2 = stack.pop().toString();
        return LikeRule.getRule(string2, string);
    }

    public static Rule getRule(String string, String string2) {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = perl5Compiler.compile(string2, 1);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new IllegalArgumentException("Invalid LIKE rule - " + malformedPatternException.getMessage());
        }
        return new LikeRule(string, pattern);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        Object object = resolver.getValue(this.field, loggingEvent);
        return object != null && this.pattern != null && this.matcher.matches(object.toString(), this.pattern);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.field = (String)objectInputStream.readObject();
            String string = (String)objectInputStream.readObject();
            Perl5Compiler perl5Compiler = new Perl5Compiler();
            this.matcher = new Perl5Matcher();
            this.pattern = perl5Compiler.compile(string, 1);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new IOException("Invalid LIKE rule - " + malformedPatternException.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.field);
        objectOutputStream.writeObject(this.pattern.getPattern());
    }
}

