/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.UtilLoggingLevel;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class LevelInequalityRule
extends AbstractRule {
    static final long serialVersionUID = 851854546425717836L;
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private transient Level level;
    private transient List utilList = new LinkedList();
    private transient List levelList = new LinkedList();
    private transient String inequalitySymbol;

    private LevelInequalityRule(String string, String string2) {
        this.levelList.add(Level.FATAL.toString());
        this.levelList.add(Level.ERROR.toString());
        this.levelList.add(Level.WARN.toString());
        this.levelList.add(Level.INFO.toString());
        this.levelList.add(Level.DEBUG.toString());
        Iterator iterator = UtilLoggingLevel.getAllPossibleLevels().iterator();
        while (iterator.hasNext()) {
            this.utilList.add(((UtilLoggingLevel)iterator.next()).toString());
        }
        this.level = this.levelList.contains(string2.toUpperCase()) ? Level.toLevel(string2.toUpperCase()) : UtilLoggingLevel.toLevel(string2.toUpperCase());
        this.inequalitySymbol = string;
    }

    public static Rule getRule(String string, String string2) {
        return new LevelInequalityRule(string, string2);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        Level level = null;
        level = this.level instanceof UtilLoggingLevel ? UtilLoggingLevel.toLevel(resolver.getValue("LEVEL", loggingEvent).toString()) : Level.toLevel(resolver.getValue("LEVEL", loggingEvent).toString());
        boolean bl = false;
        int n = level.toInt();
        int n2 = this.level.toInt();
        if ("<".equals(this.inequalitySymbol)) {
            bl = n < n2;
        } else if (">".equals(this.inequalitySymbol)) {
            bl = n > n2;
        } else if ("<=".equals(this.inequalitySymbol)) {
            bl = n <= n2;
        } else if (">=".equals(this.inequalitySymbol)) {
            bl = n >= n2;
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.utilList = new LinkedList();
        this.levelList = new LinkedList();
        this.inequalitySymbol = (String)objectInputStream.readObject();
        boolean bl = objectInputStream.readBoolean();
        int n = objectInputStream.readInt();
        this.level = bl ? UtilLoggingLevel.toLevel(n) : Level.toLevel(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.inequalitySymbol);
        objectOutputStream.writeBoolean(this.level instanceof UtilLoggingLevel);
        objectOutputStream.writeInt(this.level.toInt());
    }
}

