/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.PartialTextMatchRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.rule.TimestampEqualsRule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class EqualsRule
extends AbstractRule {
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private final String value;
    private final String field;

    private EqualsRule(String string, String string2) {
        if (!resolver.isField(string)) {
            throw new IllegalArgumentException("Invalid EQUALS rule - " + string + " is not a supported field");
        }
        this.field = string;
        this.value = string2;
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid EQUALS rule - expected two parameters but received " + stack.size());
        }
        String string = stack.pop().toString();
        String string2 = stack.pop().toString();
        return EqualsRule.getRule(string2, string);
    }

    public static Rule getRule(String string, String string2) {
        if (string.equalsIgnoreCase("LEVEL")) {
            return PartialTextMatchRule.getRule(string, string2);
        }
        if (string.equalsIgnoreCase("TIMESTAMP")) {
            return TimestampEqualsRule.getRule(string2);
        }
        return new EqualsRule(string, string2);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        Object object = resolver.getValue(this.field, loggingEvent);
        return object != null && object.toString().equals(this.value);
    }
}

