/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class Compress {
    static final Logger logger = Logger.getLogger(class$org$apache$log4j$rolling$helpers$Compress == null ? (class$org$apache$log4j$rolling$helpers$Compress = Compress.class$("org.apache.log4j.rolling.helpers.Compress")) : class$org$apache$log4j$rolling$helpers$Compress);
    public static final int NONE = 0;
    public static final int GZ = 1;
    public static final int ZIP = 2;
    public static final String NONE_STR = "NONE";
    public static final String GZ_STR = "GZ";
    public static final String ZIP_STR = "ZIP";
    static /* synthetic */ Class class$org$apache$log4j$rolling$helpers$Compress;

    public static void ZIPCompress(String nameOfFile2zip, String nameOfZippedFile) {
        File zippedFile;
        File file2zip = new File(nameOfFile2zip);
        if (!file2zip.exists()) {
            logger.warn("The file to compress named [" + nameOfFile2zip + "] does not exist.");
            return;
        }
        if (!nameOfZippedFile.endsWith(".zip")) {
            nameOfZippedFile = nameOfZippedFile + ".zip";
        }
        if ((zippedFile = new File(nameOfZippedFile)).exists()) {
            logger.warn("The target compressed file named [" + nameOfZippedFile + "] exist already.");
            return;
        }
        try {
            int n;
            FileOutputStream fos = new FileOutputStream(nameOfZippedFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            FileInputStream fis = new FileInputStream(nameOfFile2zip);
            ZipEntry zipEntry = new ZipEntry(file2zip.getName());
            zos.putNextEntry(zipEntry);
            byte[] inbuf = new byte[8102];
            while ((n = fis.read(inbuf)) != -1) {
                zos.write(inbuf, 0, n);
            }
            fis.close();
            zos.close();
            if (!file2zip.delete()) {
                logger.warn("Could not delete [" + nameOfFile2zip + "].");
            }
        }
        catch (Exception e) {
            logger.error("Error occured while compressing [" + nameOfFile2zip + "] into [" + nameOfZippedFile + "].", e);
        }
    }

    public static void GZCompress(String nameOfFile2gz) {
        Compress.GZCompress(nameOfFile2gz, nameOfFile2gz);
    }

    public static void GZCompress(String nameOfFile2gz, String nameOfgzedFile) {
        File gzedFile;
        File file2gz = new File(nameOfFile2gz);
        if (!file2gz.exists()) {
            logger.warn("The file to compress named [" + nameOfFile2gz + "] does not exist.");
            return;
        }
        if (!nameOfgzedFile.endsWith(".gz")) {
            nameOfgzedFile = nameOfgzedFile + ".gz";
        }
        if ((gzedFile = new File(nameOfgzedFile)).exists()) {
            logger.warn("The target compressed file named [" + nameOfgzedFile + "] exist already.");
            return;
        }
        try {
            int n;
            FileOutputStream fos = new FileOutputStream(nameOfgzedFile);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            FileInputStream fis = new FileInputStream(nameOfFile2gz);
            byte[] inbuf = new byte[8102];
            while ((n = fis.read(inbuf)) != -1) {
                gzos.write(inbuf, 0, n);
            }
            fis.close();
            gzos.close();
            if (!file2gz.delete()) {
                logger.warn("Could not delete [" + nameOfFile2gz + "].");
            }
        }
        catch (Exception e) {
            logger.error("Error occured while compressing [" + nameOfFile2gz + "] into [" + nameOfgzedFile + "].", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

