/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.net.XMLSocketNode;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class XMLSocketReceiver
extends Receiver
implements Runnable,
PortBased,
Pauseable {
    protected boolean active = false;
    private boolean paused;
    protected String decoder = "org.apache.log4j.xml.XMLDecoder";
    private ServerSocket serverSocket;
    private List socketList = new Vector();
    private Thread rThread;
    public static final int DEFAULT_PORT = 4448;
    protected int port = 4448;

    public XMLSocketReceiver() {
    }

    public XMLSocketReceiver(int _port) {
        this.port = _port;
    }

    public XMLSocketReceiver(int _port, LoggerRepository _repository) {
        this.port = _port;
        this.repository = _repository;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String _decoder) {
        this.decoder = _decoder;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean b) {
        this.paused = b;
    }

    public boolean isEquivalent(Plugin testPlugin) {
        if (testPlugin != null && testPlugin instanceof XMLSocketReceiver) {
            XMLSocketReceiver sReceiver = (XMLSocketReceiver)testPlugin;
            return this.port == sReceiver.getPort() && super.isEquivalent(testPlugin);
        }
        return false;
    }

    public int hashCode() {
        int result = 37 * (this.repository != null ? this.repository.hashCode() : 0);
        result = result * 37 + this.port;
        return result * 37 + (this.getName() != null ? this.getName().hashCode() : 0);
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public void activateOptions() {
        if (!this.isActive()) {
            this.rThread = new Thread(this);
            this.rThread.setDaemon(true);
            this.rThread.start();
            this.active = true;
        }
    }

    public synchronized void shutdown() {
        this.active = false;
        if (this.rThread != null) {
            this.rThread.interrupt();
            this.rThread = null;
        }
        this.doShutdown();
    }

    private synchronized void doShutdown() {
        this.active = false;
        LogLog.debug(this.getName() + " doShutdown called");
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
    }

    private void closeServerSocket() {
        LogLog.debug(this.getName() + " closing server socket");
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    private synchronized void closeAllAcceptedSockets() {
        for (int x = 0; x < this.socketList.size(); ++x) {
            try {
                ((Socket)this.socketList.get(x)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socketList.clear();
    }

    public void run() {
        LogLog.debug("performing socket cleanup prior to entering loop for " + this.name);
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
        LogLog.debug("socket cleanup complete for " + this.name);
        this.active = true;
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Exception e) {
            LogLog.error("error starting SocketReceiver (" + this.getName() + "), receiver did not start", e);
            this.active = false;
            this.doShutdown();
            return;
        }
        Socket socket = null;
        try {
            LogLog.debug("in run-about to enter while isactiveloop");
            this.active = true;
            while (!this.rThread.isInterrupted()) {
                if (socket != null) {
                    LogLog.debug("socket not null - creating and starting socketnode");
                    this.socketList.add(socket);
                    XMLSocketNode node = new XMLSocketNode(this.decoder, socket, this);
                    new Thread(node).start();
                    socket = null;
                }
                LogLog.debug("waiting to accept socket");
                socket = this.serverSocket.accept();
                LogLog.debug("accepted socket");
            }
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception e) {
            LogLog.warn("socket server disconnected, stopping");
        }
    }

    public void doPost(LoggingEvent event) {
        if (!this.isPaused()) {
            super.doPost(event);
        }
    }
}

