/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.AddressBased;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;

public class MulticastReceiver
extends Receiver
implements PortBased,
AddressBased,
Pauseable {
    private static final int PACKET_LENGTH = 16384;
    private boolean isActive = false;
    private int port;
    private String address;
    private String encoding;
    private MulticastSocket socket = null;
    private String decoder = "org.apache.log4j.xml.XMLDecoder";
    private Decoder decoderImpl;
    private MulticastHandlerThread handlerThread;
    private MulticastReceiverThread receiverThread;
    private boolean paused;

    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String decoder) {
        this.decoder = decoder;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized void shutdown() {
        this.isActive = false;
        this.handlerThread.interrupt();
        this.receiverThread.interrupt();
        this.socket.close();
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean b) {
        this.paused = b;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    public void activateOptions() {
        InetAddress addr = null;
        try {
            Class<?> c = Class.forName(this.decoder);
            Object o = c.newInstance();
            if (o instanceof Decoder) {
                this.decoderImpl = (Decoder)o;
            }
        }
        catch (ClassNotFoundException cnfe) {
            LogLog.warn("Unable to find decoder", cnfe);
        }
        catch (IllegalAccessException iae) {
            LogLog.warn("Could not construct decoder", iae);
        }
        catch (InstantiationException ie) {
            LogLog.warn("Could not construct decoder", ie);
        }
        try {
            addr = InetAddress.getByName(this.address);
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        try {
            this.isActive = true;
            this.socket = new MulticastSocket(this.port);
            this.socket.joinGroup(addr);
            this.receiverThread = new MulticastReceiverThread();
            this.receiverThread.start();
            this.handlerThread = new MulticastHandlerThread();
            this.handlerThread.start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    class MulticastReceiverThread
    extends Thread {
        public MulticastReceiverThread() {
            this.setDaemon(true);
        }

        public void run() {
            MulticastReceiver.this.isActive = true;
            byte[] b = new byte[16384];
            DatagramPacket p = new DatagramPacket(b, b.length);
            while (MulticastReceiver.this.isActive) {
                try {
                    MulticastReceiver.this.socket.receive(p);
                    if (MulticastReceiver.this.encoding == null) {
                        MulticastReceiver.this.handlerThread.append(new String(p.getData(), 0, p.getLength()));
                        continue;
                    }
                    MulticastReceiver.this.handlerThread.append(new String(p.getData(), 0, p.getLength(), MulticastReceiver.this.encoding));
                }
                catch (SocketException se) {
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            LogLog.debug(MulticastReceiver.this.getName() + "'s thread is ending.");
        }
    }

    class MulticastHandlerThread
    extends Thread {
        private List list = new ArrayList();

        public MulticastHandlerThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(String data) {
            List list = this.list;
            synchronized (list) {
                this.list.add(data);
                this.list.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList list2 = new ArrayList();
            while (this.isAlive()) {
                Object iter;
                List list = this.list;
                synchronized (list) {
                    try {
                        while (this.list.size() == 0) {
                            this.list.wait();
                        }
                        if (this.list.size() > 0) {
                            list2.addAll(this.list);
                            this.list.clear();
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (list2.size() > 0) {
                    iter = list2.iterator();
                    while (iter.hasNext()) {
                        String data = (String)iter.next();
                        Vector v = MulticastReceiver.this.decoderImpl.decodeEvents(data.trim());
                        if (v == null) continue;
                        Iterator eventIter = v.iterator();
                        while (eventIter.hasNext()) {
                            if (MulticastReceiver.this.isPaused()) continue;
                            MulticastReceiver.this.doPost((LoggingEvent)eventIter.next());
                        }
                    }
                    list2.clear();
                    continue;
                }
                try {
                    iter = this;
                    synchronized (iter) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

