/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.layout;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class EventDetailLayout
extends Layout {
    private PatternLayout patternLayout = new PatternLayout();

    public void setConversionPattern(String string) {
        this.patternLayout.setConversionPattern(string);
        this.patternLayout.activateOptions();
    }

    public String getConversionPattern() {
        return this.patternLayout.getConversionPattern();
    }

    public String getFooter() {
        return "";
    }

    public String getHeader() {
        return "";
    }

    private static String escape(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static LoggingEvent copyForHTML(LoggingEvent loggingEvent) {
        String string = EventDetailLayout.escape(loggingEvent.getFQNOfLoggerClass());
        Logger logger = Logger.getLogger(loggingEvent.getLoggerName());
        String string2 = loggingEvent.getThreadName();
        String string3 = EventDetailLayout.escape(loggingEvent.getMessage().toString());
        String string4 = loggingEvent.getNDC();
        LocationInfo locationInfo = null;
        if (loggingEvent.locationInformationExists()) {
            locationInfo = EventDetailLayout.formatLocationInfo(loggingEvent);
        }
        Hashtable hashtable = EventDetailLayout.formatProperties(loggingEvent);
        LoggingEvent loggingEvent2 = new LoggingEvent();
        loggingEvent2.setLogger(logger);
        loggingEvent2.setTimeStamp(loggingEvent.getTimeStamp());
        loggingEvent2.setLevel(loggingEvent.getLevel());
        loggingEvent2.setThreadName(string2);
        loggingEvent2.setMessage(string3);
        loggingEvent2.setNDC(string4);
        loggingEvent2.setThrowableInformation(loggingEvent.getThrowableInformation());
        loggingEvent2.setLocationInformation(locationInfo);
        loggingEvent2.setProperties(hashtable);
        return loggingEvent2;
    }

    private static LocationInfo formatLocationInfo(LoggingEvent loggingEvent) {
        LocationInfo locationInfo = loggingEvent.getLocationInformation();
        LocationInfo locationInfo2 = new LocationInfo(EventDetailLayout.escape(locationInfo.getFileName()), EventDetailLayout.escape(locationInfo.getClassName()), EventDetailLayout.escape(locationInfo.getMethodName()), EventDetailLayout.escape(locationInfo.getLineNumber()));
        return locationInfo2;
    }

    private static Hashtable formatProperties(LoggingEvent loggingEvent) {
        Set set = loggingEvent.getPropertyKeySet();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = loggingEvent.getProperty(e.toString());
            hashtable.put(EventDetailLayout.escape(e.toString()), EventDetailLayout.escape(string.toString()));
        }
        return hashtable;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    public void format(Writer writer, LoggingEvent loggingEvent) throws IOException {
        this.patternLayout.format(writer, EventDetailLayout.copyForHTML(loggingEvent));
    }
}

