/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.color;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.chainsaw.color.Colorizer;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class RuleColorizer
implements Colorizer {
    private static final String DEFAULT_NAME = "Default";
    private Map rules;
    private final PropertyChangeSupport colorChangeSupport = new PropertyChangeSupport(this);
    private Map defaultRules = new HashMap();
    private String currentRuleSet = "Default";
    private Rule findRule;
    private Rule loggerRule;
    private final Color FIND_FOREGROUND = Color.white;
    private final Color FIND_BACKGROUND = Color.black;
    private final Color LOGGER_FOREGROUND = Color.white;
    private final Color LOGGER_BACKGROUND = Color.black;

    public RuleColorizer() {
        ArrayList<ColorRule> arrayList = new ArrayList<ColorRule>();
        String string = "level == FATAL || level == ERROR";
        arrayList.add(new ColorRule(string, ExpressionRule.getRule(string), new Color(147, 22, 0), Color.white));
        string = "level == WARN";
        arrayList.add(new ColorRule(string, ExpressionRule.getRule(string), Color.yellow.brighter(), Color.black));
        this.defaultRules.put(DEFAULT_NAME, arrayList);
        this.setRules(this.defaultRules);
    }

    public void setLoggerRule(Rule rule) {
        this.loggerRule = rule;
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public void setFindRule(Rule rule) {
        this.findRule = rule;
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public void setRules(Map map) {
        this.rules = map;
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public Map getRules() {
        return this.rules;
    }

    public void addRules(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.rules.containsKey(entry.getKey())) {
                ((List)this.rules.get(entry.getKey())).addAll((List)entry.getValue());
                continue;
            }
            this.rules.put(entry.getKey(), entry.getValue());
        }
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public void addRule(String string, ColorRule colorRule) {
        if (this.rules.containsKey(string)) {
            ((List)this.rules.get(string)).add(colorRule);
        } else {
            ArrayList<ColorRule> arrayList = new ArrayList<ColorRule>();
            arrayList.add(colorRule);
            this.rules.put(string, arrayList);
        }
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public void removeRule(String string, String string2) {
        if (this.rules.containsKey(string)) {
            List list = (List)this.rules.get(string);
            for (int i = 0; i < list.size(); ++i) {
                ColorRule colorRule = (ColorRule)list.get(i);
                if (!colorRule.getExpression().equals(string2)) continue;
                list.remove(colorRule);
                return;
            }
        }
    }

    public void setCurrentRuleSet(String string) {
        this.currentRuleSet = string;
    }

    public Color getBackgroundColor(LoggingEvent loggingEvent) {
        if (this.findRule != null && this.findRule.evaluate(loggingEvent)) {
            return this.FIND_BACKGROUND;
        }
        if (this.loggerRule != null && this.loggerRule.evaluate(loggingEvent)) {
            return this.LOGGER_BACKGROUND;
        }
        if (this.rules.containsKey(this.currentRuleSet)) {
            List list = (List)this.rules.get(this.currentRuleSet);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ColorRule colorRule = (ColorRule)iterator.next();
                if (colorRule.getBackgroundColor() == null || !colorRule.evaluate(loggingEvent)) continue;
                return colorRule.getBackgroundColor();
            }
        }
        return null;
    }

    public Color getForegroundColor(LoggingEvent loggingEvent) {
        if (this.findRule != null && this.findRule.evaluate(loggingEvent)) {
            return this.FIND_FOREGROUND;
        }
        if (this.loggerRule != null && this.loggerRule.evaluate(loggingEvent)) {
            return this.LOGGER_FOREGROUND;
        }
        if (this.rules.containsKey(this.currentRuleSet)) {
            List list = (List)this.rules.get(this.currentRuleSet);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ColorRule colorRule = (ColorRule)iterator.next();
                if (colorRule.getForegroundColor() == null || !colorRule.evaluate(loggingEvent)) continue;
                return colorRule.getForegroundColor();
            }
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.colorChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.colorChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.colorChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }
}

