/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.ExpressionRuleContext;
import org.apache.log4j.rule.Rule;

public class ColorPanel
extends JPanel {
    private RuleColorizer colorizer;
    private JPanel ruleSetsPanel;
    private JPanel rulesPanel;
    private FilterModel filterModel;
    private DefaultTableModel tableModel;
    private JScrollPane tableScrollPane;
    private JTable table;
    private ActionListener closeListener;
    private JLabel statusBar;
    private Vector columns;
    private String currentRuleSet = "Default";
    private DefaultListModel ruleSetListModel;

    public ColorPanel(RuleColorizer ruleColorizer, FilterModel filterModel) {
        super(new BorderLayout());
        this.colorizer = ruleColorizer;
        this.filterModel = filterModel;
        ruleColorizer.addPropertyChangeListener("colorrule", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ColorPanel.this.updateColors();
            }
        });
        this.tableModel = new DefaultTableModel();
        this.table = new JTable(this.tableModel);
        this.ruleSetListModel = new DefaultListModel();
        this.columns = new Vector();
        this.columns.add("Expression");
        this.columns.add("Background");
        this.columns.add("Foreground");
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.tableScrollPane = new JScrollPane(this.table);
        Vector vector = this.getColorizerVector();
        this.tableModel.setDataVector(vector, this.columns);
        this.table.sizeColumnsToFit(0);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setMaxWidth(80);
        this.table.getColumnModel().getColumn(2).setMaxWidth(80);
        this.configureTable();
        this.statusBar = new JLabel("Ruleset support not yet implemented");
        this.ruleSetsPanel = this.buildRuleSetsPanel();
        this.ruleSetsPanel.setAlignmentX(0.0f);
        this.rulesPanel = this.buildRulesPanel();
        this.rulesPanel.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalStrut(10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(new JSeparator());
        jPanel3.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = this.buildClosePanel();
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(this.statusBar);
        jPanel3.add(jPanel5);
        jPanel.add((Component)this.rulesPanel, "Center");
        jPanel.add((Component)jPanel3, "South");
        jPanel2.add(jPanel);
        this.add((Component)this.ruleSetsPanel, "West");
        this.add((Component)jPanel2, "Center");
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public static void main(String[] stringArray) {
        FilterModel filterModel = new FilterModel();
        RuleColorizer ruleColorizer = new RuleColorizer();
        ColorPanel colorPanel = new ColorPanel(ruleColorizer, filterModel);
        JFrame jFrame = new JFrame();
        colorPanel.setCloseActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(colorPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void updateColors() {
        this.tableModel.getDataVector().clear();
        this.tableModel.getDataVector().addAll(this.getColorizerVector());
    }

    private Vector getColorizerVector() {
        Vector vector = new Vector();
        Map map = this.colorizer.getRules();
        Iterator iterator = map.entrySet().iterator();
        this.ruleSetListModel.removeAllElements();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.ruleSetListModel.addElement(entry.getKey());
            if (!entry.getKey().equals(this.currentRuleSet)) continue;
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                ColorRule colorRule = (ColorRule)iterator2.next();
                Vector<Object> vector2 = new Vector<Object>();
                vector2.add(colorRule.getExpression());
                vector2.add(colorRule.getBackgroundColor());
                vector2.add(colorRule.getForegroundColor());
                vector.add(vector2);
            }
        }
        return vector;
    }

    private Vector getDefaultColors() {
        Vector<Color> vector = new Vector<Color>();
        vector.add(Color.white);
        vector.add(Color.black);
        vector.add(new Color(0, 153, 0));
        vector.add(new Color(0, 204, 51));
        vector.add(new Color(153, 255, 153));
        vector.add(new Color(51, 255, 0));
        vector.add(new Color(204, 255, 204));
        vector.add(new Color(0, 153, 153));
        vector.add(new Color(0, 204, 204));
        vector.add(new Color(153, 102, 0));
        vector.add(new Color(102, 102, 0));
        vector.add(new Color(153, 153, 0));
        vector.add(new Color(204, 204, 0));
        vector.add(new Color(255, 255, 0));
        vector.add(new Color(255, 255, 204));
        vector.add(new Color(255, 153, 51));
        vector.add(new Color(204, 0, 51));
        vector.add(new Color(255, 51, 51));
        vector.add(new Color(255, 153, 153));
        vector.add(new Color(255, 204, 204));
        vector.add(new Color(204, 0, 204));
        vector.add(new Color(255, 51, 255));
        vector.add(new Color(153, 51, 255));
        vector.add(new Color(0, 0, 153));
        vector.add(new Color(0, 0, 255));
        vector.add(new Color(51, 153, 255));
        vector.add(new Color(153, 153, 255));
        vector.add(new Color(204, 204, 255));
        vector.add(new Color(102, 255, 255));
        vector.add(new Color(102, 102, 102));
        vector.add(new Color(153, 153, 153));
        vector.add(new Color(204, 204, 204));
        return vector;
    }

    private void configureTable() {
        this.table.setToolTipText("Double click to edit");
        this.table.setRowHeight(20);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        Vector vector = this.getDefaultColors();
        Vector vector2 = this.getDefaultColors();
        vector.add("Browse...");
        vector2.add("Browse...");
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setMaximumRowCount(15);
        jComboBox.setRenderer(new ColorListCellRenderer());
        JComboBox jComboBox2 = new JComboBox(vector2);
        jComboBox2.setMaximumRowCount(15);
        jComboBox2.setRenderer(new ColorListCellRenderer());
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(jComboBox2);
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new ExpressionRuleContext(this.filterModel, jTextField));
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jTextField));
        this.table.getColumnModel().getColumn(1).setCellEditor(defaultCellEditor);
        this.table.getColumnModel().getColumn(2).setCellEditor(defaultCellEditor2);
        jComboBox.addItemListener(new ColorItemListener(jComboBox));
        jComboBox2.addItemListener(new ColorItemListener(jComboBox2));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new ExpressionTableCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ColorTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new ColorTableCellRenderer());
    }

    public void setCloseActionListener(ActionListener actionListener) {
        this.closeListener = actionListener;
    }

    public void hidePanel() {
        if (this.closeListener != null) {
            this.closeListener.actionPerformed(null);
        }
    }

    void applyRules(String string) {
        this.table.getColumnModel().getColumn(0).getCellEditor().stopCellEditing();
        ArrayList<ColorRule> arrayList = new ArrayList<ColorRule>();
        Vector<Vector> vector = this.tableModel.getDataVector();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = vector.elementAt(i);
            try {
                Rule rule = ExpressionRule.getRule((String)vector2.elementAt(0));
                Color color = this.getBackground();
                Color color2 = this.getForeground();
                if (vector2.elementAt(1) instanceof Color) {
                    color = (Color)vector2.elementAt(1);
                }
                if (vector2.elementAt(2) instanceof Color) {
                    color2 = (Color)vector2.elementAt(2);
                }
                ColorRule colorRule = new ColorRule((String)vector2.elementAt(0), rule, color, color2);
                arrayList.add(colorRule);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!stringBuffer.toString().equals("")) {
                    stringBuffer.append("<br>");
                }
                stringBuffer.append(illegalArgumentException.getMessage());
            }
        }
        if (stringBuffer.toString().equals("")) {
            ((ExpressionTableCellRenderer)this.table.getColumnModel().getColumn(0).getCellRenderer()).setToolTipText("Double click to edit");
            this.statusBar.setText("");
        } else {
            this.statusBar.setText("Errors - see expression tooltip");
            ((ExpressionTableCellRenderer)this.table.getColumnModel().getColumn(0).getCellRenderer()).setToolTipText("<html>" + stringBuffer.toString() + "</html>");
        }
        HashMap<String, ArrayList<ColorRule>> hashMap = new HashMap<String, ArrayList<ColorRule>>();
        hashMap.put(string, arrayList);
        this.colorizer.setRules(hashMap);
    }

    JPanel buildClosePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Apply");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorPanel.this.applyRules(ColorPanel.this.currentRuleSet);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorPanel.this.hidePanel();
            }
        });
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jButton2);
        return jPanel;
    }

    JPanel buildUpDownPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(5, 1));
        final JButton jButton = new JButton(ChainsawIcons.ICON_UP);
        jButton.setToolTipText("Move selected rule up");
        final JButton jButton2 = new JButton(ChainsawIcons.ICON_DOWN);
        jButton2.setToolTipText("Move selected rule down");
        jButton.setEnabled(false);
        jButton2.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                    if (n < 0) {
                        jButton2.setEnabled(false);
                        jButton.setEnabled(false);
                    } else if (n == 0 && ColorPanel.this.tableModel.getRowCount() == 1) {
                        jButton2.setEnabled(false);
                        jButton.setEnabled(false);
                    } else if (n == 0 && ColorPanel.this.tableModel.getRowCount() > 1) {
                        jButton2.setEnabled(true);
                        jButton.setEnabled(false);
                    } else if (n == ColorPanel.this.tableModel.getRowCount() - 1) {
                        jButton2.setEnabled(false);
                        jButton.setEnabled(true);
                    } else {
                        jButton2.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jButton2);
        jPanel2.add(new JLabel(""));
        jPanel2.add(jPanel3);
        jPanel2.add(new JLabel(""));
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                if (n > 0) {
                    Vector<Vector> vector = ColorPanel.this.tableModel.getDataVector();
                    Vector vector2 = vector.elementAt(n);
                    ColorPanel.this.tableModel.removeRow(n);
                    ColorPanel.this.tableModel.insertRow(--n, vector2);
                    ColorPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                if (n > -1 && n < ColorPanel.this.tableModel.getRowCount() - 1) {
                    Vector<Vector> vector = ColorPanel.this.tableModel.getDataVector();
                    Vector vector2 = vector.elementAt(n);
                    ColorPanel.this.tableModel.removeRow(n);
                    ColorPanel.this.tableModel.insertRow(++n, vector2);
                    ColorPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        return jPanel;
    }

    JPanel buildRuleSetsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("RuleSets:");
        jPanel.add((Component)jLabel, "North");
        JList jList = new JList(this.ruleSetListModel);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jList.setEnabled(false);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("New");
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton("Delete");
        jButton2.setEnabled(false);
        jPanel4.add(jButton2);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    JPanel buildRulesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel = new JLabel("RuleSet Name:");
        jPanel2.add(jLabel);
        JTextField jTextField = new JTextField(20);
        jTextField.setText(this.currentRuleSet);
        jTextField.setAlignmentX(0.0f);
        jTextField.setEnabled(false);
        jPanel2.add(jTextField);
        jPanel2.add(Box.createVerticalStrut(10));
        JLabel jLabel2 = new JLabel("Rules:");
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 2));
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("New");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPanel.this.table.getSelectedRow();
                Vector<Object> vector = new Vector<Object>();
                vector.add("");
                vector.add(Color.white);
                vector.add(Color.black);
                if (n < 0) {
                    ColorPanel.this.tableModel.addRow(vector);
                    n = ColorPanel.this.table.getRowCount() - 1;
                } else {
                    ColorPanel.this.tableModel.insertRow(n, vector);
                }
                ColorPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        });
        jPanel4.add(jButton);
        JPanel jPanel5 = new JPanel();
        final JButton jButton2 = new JButton("Delete");
        jButton2.setEnabled(false);
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                if (n > -1 && n < ColorPanel.this.table.getRowCount()) {
                    ColorPanel.this.tableModel.removeRow(n);
                    if (n > 0) {
                        --n;
                    }
                    if (ColorPanel.this.tableModel.getRowCount() > 0) {
                        ColorPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                    if (n < 0) {
                        jButton2.setEnabled(false);
                    } else {
                        jButton2.setEnabled(true);
                    }
                }
            }
        });
        jPanel5.add(jButton2);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)this.tableScrollPane, "Center");
        jPanel6.add((Component)this.buildUpDownPanel(), "East");
        jPanel.add((Component)jPanel6, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    class SelectedIcon
    implements Icon {
        private boolean isSelected;
        private int width = 9;
        private int height = 18;
        private int[] xPoints = new int[4];
        private int[] yPoints = new int[4];

        public SelectedIcon(boolean bl) {
            this.isSelected = bl;
            this.xPoints[0] = 0;
            this.yPoints[0] = -1;
            this.xPoints[1] = 0;
            this.yPoints[1] = this.height;
            this.xPoints[2] = this.width;
            this.yPoints[2] = this.height / 2;
            this.xPoints[3] = this.width;
            this.yPoints[3] = this.height / 2 - 1;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.isSelected) {
                int n3 = this.xPoints.length;
                int[] nArray = new int[n3];
                int[] nArray2 = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.xPoints[i] + n;
                    nArray2[i] = this.yPoints[i] + n2;
                }
                graphics.setColor(Color.black);
                graphics.fillPolygon(nArray, nArray2, n3);
            }
        }
    }

    class ExpressionTableCellRenderer
    implements TableCellRenderer {
        JPanel panel = new JPanel();
        JLabel expressionLabel = new JLabel();
        JLabel iconLabel = new JLabel();
        Icon selectedIcon = new SelectedIcon(true);
        Icon unselectedIcon = new SelectedIcon(false);

        ExpressionTableCellRenderer() {
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.panel.setOpaque(true);
            this.panel.add(this.iconLabel);
            this.panel.add(Box.createHorizontalStrut(5));
            this.panel.add(this.expressionLabel);
        }

        void setToolTipText(String string) {
            this.panel.setToolTipText(string);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Vector<Vector> vector = ColorPanel.this.tableModel.getDataVector();
            Vector vector2 = vector.elementAt(n);
            this.expressionLabel.setText(object.toString());
            if (vector2.elementAt(1) instanceof Color) {
                this.expressionLabel.setBackground((Color)vector2.elementAt(1));
                this.panel.setBackground((Color)vector2.elementAt(1));
            }
            if (vector2.elementAt(2) instanceof Color) {
                this.expressionLabel.setForeground((Color)vector2.elementAt(2));
                this.panel.setForeground((Color)vector2.elementAt(2));
            }
            if (bl) {
                this.iconLabel.setIcon(this.selectedIcon);
            } else {
                this.iconLabel.setIcon(this.unselectedIcon);
            }
            return this.panel;
        }
    }

    class ColorTableCellRenderer
    implements TableCellRenderer {
        Border border;
        JPanel panel = new JPanel();

        ColorTableCellRenderer() {
            this.panel.setOpaque(true);
        }

        public Color getCurrentColor() {
            return this.panel.getBackground();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Color) {
                this.panel.setBackground((Color)object);
            }
            if (this.border == null) {
                this.border = BorderFactory.createMatteBorder(2, 2, 2, 2, ColorPanel.this.table.getBackground());
            }
            this.panel.setBorder(this.border);
            return this.panel;
        }
    }

    class ColorItemListener
    implements ItemListener {
        JComboBox box;
        JDialog dialog;
        JColorChooser colorChooser;
        Color lastColor;

        ColorItemListener(JComboBox jComboBox) {
            this.box = jComboBox;
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(jComboBox, "Pick a Color", true, this.colorChooser, new ActionListener(this, jComboBox){
                private final /* synthetic */ JComboBox val$box;
                private final /* synthetic */ ColorItemListener this$1;
                {
                    this.this$1 = colorItemListener;
                    this.val$box = jComboBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$box.insertItemAt(this.this$1.colorChooser.getColor(), 0);
                    this.val$box.setSelectedIndex(0);
                }
            }, new ActionListener(this, jComboBox){
                private final /* synthetic */ JComboBox val$box;
                private final /* synthetic */ ColorItemListener this$1;
                {
                    this.this$1 = colorItemListener;
                    this.val$box = jComboBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$box.setSelectedItem(this.this$1.lastColor);
                }
            });
            this.dialog.setDefaultCloseOperation(0);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (this.box.getSelectedItem() instanceof Color) {
                    this.box.setBackground((Color)this.box.getSelectedItem());
                    ColorPanel.this.repaint();
                } else {
                    this.box.setBackground(Color.white);
                    this.colorChooser.setColor((Color)ColorPanel.this.table.getValueAt(ColorPanel.this.table.getSelectedRow(), ColorPanel.this.table.getSelectedColumn()));
                    this.lastColor = (Color)ColorPanel.this.table.getValueAt(ColorPanel.this.table.getSelectedRow(), ColorPanel.this.table.getSelectedColumn());
                    this.dialog.setVisible(true);
                }
            }
        }
    }

    class ColorListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        ColorListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(" ");
            if (bl && n > -1) {
                this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            if (object instanceof Color) {
                this.setBackground((Color)object);
            } else {
                this.setBackground(Color.white);
                if (object != null) {
                    this.setText(object.toString());
                }
            }
            return this;
        }
    }
}

