/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.color.Colorizer;
import org.apache.log4j.chainsaw.icons.LevelIconFactory;
import org.apache.log4j.helpers.ISO8601DateFormat;
import org.apache.log4j.spi.LoggingEvent;

public class TableColorizingRenderer
extends DefaultTableCellRenderer {
    private static final DateFormat DATE_FORMATTER = new ISO8601DateFormat(Calendar.getInstance().getTimeZone());
    private static final Map iconMap = LevelIconFactory.getInstance().getLevelToIconMap();
    private Colorizer colorizer;
    private final JLabel idComponent = new JLabel();
    private final JLabel levelComponent = new JLabel();
    private boolean levelUseIcons = true;
    private DateFormat dateFormatInUse = DATE_FORMATTER;
    private int loggerPrecision = 0;
    private boolean toolTipsVisible;

    public TableColorizingRenderer(Colorizer colorizer) {
        this.colorizer = colorizer;
        this.idComponent.setBorder(BorderFactory.createRaisedBevelBorder());
        this.idComponent.setBackground(Color.gray);
        this.idComponent.setHorizontalAlignment(0);
        this.idComponent.setOpaque(true);
        this.levelComponent.setOpaque(true);
        this.levelComponent.setHorizontalAlignment(0);
        this.levelComponent.setText("");
    }

    public void setToolTipsVisible(boolean bl) {
        this.toolTipsVisible = bl;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        object = this.formatField(object);
        Color color = null;
        Color color2 = null;
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        int n3 = jTable.getColumnModel().getColumn(n2).getModelIndex() + 1;
        switch (n3) {
            case 12: {
                this.idComponent.setText(object.toString());
                this.idComponent.setForeground(component.getForeground());
                this.idComponent.setBackground(component.getBackground());
                component = this.idComponent;
                break;
            }
            case 7: {
                if (!(object instanceof String[])) break;
                ((JLabel)component).setText(((String[])object)[0]);
                break;
            }
            case 1: {
                if (this.loggerPrecision == 0) break;
                object2 = object.toString();
                int n4 = -1;
                for (int i = 0; i < this.loggerPrecision && (n4 = ((String)object2).indexOf(".", n4 + 1)) >= 0; ++i) {
                }
                ((JLabel)component).setText(((String)object2).substring(n4 + 1));
                break;
            }
            case 3: {
                if (this.levelUseIcons) {
                    this.levelComponent.setIcon((Icon)iconMap.get(object.toString()));
                    if (this.levelComponent.getIcon() != null) {
                        this.levelComponent.setText("");
                    }
                    if (this.toolTipsVisible) {
                        this.levelComponent.setToolTipText(((JLabel)component).getToolTipText());
                    } else {
                        this.levelComponent.setToolTipText(object.toString());
                    }
                } else {
                    this.levelComponent.setIcon(null);
                    this.levelComponent.setText(object.toString());
                }
                this.levelComponent.setForeground(component.getForeground());
                this.levelComponent.setBackground(component.getBackground());
                component = this.levelComponent;
                break;
            }
        }
        if (bl) {
            return component;
        }
        if (this.getColorizer() != null) {
            object2 = (EventContainer)jTable.getModel();
            LoggingEvent loggingEvent = object2.getRow(n);
            if (loggingEvent == null) {
                return component;
            }
            color = this.getColorizer().getBackgroundColor(loggingEvent);
            color2 = this.getColorizer().getForegroundColor(loggingEvent);
        }
        if (color == null) {
            color = n % 2 != 0 ? ChainsawConstants.COLOR_ODD_ROW : ChainsawConstants.COLOR_EVEN_ROW;
        }
        if (color2 == null) {
            color2 = Color.black;
        }
        component.setBackground(color);
        component.setForeground(color2);
        return component;
    }

    void setDateFormatter(DateFormat dateFormat) {
        this.dateFormatInUse = dateFormat;
    }

    void setLoggerPrecision(String string) {
        try {
            this.loggerPrecision = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.loggerPrecision = 0;
        }
    }

    private Object formatField(Object object) {
        if (!(object instanceof Date)) {
            return object;
        }
        return this.dateFormatInUse.format((Date)object);
    }

    public void setColorizer(Colorizer colorizer) {
        this.colorizer = colorizer;
    }

    public Colorizer getColorizer() {
        return this.colorizer;
    }

    public boolean isLevelUseIcons() {
        return this.levelUseIcons;
    }

    public void setLevelUseIcons(boolean bl) {
        this.levelUseIcons = bl;
    }
}

