/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.chainsaw.LogPanelLoggerTreeModel;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

final class LoggerNameTreePanel
extends JPanel
implements Rule {
    private static final int WARN_DEPTH = 4;
    private LoggerNameTreeCellRenderer cellRenderer = new LoggerNameTreeCellRenderer();
    private final Action clearIgnoreListAction;
    private final Action closeAction;
    private final JButton closeButton = new SmallButton();
    private final Action collapseAction;
    private final JButton collapseButton = new SmallButton();
    private final Action editLoggerAction;
    private final JButton editLoggerButton = new SmallButton();
    private final Action expandAction;
    private final JButton expandButton = new SmallButton();
    private final Action focusOnAction;
    private final SmallToggleButton focusOnLoggerButton = new SmallToggleButton();
    private final Set hiddenSet = new HashSet();
    private final Action hideAction;
    private final LogPanelPreferenceModel preferenceModel;
    private final JList ignoreList = new JList();
    private final JScrollPane ignoreListScroll = new JScrollPane(this.ignoreList);
    private final JDialog ignoreDialog = new JDialog();
    private final JLabel ignoreSummary = new JLabel("0 hidden loggers");
    private final SmallToggleButton ignoreLoggerButton = new SmallToggleButton();
    private final EventListenerList listenerList = new EventListenerList();
    private final JTree logTree;
    private final LogPanelLoggerTreeModel logTreeModel;
    private final PopupListener popupListener;
    private final LoggerTreePopupMenu popupMenu;
    private final Rule ruleDelegate;
    private Rule colorRuleDelegate;
    private final JScrollPane scrollTree;
    private final JToolBar toolbar = new JToolBar();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    LoggerNameTreePanel(LogPanelLoggerTreeModel logPanelLoggerTreeModel, LogPanelPreferenceModel logPanelPreferenceModel) {
        this.logTreeModel = logPanelLoggerTreeModel;
        this.preferenceModel = logPanelPreferenceModel;
        this.setLayout(new BorderLayout());
        this.ruleDelegate = new AbstractRule(){

            public boolean evaluate(LoggingEvent loggingEvent) {
                boolean bl;
                String string = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                if (string == null) {
                    return true;
                }
                boolean bl2 = LoggerNameTreePanel.this.getHiddenSet().contains(loggingEvent.getLoggerName());
                boolean bl3 = bl = loggingEvent.getLoggerName() != null && !bl2;
                if (bl && LoggerNameTreePanel.this.isFocusOnSelected()) {
                    bl = bl && loggingEvent.getLoggerName() != null && (loggingEvent.getLoggerName().startsWith(string + ".") || loggingEvent.getLoggerName().endsWith(string));
                }
                return bl;
            }
        };
        this.colorRuleDelegate = new AbstractRule(){

            public boolean evaluate(LoggingEvent loggingEvent) {
                boolean bl = LoggerNameTreePanel.this.getHiddenSet().contains(loggingEvent.getLoggerName());
                String string = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                if (!(LoggerNameTreePanel.this.isFocusOnSelected() || bl || string == null || "".equals(string))) {
                    return loggingEvent.getLoggerName().startsWith(string + ".") || loggingEvent.getLoggerName().endsWith(string);
                }
                return false;
            }
        };
        this.logTree = new JTree(logPanelLoggerTreeModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                if (mouseEvent == null) {
                    return null;
                }
                TreePath treePath = LoggerNameTreePanel.this.logTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                String string = LoggerNameTreePanel.this.getLoggerName(treePath);
                if (LoggerNameTreePanel.this.hiddenSet.contains(string)) {
                    string = string + " (you are ignoring this logger)";
                }
                return string;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.logTree);
        this.logTree.setCellRenderer(this.cellRenderer);
        logPanelLoggerTreeModel.addTreeModelListener(new TreeModelListener(){
            private boolean latched = false;

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                if (!this.latched) {
                    LoggerNameTreePanel.this.ensureRootExpanded();
                    this.latched = true;
                }
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        this.logTree.setEditable(false);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.logTree.setSelectionModel(defaultTreeSelectionModel);
        this.logTree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.scrollTree = new JScrollPane(this.logTree);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 0));
        this.expandAction = this.createExpandAction();
        this.editLoggerAction = this.createEditLoggerAction();
        this.closeAction = this.createCloseAction();
        this.collapseAction = this.createCollapseAction();
        this.focusOnAction = this.createFocusOnAction();
        this.hideAction = this.createIgnoreAction();
        this.clearIgnoreListAction = this.createClearIgnoreListAction();
        this.popupMenu = new LoggerTreePopupMenu();
        this.popupListener = new PopupListener(this.popupMenu);
        this.setupListeners();
        this.configureToolbarPanel();
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.scrollTree, "Center");
        this.ignoreDialog.setTitle("Hidden/Ignored Loggers");
        this.ignoreDialog.setModal(true);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.ignoreSummary);
        AbstractAction abstractAction = new AbstractAction("..."){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggerNameTreePanel.this.ignoreDialog.show();
            }
        };
        abstractAction.putValue("ShortDescription", "Click to view and manage your hidden/ignored loggers");
        SmallButton smallButton = new SmallButton(abstractAction);
        jPanel.add(smallButton);
        this.add((Component)jPanel, "South");
        this.ignoreList.setModel(new DefaultListModel());
        this.ignoreList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() > 1 && (mouseEvent.getModifiers() & 0x10) > 0 && (n = LoggerNameTreePanel.this.ignoreList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    String string = LoggerNameTreePanel.this.ignoreList.getModel().getElementAt(n).toString();
                    LoggerNameTreePanel.this.toggleHiddenLogger(string);
                    LoggerNameTreePanel.this.fireChangeEvent();
                    LoggerNameTreePanel.this.logTreeModel.nodeStructureChanged((TreeNode)LoggerNameTreePanel.this.logTreeModel.getRoot());
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.ignoreListScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Double click an entry to unhide it"));
        jPanel2.add((Component)this.ignoreListScroll, "Center");
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton(new AbstractAction("Unhide All"){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(this, actionEvent){
                    private final /* synthetic */ ActionEvent val$e;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$e = actionEvent;
                    }

                    public void run() {
                        LoggerNameTreePanel.access$1000(7.access$900(this.this$1)).actionPerformed(this.val$e);
                    }
                });
            }

            static /* synthetic */ LoggerNameTreePanel access$900(7 var0) {
                return var0.LoggerNameTreePanel.this;
            }
        });
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        JButton jButton2 = new JButton(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggerNameTreePanel.this.ignoreDialog.hide();
            }
        });
        box.add(jButton2);
        jPanel2.add((Component)box, "South");
        this.ignoreDialog.getContentPane().add(jPanel2);
        this.ignoreDialog.pack();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LoggerNameTreePanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        return this.ruleDelegate.evaluate(loggingEvent);
    }

    public Rule getLoggerColorRule() {
        return this.colorRuleDelegate;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LoggerNameTreePanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void setFocusOn(String string) {
        LogPanelLoggerTreeModel.LogPanelTreeNode logPanelTreeNode = this.logTreeModel.lookupLogger(string);
        if (logPanelTreeNode != null) {
            Object[] objectArray = logPanelTreeNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            this.logTree.setSelectionPath(treePath);
            if (!this.focusOnLoggerButton.isSelected()) {
                this.focusOnLoggerButton.doClick();
            }
        } else {
            LogLog.error("failed to lookup logger " + string);
        }
    }

    protected void toggleHiddenLogger(String string) {
        if (!this.hiddenSet.contains(string)) {
            this.hiddenSet.add(string);
        } else {
            this.hiddenSet.remove(string);
        }
        this.firePropertyChange("hiddenSet", null, null);
    }

    String getCurrentlySelectedLoggerName() {
        TreePath[] treePathArray = this.logTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        TreePath treePath = treePathArray[0];
        return this.getLoggerName(treePath);
    }

    Set getHiddenSet() {
        return Collections.unmodifiableSet(this.hiddenSet);
    }

    String getLoggerName(TreePath treePath) {
        if (treePath != null) {
            Object[] objectArray = treePath.getPath();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(".");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    void ignore(Collection collection) {
        this.hiddenSet.addAll(collection);
        this.firePropertyChange("hiddenSet", null, null);
        this.fireChangeEvent();
    }

    boolean isFocusOnSelected() {
        return this.focusOnAction.getValue("checked") != null;
    }

    void setFocusOnSelected(boolean bl) {
        if (bl) {
            this.focusOnAction.putValue("checked", Boolean.TRUE);
        } else {
            this.focusOnAction.putValue("checked", null);
        }
    }

    private void collapseCurrentlySelectedNode() {
        TreePath[] treePathArray = this.logTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        LogLog.debug("Collapsing all children of selected node");
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode2.getParent() == null || defaultMutableTreeNode2 == defaultMutableTreeNode) continue;
                Object[] objectArray = ((DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()).getPath();
                TreePath treePath2 = new TreePath(objectArray);
                this.logTree.collapsePath(treePath2);
            }
        }
        this.ensureRootExpanded();
    }

    private void configureToolbarPanel() {
        this.toolbar.setFloatable(false);
        this.expandButton.setAction(this.expandAction);
        this.expandButton.setText(null);
        this.collapseButton.setAction(this.collapseAction);
        this.collapseButton.setText(null);
        this.focusOnLoggerButton.setAction(this.focusOnAction);
        this.focusOnLoggerButton.setText(null);
        this.ignoreLoggerButton.setAction(this.hideAction);
        this.ignoreLoggerButton.setText(null);
        this.expandButton.setFont(this.expandButton.getFont().deriveFont(1));
        this.collapseButton.setFont(this.collapseButton.getFont().deriveFont(1));
        this.editLoggerButton.setAction(this.editLoggerAction);
        this.editLoggerButton.setText(null);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.toolbar.add(this.expandButton);
        this.toolbar.add(this.collapseButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.focusOnLoggerButton);
        this.toolbar.add(this.ignoreLoggerButton);
        this.toolbar.addSeparator();
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(this.closeButton);
        this.toolbar.add(Box.createHorizontalStrut(5));
    }

    private Action createClearIgnoreListAction() {
        AbstractAction abstractAction = new AbstractAction("Clear Ignore list", null){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(false);
                LoggerNameTreePanel.this.logTreeModel.reload();
                LoggerNameTreePanel.this.hiddenSet.clear();
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        abstractAction.putValue("ShortDescription", "Removes all entries from the Ignore list so you can see their events in the view");
        return abstractAction;
    }

    private Action createCloseAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggerNameTreePanel.this.preferenceModel.setLogTreePanelVisible(false);
            }
        };
        abstractAction.putValue("Name", "Close");
        abstractAction.putValue("ShortDescription", "Closes the Logger panel");
        abstractAction.putValue("SmallIcon", LineIconFactory.createCloseIcon());
        return abstractAction;
    }

    private Action createCollapseAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggerNameTreePanel.this.collapseCurrentlySelectedNode();
            }
        };
        abstractAction.putValue("SmallIcon", LineIconFactory.createCollapseIcon());
        abstractAction.putValue("Name", "Collapse Branch");
        abstractAction.putValue("ShortDescription", "Collapses all the children of the currently selected node");
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private Action createEditLoggerAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        abstractAction.putValue("enabled", Boolean.FALSE);
        abstractAction.putValue("Name", "Edit filters/colors");
        abstractAction.putValue("ShortDescription", "Allows you to specify filters and coloring for this Logger");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_EDIT_RECEIVER));
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private Action createExpandAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggerNameTreePanel.this.expandCurrentlySelectedNode();
            }
        };
        abstractAction.putValue("SmallIcon", LineIconFactory.createExpandIcon());
        abstractAction.putValue("Name", "Expand branch");
        abstractAction.putValue("ShortDescription", "Expands all the child nodes of the currently selected node, recursively");
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private Action createFocusOnAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggerNameTreePanel.this.toggleFocusOnState();
            }
        };
        abstractAction.putValue("Name", "Focus");
        abstractAction.putValue("ShortDescription", "Allows you to Focus on the selected logger by setting a filter that discards all but this Logger");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private Action createIgnoreAction() {
        AbstractAction abstractAction = new AbstractAction("Ignore this Logger", new ImageIcon(ChainsawIcons.ICON_COLLAPSE)){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                if (string != null) {
                    LoggerNameTreePanel.this.toggleHiddenLogger(string);
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                    LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(LoggerNameTreePanel.this.hiddenSet.contains(string));
                    LoggerNameTreePanel.this.focusOnAction.setEnabled(!LoggerNameTreePanel.this.hiddenSet.contains(string));
                    ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(LoggerNameTreePanel.this.hiddenSet.contains(string));
                }
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        abstractAction.putValue("ShortDescription", "Adds the selected Logger to your Ignore list, filtering those events from view");
        return abstractAction;
    }

    private void ensureRootExpanded() {
        LogLog.debug("Ensuring Root node is expanded.");
        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.logTreeModel.getRoot();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoggerNameTreePanel.this.logTree.expandPath(new TreePath(defaultMutableTreeNode));
            }
        });
    }

    private void expandCurrentlySelectedNode() {
        TreePath treePath;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Enumeration<TreeNode> enumeration;
        TreePath[] treePathArray = this.logTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        LogLog.debug("Expanding all children of selected node");
        for (int i = 0; i < treePathArray.length && (enumeration = (defaultMutableTreeNode = (DefaultMutableTreeNode)(treePath = treePathArray[i]).getLastPathComponent()).depthFirstEnumeration()).hasMoreElements(); ++i) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (enumeration.hasMoreElements()) {
                arrayList.add(new Integer(((DefaultMutableTreeNode)enumeration.nextElement()).getDepth()));
            }
            Collections.sort(arrayList);
            Collections.reverse(arrayList);
            int n = (Integer)arrayList.get(0);
            if (n > 4) {
                LogLog.warn("Should warn user, depth=" + n);
            }
            enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!defaultMutableTreeNode2.isLeaf()) continue;
                Object[] objectArray = ((DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()).getPath();
                TreePath treePath2 = new TreePath(objectArray);
                LogLog.debug("Expanding path:" + treePath2);
                this.logTree.expandPath(treePath2);
            }
        }
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LoggerNameTreePanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        ChangeEvent changeEvent = null;
        for (int i = 0; i < changeListenerArray.length; ++i) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    private void reconfigureMenuText() {
        String string = this.getCurrentlySelectedLoggerName();
        if (string == null || string.length() == 0) {
            this.focusOnAction.putValue("Name", "Focus On...");
            this.hideAction.putValue("Name", "Ignore ...");
        } else {
            this.focusOnAction.putValue("Name", "Focus On '" + string + "'");
            this.hideAction.putValue("Name", "Ignore '" + string + "'");
        }
        this.focusOnLoggerButton.setText(null);
        this.ignoreLoggerButton.setText(null);
    }

    private void setupListeners() {
        this.logTree.addMouseMotionListener(new MouseKeyIconListener());
        this.logTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                TreeNode treeNode = null;
                if (treePath != null) {
                    treeNode = (TreeNode)treePath.getLastPathComponent();
                }
                String string = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                LoggerNameTreePanel.this.focusOnAction.setEnabled(treePath != null && treeNode != null && treeNode.getParent() != null && !LoggerNameTreePanel.this.hiddenSet.contains(string));
                LoggerNameTreePanel.this.hideAction.setEnabled(treePath != null && treeNode != null && treeNode.getParent() != null && !LoggerNameTreePanel.this.isFocusOnSelected());
                if (!LoggerNameTreePanel.this.focusOnAction.isEnabled()) {
                    LoggerNameTreePanel.this.setFocusOnSelected(false);
                }
                LoggerNameTreePanel.this.expandAction.setEnabled(treePath != null);
                if (string != null) {
                    boolean bl = LoggerNameTreePanel.this.hiddenSet.contains(string);
                    ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(bl);
                    LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(bl);
                }
                LoggerNameTreePanel.this.collapseAction.setEnabled(treePath != null);
                LoggerNameTreePanel.this.reconfigureMenuText();
            }
        });
        this.logTree.addMouseListener(this.popupListener);
        this.focusOnAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.focusOnCheck.setSelected(LoggerNameTreePanel.this.isFocusOnSelected());
                LoggerNameTreePanel.this.focusOnLoggerButton.setSelected(LoggerNameTreePanel.this.isFocusOnSelected());
                if (LoggerNameTreePanel.this.logTree.getSelectionPath() != null) {
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                }
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        });
        this.hideAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (LoggerNameTreePanel.this.logTree.getSelectionPath() != null) {
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                }
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        });
        this.logTree.addMouseListener(new MouseFocusOnListener());
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LoggerNameTreePanel.this.firePropertyChange("rule", null, null);
                LoggerNameTreePanel.this.updateAllIgnoreStuff();
            }
        });
        this.addPropertyChangeListener("hiddenSet", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LoggerNameTreePanel.this.updateAllIgnoreStuff();
            }
        });
    }

    private void updateAllIgnoreStuff() {
        this.updateHiddenSetModels();
        this.updateIgnoreSummary();
    }

    private void updateHiddenSetModels() {
        DefaultListModel defaultListModel = (DefaultListModel)this.ignoreList.getModel();
        defaultListModel.clear();
        ArrayList arrayList = new ArrayList(this.getHiddenSet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            defaultListModel.addElement(string);
        }
    }

    private void updateIgnoreSummary() {
        this.ignoreSummary.setText(this.ignoreList.getModel().getSize() + " hidden loggers");
    }

    private void toggleFocusOnState() {
        this.setFocusOnSelected(!this.isFocusOnSelected());
        this.hideAction.setEnabled(!this.isFocusOnSelected());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class MouseKeyIconListener
    extends MouseMotionAdapter
    implements MouseMotionListener {
        Cursor focusOnCursor = Toolkit.getDefaultToolkit().createCustomCursor(ChainsawIcons.FOCUS_ON_ICON.getImage(), new Point(10, 10), "");
        Cursor ignoreCursor = Toolkit.getDefaultToolkit().createCustomCursor(ChainsawIcons.IGNORE_ICON.getImage(), new Point(10, 10), "");

        private MouseKeyIconListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 2) > 0 && (mouseEvent.getModifiers() & 1) > 0) {
                LoggerNameTreePanel.this.logTree.setCursor(this.ignoreCursor);
            } else if ((mouseEvent.getModifiers() & 2) > 0) {
                LoggerNameTreePanel.this.logTree.setCursor(this.focusOnCursor);
            } else {
                LoggerNameTreePanel.this.logTree.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private final class MouseFocusOnListener
    extends MouseAdapter {
        private MouseFocusOnListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1 && (mouseEvent.getModifiers() & 2) > 0 && (mouseEvent.getModifiers() & 1) > 0) {
                this.ignoreLoggerAtPoint(mouseEvent.getPoint());
                mouseEvent.consume();
                LoggerNameTreePanel.this.fireChangeEvent();
            } else if (mouseEvent.getClickCount() > 1 && (mouseEvent.getModifiers() & 2) > 0) {
                this.focusAnLoggerAtPoint(mouseEvent.getPoint());
                mouseEvent.consume();
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        }

        private void focusAnLoggerAtPoint(Point point) {
            String string = this.getLoggerAtPoint(point);
            if (string != null) {
                LoggerNameTreePanel.this.toggleFocusOnState();
            }
        }

        private String getLoggerAtPoint(Point point) {
            TreePath treePath = LoggerNameTreePanel.this.logTree.getPathForLocation(point.x, point.y);
            if (treePath != null) {
                return LoggerNameTreePanel.this.getLoggerName(treePath);
            }
            return null;
        }

        private void ignoreLoggerAtPoint(Point point) {
            String string = this.getLoggerAtPoint(point);
            if (string != null) {
                LoggerNameTreePanel.this.toggleHiddenLogger(string);
            }
        }
    }

    private class LoggerTreePopupMenu
    extends JPopupMenu {
        JCheckBoxMenuItem focusOnCheck = new JCheckBoxMenuItem();
        JCheckBoxMenuItem hideCheck = new JCheckBoxMenuItem();

        private LoggerTreePopupMenu() {
            this.initMenu();
        }

        public void show(Component component, int n, int n2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)LoggerNameTreePanel.this.logTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            super.show(component, n, n2);
        }

        private void initMenu() {
            this.add(LoggerNameTreePanel.this.expandAction);
            this.add(LoggerNameTreePanel.this.collapseAction);
            this.addSeparator();
            this.focusOnCheck.setAction(LoggerNameTreePanel.this.focusOnAction);
            this.hideCheck.setAction(LoggerNameTreePanel.this.hideAction);
            this.add(this.focusOnCheck);
            this.add(this.hideCheck);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.clearIgnoreListAction);
        }
    }

    private class LoggerNameTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private LoggerNameTreeCellRenderer() {
            this.setLeafIcon(null);
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Font font;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Font font2 = jLabel.getFont();
            int n2 = 0;
            if (bl && LoggerNameTreePanel.this.focusOnLoggerButton.isSelected()) {
                n2 |= 1;
            }
            String string = LoggerNameTreePanel.this.getLoggerName(new TreePath(((DefaultMutableTreeNode)object).getPath()));
            if (LoggerNameTreePanel.this.hiddenSet.contains(string)) {
                n2 |= 2;
            }
            if (font2 != null && (font = font2.deriveFont(n2)) != null) {
                jLabel.setFont(font);
            }
            return jLabel;
        }
    }
}

