/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CyclicBufferList
extends AbstractList
implements List {
    Object[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    public CyclicBufferList(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n + ") is not a positive integer.");
        }
        this.maxSize = n;
        this.clear();
    }

    public CyclicBufferList() {
        this(5000);
    }

    public Object remove(int n) {
        Object object = this.ea[n];
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(this.ea));
        arrayList.remove(n);
        this.ea = arrayList.toArray(this.ea);
        this.numElems = this.ea.length;
        --this.numElems;
        if (--this.last <= 0) {
            this.last = this.numElems;
        }
        if (this.first == this.maxSize) {
            this.first = 0;
        }
        return object;
    }

    public Object set(int n, Object object) {
        Object object2 = this.ea[n];
        this.ea[n] = object;
        return object2;
    }

    public boolean add(Object object) {
        this.ea[this.last] = object;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
        } else if (++this.first == this.maxSize) {
            this.first = 0;
        }
        return true;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + n) % this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getLast() {
        return this.last;
    }

    public Object get() {
        Object object = null;
        if (this.numElems > 0) {
            --this.numElems;
            object = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first == this.maxSize) {
                this.first = 0;
            }
        }
        return object;
    }

    public int size() {
        return this.numElems;
    }

    public void resize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative array size [" + n + "] not allowed.");
        }
        if (n == this.numElems) {
            return;
        }
        Object[] objectArray = new Object[n];
        int n2 = n < this.numElems ? n : this.numElems;
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first != this.numElems) continue;
            this.first = 0;
        }
        this.ea = objectArray;
        this.first = 0;
        this.numElems = n2;
        this.maxSize = n;
        this.last = n2 == n ? 0 : n2;
    }

    public void clear() {
        this.ea = new Object[this.maxSize];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }
}

