/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.messages.MessageCenter;

public class ChainsawStatusBar
extends JPanel {
    private static final int DELAY_PERIOD = 5000;
    private static final String DEFAULT_MSG = "Welcome to Chainsaw v2!";
    private final JLabel statusMsg = new JLabel("Welcome to Chainsaw v2!");
    private final JLabel pausedLabel = new JLabel("", 0);
    private final JLabel lineSelectionLabel = new JLabel("", 0);
    private final JLabel eventCountLabel = new JLabel("", 0);
    private final JLabel receivedEventLabel = new JLabel("0.0", 0);
    private final JLabel receivedConnectionlabel = new JLabel("", 0);
    private volatile long lastReceivedConnection = System.currentTimeMillis();
    private final Thread connectionThread;
    private final Icon pausedIcon = new ImageIcon(ChainsawIcons.PAUSE);
    private final Icon netConnectIcon = new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT);
    private final NumberFormat nf = NumberFormat.getNumberInstance();
    private final Border statusBarComponentBorder = BorderFactory.createLineBorder(this.statusMsg.getBackground().darker());

    public ChainsawStatusBar() {
        this.setLayout(new GridBagLayout());
        this.nf.setMaximumFractionDigits(1);
        this.nf.setMinimumFractionDigits(1);
        this.nf.setGroupingUsed(false);
        JPanel jPanel = new JPanel(new FlowLayout(0, 2, 2));
        jPanel.add(this.statusMsg);
        jPanel.setBorder(this.statusBarComponentBorder);
        this.pausedLabel.setBorder(this.statusBarComponentBorder);
        this.pausedLabel.setMinimumSize(new Dimension(this.pausedIcon.getIconWidth(), this.pausedIcon.getIconHeight()));
        this.pausedLabel.setToolTipText("Shows whether the current Log panel is paused or not");
        this.receivedEventLabel.setBorder(this.statusBarComponentBorder);
        this.receivedEventLabel.setToolTipText("Indicates whether Chainsaw is receiving events, and how fast it is processing them");
        this.receivedEventLabel.setMinimumSize(new Dimension(this.receivedEventLabel.getFontMetrics(this.receivedEventLabel.getFont()).stringWidth("9999.9/s") + 5, (int)this.receivedEventLabel.getPreferredSize().getHeight()));
        this.eventCountLabel.setBorder(this.statusBarComponentBorder);
        this.eventCountLabel.setToolTipText("<# viewable events>:<# total events>");
        this.eventCountLabel.setMinimumSize(new Dimension(this.eventCountLabel.getFontMetrics(this.eventCountLabel.getFont()).stringWidth("99999:99999") + 5, (int)this.eventCountLabel.getPreferredSize().getHeight()));
        this.receivedConnectionlabel.setBorder(this.statusBarComponentBorder);
        this.receivedConnectionlabel.setToolTipText("Indicates whether Chainsaw has received a remote connection");
        this.receivedConnectionlabel.setMinimumSize(new Dimension(this.netConnectIcon.getIconWidth() + 4, (int)this.receivedConnectionlabel.getPreferredSize().getHeight()));
        this.lineSelectionLabel.setBorder(this.statusBarComponentBorder);
        this.lineSelectionLabel.setMinimumSize(new Dimension(this.lineSelectionLabel.getFontMetrics(this.lineSelectionLabel.getFont()).stringWidth("999999"), (int)this.lineSelectionLabel.getPreferredSize().getHeight()));
        this.lineSelectionLabel.setToolTipText("The current line # selected");
        JComponent[] jComponentArray = new JComponent[]{this.eventCountLabel, this.receivedConnectionlabel, this.lineSelectionLabel, this.receivedEventLabel, this.pausedLabel};
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setPreferredSize(jComponentArray[i].getMinimumSize());
            jComponentArray[i].setMaximumSize(jComponentArray[i].getMinimumSize());
        }
        this.statusMsg.setMinimumSize(this.pausedLabel.getPreferredSize());
        this.statusMsg.setToolTipText("Shows messages from Chainsaw");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.receivedConnectionlabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 2;
        this.add((Component)this.lineSelectionLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 3;
        this.add((Component)this.eventCountLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 4;
        this.add((Component)this.receivedEventLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 5;
        this.add((Component)this.pausedLabel, gridBagConstraints);
        this.connectionThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Icon icon = null;
                    if (System.currentTimeMillis() - ChainsawStatusBar.this.lastReceivedConnection < 5000L) {
                        icon = ChainsawStatusBar.this.netConnectIcon;
                    }
                    Icon icon2 = icon;
                    SwingUtilities.invokeLater(new Runnable(this, icon2){
                        private final /* synthetic */ Icon val$theIcon;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$theIcon = icon;
                        }

                        public void run() {
                            ChainsawStatusBar.access$300(1.access$200(this.this$1)).setIcon(this.val$theIcon);
                        }
                    });
                }
            }

            static /* synthetic */ ChainsawStatusBar access$200(1 var0) {
                return var0.ChainsawStatusBar.this;
            }
        });
        this.connectionThread.start();
    }

    void setDataRate(final double d) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChainsawStatusBar.this.receivedEventLabel.setText(ChainsawStatusBar.this.nf.format(d) + "/s");
            }
        });
    }

    void remoteConnectionReceived(String string) {
        this.lastReceivedConnection = System.currentTimeMillis();
        MessageCenter.getInstance().getLogger().info("Connection received from " + string);
        this.connectionThread.interrupt();
    }

    void setPaused(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ChainsawStatusBar.this.pausedLabel.setIcon(bl ? ChainsawStatusBar.this.pausedIcon : null);
                ChainsawStatusBar.this.pausedLabel.setToolTipText(bl ? "This Log panel is currently paused" : "This Log panel is not paused");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void setSelectedLine(final int n, final int n2, final int n3) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChainsawStatusBar.this.lineSelectionLabel.setText(n + "");
                ChainsawStatusBar.this.eventCountLabel.setText(n2 + ":" + n3);
            }
        });
    }

    void setNothingSelected() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChainsawStatusBar.this.lineSelectionLabel.setText("");
            }
        });
    }

    void clear() {
        this.setMessage(DEFAULT_MSG);
        this.setNothingSelected();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChainsawStatusBar.this.receivedEventLabel.setText("");
            }
        });
    }

    public void setMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChainsawStatusBar.this.statusMsg.setText(" " + string);
            }
        });
    }

    static /* synthetic */ JLabel access$300(ChainsawStatusBar chainsawStatusBar) {
        return chainsawStatusBar.receivedConnectionlabel;
    }
}

