/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.chainsaw.ChainsawAppender;
import org.apache.log4j.chainsaw.ChainsawEventBatch;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class ChainsawAppenderHandler
extends AppenderSkeleton {
    private static final String DEFAULT_IDENTIFIER = "Unknown";
    private WorkQueue worker;
    private final Object mutex = new Object();
    private int sleepInterval = 1000;
    private EventListenerList listenerList = new EventListenerList();
    private double dataRate = 0.0;
    private String identifierExpression;
    private final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Map customExpressionRules = new HashMap();
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$EventBatchListener;

    public ChainsawAppenderHandler(ChainsawAppender chainsawAppender) {
        chainsawAppender.setAppender(this);
        this.activateOptions();
    }

    public ChainsawAppenderHandler() {
        this.activateOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentifierExpression(String string) {
        Object object = this.mutex;
        synchronized (object) {
            this.identifierExpression = string;
            this.mutex.notify();
        }
    }

    public String getIdentifierExpression() {
        return this.identifierExpression;
    }

    public void addCustomEventBatchListener(String string, EventBatchListener eventBatchListener) throws IllegalArgumentException {
        this.customExpressionRules.put(string, ExpressionRule.getRule(string));
        this.listenerList.add(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener, eventBatchListener);
    }

    public void addEventBatchListener(EventBatchListener eventBatchListener) {
        this.listenerList.add(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener, eventBatchListener);
    }

    public void removeEventBatchListener(EventBatchListener eventBatchListener) {
        this.listenerList.remove(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener, eventBatchListener);
    }

    public void append(LoggingEvent loggingEvent) {
        this.worker.enqueue(loggingEvent);
    }

    public void close() {
    }

    public void activateOptions() {
        this.worker = new WorkQueue();
    }

    public boolean requiresLayout() {
        return false;
    }

    public int getQueueInterval() {
        return this.sleepInterval;
    }

    public void setQueueInterval(int n) {
        this.sleepInterval = n;
    }

    String getTabIdentifier(LoggingEvent loggingEvent) {
        String string = this.resolver.applyFields(this.identifierExpression, loggingEvent);
        return string != null ? string : DEFAULT_IDENTIFIER;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        ChainsawAppenderHandler chainsawAppenderHandler = new ChainsawAppenderHandler();
        chainsawAppenderHandler.addEventBatchListener(new EventBatchListener(){

            public String getInterestedIdentifier() {
                return null;
            }

            public void receiveEventBatch(String string, List list) {
                LogLog.debug("received batch for '" + string + "', list.size()=" + list.size());
                LogLog.debug(list.toString());
            }
        });
        LogManager.getRootLogger().addAppender(chainsawAppenderHandler);
        SocketReceiver socketReceiver = new SocketReceiver(4445);
        LogManager.getLoggerRepository().getPluginRegistry().addPlugin(socketReceiver);
        socketReceiver.activateOptions();
        Thread.sleep(60000L);
    }

    public double getDataRate() {
        return this.dataRate;
    }

    void setDataRate(double d) {
        double d2 = this.dataRate;
        this.dataRate = d;
        this.propertySupport.firePropertyChange("dataRate", new Double(d2), new Double(this.dataRate));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WorkQueue {
        final ArrayList queue = new ArrayList();
        Thread workerThread = new WorkerThread();

        protected WorkQueue() {
            this.workerThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void enqueue(LoggingEvent loggingEvent) {
            Object object = ChainsawAppenderHandler.this.mutex;
            synchronized (object) {
                this.queue.add(loggingEvent);
                ChainsawAppenderHandler.this.mutex.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            Object object = ChainsawAppenderHandler.this.mutex;
            synchronized (object) {
                this.workerThread.interrupt();
            }
        }

        private class WorkerThread
        extends Thread {
            public WorkerThread() {
                this.setDaemon(true);
                this.setPriority(4);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList = new ArrayList();
                while (true) {
                    Object object;
                    long l = System.currentTimeMillis();
                    Object object2 = ChainsawAppenderHandler.this.mutex;
                    synchronized (object2) {
                        try {
                            while (WorkQueue.this.queue.size() == 0 || ChainsawAppenderHandler.this.identifierExpression == null) {
                                ChainsawAppenderHandler.this.setDataRate(0.0);
                                ChainsawAppenderHandler.this.mutex.wait();
                            }
                            if (WorkQueue.this.queue.size() > 0) {
                                arrayList.addAll(WorkQueue.this.queue);
                                WorkQueue.this.queue.clear();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    int n = arrayList.size();
                    if (n > 0) {
                        object = arrayList.iterator();
                        ChainsawEventBatch chainsawEventBatch = new ChainsawEventBatch();
                        while (object.hasNext()) {
                            Object object3;
                            LoggingEvent loggingEvent = (LoggingEvent)object.next();
                            if (loggingEvent.getProperty("hostname") == null && (object3 = loggingEvent.getProperty("log4j.remoteSourceInfo")) != null) {
                                int n2 = ((String)object3).indexOf(":");
                                if (n2 == -1) {
                                    n2 = ((String)object3).length();
                                }
                                loggingEvent.setProperty("hostname", ((String)object3).substring(0, n2));
                            }
                            object3 = ChainsawAppenderHandler.this.customExpressionRules.entrySet().iterator();
                            while (object3.hasNext()) {
                                Map.Entry entry = (Map.Entry)object3.next();
                                Rule rule = (Rule)entry.getValue();
                                if (!rule.evaluate(loggingEvent)) continue;
                                chainsawEventBatch.addEvent((String)entry.getKey(), loggingEvent.getProperty("log4j.eventtype") == null ? "log4j" : loggingEvent.getProperty("log4j.eventtype"), loggingEvent);
                            }
                            chainsawEventBatch.addEvent(ChainsawAppenderHandler.this.getTabIdentifier(loggingEvent), loggingEvent.getProperty("log4j.eventtype") == null ? "log4j" : loggingEvent.getProperty("log4j.eventtype"), loggingEvent);
                        }
                        this.dispatchEventBatch(chainsawEventBatch);
                        arrayList.clear();
                    }
                    if (ChainsawAppenderHandler.this.getQueueInterval() > 1000) {
                        try {
                            object = this;
                            synchronized (object) {
                                this.wait(ChainsawAppenderHandler.this.getQueueInterval());
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        Thread.yield();
                    }
                    if (n == 0) {
                        ChainsawAppenderHandler.this.setDataRate(0.0);
                        continue;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = (l2 - l) / 1000L;
                    double d = (double)n / (double)l3;
                    ChainsawAppenderHandler.this.setDataRate(d);
                }
            }

            private void dispatchEventBatch(ChainsawEventBatch chainsawEventBatch) {
                EventBatchListener[] eventBatchListenerArray = (EventBatchListener[])ChainsawAppenderHandler.this.listenerList.getListeners(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener);
                Iterator iterator = chainsawEventBatch.identifierIterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    List list = null;
                    for (int i = 0; i < eventBatchListenerArray.length; ++i) {
                        EventBatchListener eventBatchListener = eventBatchListenerArray[i];
                        if (eventBatchListener.getInterestedIdentifier() != null && !eventBatchListener.getInterestedIdentifier().equals(string)) continue;
                        if (list == null) {
                            list = chainsawEventBatch.entrySet(string);
                        }
                        eventBatchListener.receiveEventBatch(string, list);
                    }
                    list = null;
                }
            }
        }
    }
}

