/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.chainsaw.AbstractPreferencePanel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.BasicPrefPanel;
import org.apache.log4j.helpers.LogLog;

public class ApplicationPreferenceModelPanel
extends AbstractPreferencePanel {
    private ApplicationPreferenceModel committedPreferenceModel;
    private ApplicationPreferenceModel uncommittedPreferenceModel = new ApplicationPreferenceModel();
    private JTextField identifierExpression;
    private JTextField toolTipDisplayMillis;
    private JTextField cyclicBufferSize;
    private final JTextField configurationURL = new JTextField(35);

    ApplicationPreferenceModelPanel(ApplicationPreferenceModel applicationPreferenceModel) {
        this.committedPreferenceModel = applicationPreferenceModel;
        this.initComponents();
        this.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setConfigurationURL(ApplicationPreferenceModelPanel.this.configurationURL.getText());
                ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setIdentifierExpression(ApplicationPreferenceModelPanel.this.identifierExpression.getText());
                try {
                    n = Integer.parseInt(ApplicationPreferenceModelPanel.this.toolTipDisplayMillis.getText());
                    if (n >= 0) {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setToolTipDisplayMillis(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n = Integer.parseInt(ApplicationPreferenceModelPanel.this.cyclicBufferSize.getText());
                    if (n >= 0) {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setCyclicBufferSize(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ApplicationPreferenceModelPanel.this.committedPreferenceModel.apply(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel);
                ApplicationPreferenceModelPanel.this.hidePanel();
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.apply(ApplicationPreferenceModelPanel.this.committedPreferenceModel);
                ApplicationPreferenceModelPanel.this.hidePanel();
            }
        });
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("App Preferences Panel Test Bed");
        ApplicationPreferenceModel applicationPreferenceModel = new ApplicationPreferenceModel();
        ApplicationPreferenceModelPanel applicationPreferenceModelPanel = new ApplicationPreferenceModelPanel(applicationPreferenceModel);
        jFrame.getContentPane().add(applicationPreferenceModelPanel);
        applicationPreferenceModel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogLog.warn(propertyChangeEvent.toString());
            }
        });
        applicationPreferenceModelPanel.setOkCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(1);
            }
        });
        jFrame.setSize(640, 480);
        jFrame.show();
    }

    public void updateModel() {
        this.uncommittedPreferenceModel.apply(this.committedPreferenceModel);
    }

    protected TreeModel createTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Preferences");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GeneralAllPrefPanel());
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new VisualsPrefPanel());
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultTreeModel;
    }

    public class GeneralAllPrefPanel
    extends BasicPrefPanel {
        private final JCheckBox showNoReceiverWarning = new JCheckBox("Prompt me on startup if there are no Receivers defined");
        private final JCheckBox showSplash = new JCheckBox("Show Splash screen at startup");
        private final JSlider responsiveSlider = new JSlider(0, 1, 4, 2);
        private final JCheckBox confirmExit = new JCheckBox("Confirm Exit");
        Dictionary sliderLabelMap = new Hashtable();
        private final JCheckBox okToRemoveSecurityManager = new JCheckBox("Ok to remove SecurityManager");

        public GeneralAllPrefPanel() {
            super("General");
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 1));
            ApplicationPreferenceModelPanel.this.identifierExpression = new JTextField(20);
            ApplicationPreferenceModelPanel.this.toolTipDisplayMillis = new JTextField(8);
            ApplicationPreferenceModelPanel.this.cyclicBufferSize = new JTextField(8);
            Box box = new Box(0);
            box.add(this.showNoReceiverWarning);
            box.add(Box.createHorizontalGlue());
            this.confirmExit.setToolTipText("Is set, you will be prompted to confirm the exit Chainsaw");
            this.okToRemoveSecurityManager.setToolTipText("You will need to tick this to be able to load Receivers/Plugins that require external dependancies.");
            this.setupInitialValues();
            this.setupListeners();
            this.initSliderComponent();
            this.add(this.responsiveSlider);
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new JLabel("Tab identifier"));
            jPanel.add(Box.createHorizontalStrut(5));
            jPanel.add(ApplicationPreferenceModelPanel.this.identifierExpression);
            this.add(jPanel);
            this.add(box);
            Box box2 = new Box(0);
            box2.add(this.confirmExit);
            box2.add(Box.createHorizontalGlue());
            Box box3 = new Box(0);
            box3.add(this.showSplash);
            box3.add(Box.createHorizontalGlue());
            Box box4 = new Box(0);
            box4.add(this.okToRemoveSecurityManager);
            box4.add(Box.createHorizontalGlue());
            this.add(box2);
            this.add(box3);
            this.add(box4);
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(new JLabel("ToolTip Display (millis)"));
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(ApplicationPreferenceModelPanel.this.toolTipDisplayMillis);
            this.add(jPanel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.add(new JLabel("Cyclic buffer size"));
            jPanel3.add(Box.createHorizontalStrut(5));
            jPanel3.add(ApplicationPreferenceModelPanel.this.cyclicBufferSize);
            this.add(jPanel3);
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.add(new JLabel("Automatic Configuration URL"));
            jPanel4.add(Box.createHorizontalStrut(5));
            jPanel4.add(ApplicationPreferenceModelPanel.this.configurationURL);
            this.add(jPanel4);
            JPanel jPanel5 = new JPanel(new FlowLayout(0));
            jPanel5.add(new JLabel("Cyclic buffer size change will apply the next time you start Chainsaw"));
            this.add(jPanel5);
            this.add(Box.createVerticalGlue());
            ApplicationPreferenceModelPanel.this.configurationURL.setToolTipText("A complete and valid URL identifying the location of a valid log4 xml configuration file to auto-configure Receivers and other Plugins");
            ApplicationPreferenceModelPanel.this.configurationURL.setInputVerifier(new InputVerifier(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public boolean verify(JComponent jComponent) {
                    try {
                        new URL(ApplicationPreferenceModelPanel.access$000(GeneralAllPrefPanel.access$1400(this.this$1)).getText());
                    }
                    catch (Exception exception) {
                        return false;
                    }
                    return true;
                }
            });
        }

        private void initSliderComponent() {
            this.responsiveSlider.setToolTipText("Adjust to set the responsiveness of the app.  How often the view is updated.");
            this.responsiveSlider.setSnapToTicks(true);
            this.responsiveSlider.setLabelTable(this.sliderLabelMap);
            this.responsiveSlider.setPaintLabels(true);
            this.responsiveSlider.setPaintTrack(true);
            this.responsiveSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Responsiveness"));
        }

        private void setupListeners() {
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("showNoReceiverWarning", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    GeneralAllPrefPanel.access$1500(this.this$1).setSelected((Boolean)propertyChangeEvent.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("showSplash", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    GeneralAllPrefPanel.access$1600(this.this$1).setSelected(bl);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("okToRemoveSecurityManager", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    if (bl) {
                        GeneralAllPrefPanel.access$1700(this.this$1).setSelected(bl);
                    } else {
                        GeneralAllPrefPanel.access$1700(this.this$1).setSelected(false);
                    }
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("identifierExpression", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ApplicationPreferenceModelPanel.access$200(GeneralAllPrefPanel.access$1400(this.this$1)).setText(propertyChangeEvent.getNewValue().toString());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("responsiveness", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    if (n >= 1000) {
                        int n2 = (n - 750) / 1000;
                        LogLog.debug("Adjusting old Responsiveness value from " + n + " to " + n2);
                        n = n2;
                    }
                    GeneralAllPrefPanel.access$1800(this.this$1).setValue(n);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("toolTipDisplayMillis", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ApplicationPreferenceModelPanel.access$300(GeneralAllPrefPanel.access$1400(this.this$1)).setText(propertyChangeEvent.getNewValue().toString());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("cyclicBufferSize", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ApplicationPreferenceModelPanel.access$400(GeneralAllPrefPanel.access$1400(this.this$1)).setText(propertyChangeEvent.getNewValue().toString());
                }
            });
            this.showNoReceiverWarning.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(GeneralAllPrefPanel.access$1400(this.this$1)).setShowNoReceiverWarning(GeneralAllPrefPanel.access$1500(this.this$1).isSelected());
                }
            });
            this.showSplash.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(GeneralAllPrefPanel.access$1400(this.this$1)).setShowSplash(GeneralAllPrefPanel.access$1600(this.this$1).isSelected());
                }
            });
            this.okToRemoveSecurityManager.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GeneralAllPrefPanel.access$1700(this.this$1).isSelected() && JOptionPane.showConfirmDialog(GeneralAllPrefPanel.access$1700(this.this$1), "By ticking this option, you are authorizing Chainsaw to remove Java's Security Manager.\n\nThis is required under Java Web Start so that it can access Jars/classes locally.  Without this, Receivers like JMSReceiver + DBReceiver that require specific driver jars will NOT be able to be run.  \n\nBy ticking this, you are saying that this is ok.", "Please Confirm", 0) == 0) {
                        ApplicationPreferenceModelPanel.access$100(GeneralAllPrefPanel.access$1400(this.this$1)).setOkToRemoveSecurityManager(true);
                    } else {
                        ApplicationPreferenceModelPanel.access$100(GeneralAllPrefPanel.access$1400(this.this$1)).setOkToRemoveSecurityManager(false);
                    }
                }
            });
            this.responsiveSlider.getModel().addChangeListener(new ChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (!GeneralAllPrefPanel.access$1800(this.this$1).getValueIsAdjusting()) {
                        int n = GeneralAllPrefPanel.access$1800(this.this$1).getValue();
                        if (n == 0) {
                            n = 1;
                        }
                        LogLog.debug("Adjust responsiveness to " + n);
                        ApplicationPreferenceModelPanel.access$100(GeneralAllPrefPanel.access$1400(this.this$1)).setResponsiveness(n);
                    }
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("confirmExit", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    GeneralAllPrefPanel.access$1900(this.this$1).setSelected(bl);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("configurationURL", new PropertyChangeListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getNewValue().toString();
                    ApplicationPreferenceModelPanel.access$000(GeneralAllPrefPanel.access$1400(this.this$1)).setText(string);
                }
            });
            this.confirmExit.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneralAllPrefPanel this$1;
                {
                    this.this$1 = generalAllPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(GeneralAllPrefPanel.access$1400(this.this$1)).setConfirmExit(GeneralAllPrefPanel.access$1900(this.this$1).isSelected());
                }
            });
        }

        private void setupInitialValues() {
            this.sliderLabelMap.put(new Integer(1), new JLabel("Fastest"));
            this.sliderLabelMap.put(new Integer(2), new JLabel("Fast"));
            this.sliderLabelMap.put(new Integer(3), new JLabel("Medium"));
            this.sliderLabelMap.put(new Integer(4), new JLabel("Slow"));
            this.showNoReceiverWarning.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isShowNoReceiverWarning());
            ApplicationPreferenceModelPanel.this.identifierExpression.setText(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getIdentifierExpression());
        }

        static /* synthetic */ ApplicationPreferenceModelPanel access$1400(GeneralAllPrefPanel generalAllPrefPanel) {
            return generalAllPrefPanel.ApplicationPreferenceModelPanel.this;
        }

        static /* synthetic */ JCheckBox access$1500(GeneralAllPrefPanel generalAllPrefPanel) {
            return generalAllPrefPanel.showNoReceiverWarning;
        }

        static /* synthetic */ JCheckBox access$1600(GeneralAllPrefPanel generalAllPrefPanel) {
            return generalAllPrefPanel.showSplash;
        }

        static /* synthetic */ JCheckBox access$1700(GeneralAllPrefPanel generalAllPrefPanel) {
            return generalAllPrefPanel.okToRemoveSecurityManager;
        }

        static /* synthetic */ JSlider access$1800(GeneralAllPrefPanel generalAllPrefPanel) {
            return generalAllPrefPanel.responsiveSlider;
        }

        static /* synthetic */ JCheckBox access$1900(GeneralAllPrefPanel generalAllPrefPanel) {
            return generalAllPrefPanel.confirmExit;
        }
    }

    public class VisualsPrefPanel
    extends BasicPrefPanel {
        private final JRadioButton topPlacement = new JRadioButton("Top");
        private final JRadioButton bottomPlacement = new JRadioButton("Bottom");
        private final JCheckBox statusBar = new JCheckBox("Show Status bar");
        private final JCheckBox toolBar = new JCheckBox("Show Toolbar");
        private final JCheckBox receivers = new JCheckBox("Show Receivers");
        private UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        private final ButtonGroup lookAndFeelGroup = new ButtonGroup();

        private VisualsPrefPanel() {
            super("Visuals");
            this.setupComponents();
            this.setupListeners();
        }

        private void setupListeners() {
            this.topPlacement.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(VisualsPrefPanel.access$700(this.this$1)).setTabPlacement(1);
                }
            });
            this.bottomPlacement.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(VisualsPrefPanel.access$700(this.this$1)).setTabPlacement(3);
                }
            });
            this.statusBar.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(VisualsPrefPanel.access$700(this.this$1)).setStatusBar(VisualsPrefPanel.access$800(this.this$1).isSelected());
                }
            });
            this.toolBar.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(VisualsPrefPanel.access$700(this.this$1)).setToolbar(VisualsPrefPanel.access$900(this.this$1).isSelected());
                }
            });
            this.receivers.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationPreferenceModelPanel.access$100(VisualsPrefPanel.access$700(this.this$1)).setReceivers(VisualsPrefPanel.access$1000(this.this$1).isSelected());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("tabPlacement", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    switch (n) {
                        case 1: {
                            VisualsPrefPanel.access$1100(this.this$1).setSelected(true);
                            break;
                        }
                        case 3: {
                            VisualsPrefPanel.access$1200(this.this$1).setSelected(true);
                            break;
                        }
                    }
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("statusBar", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    VisualsPrefPanel.access$800(this.this$1).setSelected((Boolean)propertyChangeEvent.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("toolbar", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    VisualsPrefPanel.access$900(this.this$1).setSelected((Boolean)propertyChangeEvent.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("receivers", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    VisualsPrefPanel.access$1000(this.this$1).setSelected((Boolean)propertyChangeEvent.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("lookAndFeelClassName", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getNewValue().toString();
                    Enumeration<AbstractButton> enumeration = VisualsPrefPanel.access$1300(this.this$1).getElements();
                    while (enumeration.hasMoreElements()) {
                        JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                        if (jRadioButton.getName() == null || !jRadioButton.getName().equals(string)) continue;
                        jRadioButton.setSelected(true);
                        break;
                    }
                }
            });
        }

        private void setupComponents() {
            Object object;
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Tab Placement"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.topPlacement);
            buttonGroup.add(this.bottomPlacement);
            jPanel.add(this.topPlacement);
            jPanel.add(this.bottomPlacement);
            this.add(jPanel);
            this.add(this.statusBar);
            this.add(this.receivers);
            this.add(this.toolBar);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Look & Feel"));
            for (int i = 0; i < this.lookAndFeels.length; ++i) {
                object = this.lookAndFeels[i];
                JRadioButton jRadioButton = new JRadioButton(((UIManager.LookAndFeelInfo)object).getName());
                jRadioButton.setName(((UIManager.LookAndFeelInfo)object).getClassName());
                jRadioButton.addActionListener(new ActionListener(this, (UIManager.LookAndFeelInfo)object){
                    private final /* synthetic */ UIManager.LookAndFeelInfo val$lfInfo;
                    private final /* synthetic */ VisualsPrefPanel this$1;
                    {
                        this.this$1 = visualsPrefPanel;
                        this.val$lfInfo = lookAndFeelInfo;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ApplicationPreferenceModelPanel.access$100(VisualsPrefPanel.access$700(this.this$1)).setLookAndFeelClassName(this.val$lfInfo.getClassName());
                    }
                });
                this.lookAndFeelGroup.add(jRadioButton);
                jPanel2.add(jRadioButton);
            }
            try {
                Class<?> clazz = Class.forName("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                object = new JRadioButton("GTK+ 2.0");
                ((AbstractButton)object).addActionListener(new ActionListener(this, clazz){
                    private final /* synthetic */ Class val$gtkLF;
                    private final /* synthetic */ VisualsPrefPanel this$1;
                    {
                        this.this$1 = visualsPrefPanel;
                        this.val$gtkLF = clazz;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ApplicationPreferenceModelPanel.access$100(VisualsPrefPanel.access$700(this.this$1)).setLookAndFeelClassName(this.val$gtkLF.getName());
                    }
                });
                this.lookAndFeelGroup.add((AbstractButton)object);
                jPanel2.add((Component)object);
            }
            catch (Exception exception) {
                LogLog.debug("Can't find new GTK L&F, might be Windows, or <JDK1.4.2");
            }
            this.add(jPanel2);
            this.add(new JLabel("Look and Feel change will apply the next time you start Chainsaw"));
        }

        static /* synthetic */ ApplicationPreferenceModelPanel access$700(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.ApplicationPreferenceModelPanel.this;
        }

        static /* synthetic */ JCheckBox access$800(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.statusBar;
        }

        static /* synthetic */ JCheckBox access$900(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.toolBar;
        }

        static /* synthetic */ JCheckBox access$1000(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.receivers;
        }

        static /* synthetic */ JRadioButton access$1100(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.topPlacement;
        }

        static /* synthetic */ JRadioButton access$1200(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.bottomPlacement;
        }

        static /* synthetic */ ButtonGroup access$1300(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.lookAndFeelGroup;
        }
    }
}

