/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public abstract class AppenderSkeleton
implements Appender,
OptionHandler {
    protected Layout layout;
    protected String name;
    protected Level threshold;
    protected ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    protected Filter headFilter;
    protected Filter tailFilter;
    protected boolean closed = false;
    private boolean guard = false;

    public void activateOptions() {
    }

    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.setNext(newFilter);
            this.tailFilter = newFilter;
        }
    }

    protected abstract void append(LoggingEvent var1);

    public void clearFilters() {
        this.headFilter = null;
        this.tailFilter = null;
    }

    public void finalize() {
        if (this.closed) {
            return;
        }
        LogLog.debug("Finalizing appender named [" + this.name + "].");
        this.close();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Filter getFilter() {
        return this.headFilter;
    }

    public final Filter getFirstFilter() {
        return this.headFilter;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public final String getName() {
        return this.name;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public boolean isAsSevereAsThreshold(Level level) {
        return this.threshold == null || level.isGreaterOrEqual(this.threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doAppend(LoggingEvent event) {
        if (this.closed) {
            LogLog.error("Attempted to append to closed appender named [" + this.name + "].");
            return;
        }
        if (this.guard) {
            return;
        }
        try {
            this.guard = true;
            if (!this.isAsSevereAsThreshold(event.getLevel())) {
                return;
            }
            Filter f = this.headFilter;
            block10: while (f != null) {
                switch (f.decide(event)) {
                    case -1: {
                        return;
                    }
                    case 1: {
                        break block10;
                    }
                    case 0: {
                        f = f.getNext();
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            this.append(event);
        }
        finally {
            this.guard = false;
        }
    }

    public synchronized void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            LogLog.warn("You have tried to set a null error-handler.");
        } else {
            this.errorHandler = eh;
        }
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }
}

