/*
 * Decompiled with CFR 0.152.
 */
package com.skybotsoftware.licenseserver.interchange;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class LicenseKeyRequest {
    private static final Set<String> ENV_KEYS = new HashSet<String>(Arrays.asList("COMPUTERNAME", "HOSTNAME", "USERDOMAIN"));
    private static final Set<String> PROP_KEYS = new HashSet<String>(Arrays.asList("sun.arch.data.model", "os.arch", "os.name", "os.version", "user.country", "user.language", "user.timezone"));
    private String hardwareId;
    private String skybotVersion;
    private Map<String, String> systemEnv;
    private Properties systemProperties;

    public String getHardwareId() {
        return this.hardwareId;
    }

    public void setHardwareId(String hardwareId) {
        this.hardwareId = hardwareId;
    }

    public String getSkybotVersion() {
        return this.skybotVersion;
    }

    public void setSkybotVersion(String skybotVersion) {
        this.skybotVersion = skybotVersion;
    }

    public Map<String, String> getSystemEnv() {
        return this.systemEnv;
    }

    public void setSystemEnv(Map<String, String> systemEnv) {
        this.systemEnv = systemEnv;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    private static void reduce(Map map, Set<String> set) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (set.contains(key)) continue;
            iterator.remove();
        }
    }

    public static LicenseKeyRequest createInstance(String hardwareId, String skybotVersion) {
        LicenseKeyRequest lr = new LicenseKeyRequest();
        lr.hardwareId = hardwareId;
        lr.skybotVersion = skybotVersion;
        HashMap<String, String> envmap = new HashMap<String, String>(System.getenv());
        LicenseKeyRequest.reduce(envmap, ENV_KEYS);
        lr.systemEnv = envmap;
        Properties sysProps = System.getProperties();
        Properties props = new Properties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            props.setProperty(key, sysProps.getProperty(key));
        }
        LicenseKeyRequest.reduce(props, PROP_KEYS);
        lr.systemProperties = props;
        return lr;
    }
}

