/*
 * Decompiled with CFR 0.152.
 */
package com.skybotsoftware.licenseserver.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.skybotsoftware.licenseserver.interchange.LicenseKeyRequest;
import com.skybotsoftware.licenseserver.interchange.LicenseKeyResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.log4j.Logger;

public class LicenseClient {
    private static final Logger LOGGER = Logger.getLogger(LicenseClient.class);
    private static final String SkybotLicenseServer = "ssl.helpsystems.com";
    private static final int SkybotLicenseServerPort = 443;
    private static final String URL = "true".equalsIgnoreCase(System.getProperty("devmode")) ? "http://bpeter:8002/SkybotLicenseServer/obtain" : "https://ssl.helpsystems.com/SkybotLicenseServer/obtain";

    public static LicenseKeyRequest prepareRequest(String hwid, String skybotVersion) {
        LicenseKeyRequest licenseRequest = LicenseKeyRequest.createInstance(hwid, skybotVersion);
        return licenseRequest;
    }

    public static void main(String[] args) {
        try {
            boolean lsAvailable = LicenseClient.isLicenseServerAvailable();
            System.out.println("License server is available: " + lsAvailable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isLicenseServerAvailable() throws IOException {
        Socket doorbell = null;
        boolean wasConnected = false;
        try {
            try {
                doorbell = new Socket();
                InetSocketAddress target = new InetSocketAddress(SkybotLicenseServer, 443);
                doorbell.connect(target, 5000);
                wasConnected = true;
            }
            catch (UnknownHostException uhex) {
                String errorMsg = "Unknown license server 'ssl.helpsystems.com' port '443'.";
                throw new IOException(errorMsg, uhex);
            }
            catch (Exception ex) {
                String errorMsg = "Unable to connect to license server 'ssl.helpsystems.com' port '443'.";
                throw new IOException(errorMsg, ex);
            }
        }
        catch (Throwable throwable) {
            if (doorbell != null) {
                try {
                    doorbell.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (doorbell != null) {
            try {
                doorbell.close();
            }
            catch (Exception exception) {}
        }
        return wasConnected;
    }

    public static LicenseKeyResponse obtainLicense(String hwid, String skybotVersion) throws IOException {
        return LicenseClient.obtainLicense(LicenseClient.prepareRequest(hwid, skybotVersion));
    }

    public static LicenseKeyResponse obtainLicense(LicenseKeyRequest licenseRequest) throws IOException {
        String truststoreFile = "skybotSSL.jks";
        File tf = new File(truststoreFile);
        DefaultHttpClient httpClient = null;
        LOGGER.debug((Object)("Using Keystore File: " + tf.getAbsolutePath()));
        if (tf.exists()) {
            char[] truststorePassword = null;
            try {
                LOGGER.debug((Object)("Loading truststore: " + tf.getAbsolutePath()));
                KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream truststoreInput = new FileInputStream(tf);
                truststore.load(truststoreInput, truststorePassword);
                LOGGER.debug((Object)("Truststore has " + truststore.size() + " keys"));
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                SSLSocketFactory lSchemeSocketFactory = new SSLSocketFactory(truststore);
                schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)lSchemeSocketFactory));
                httpClient = new DefaultHttpClient((ClientConnectionManager)new BasicClientConnectionManager(schemeRegistry));
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Error loading truststore.", (Throwable)ex);
                httpClient = new DefaultHttpClient();
            }
        } else {
            LOGGER.debug((Object)"Truststore not found!");
            httpClient = new DefaultHttpClient();
        }
        LicenseKeyResponse licenseResponse = null;
        try {
            try {
                LOGGER.info((Object)("Connecting to license server: " + URL));
                HttpPost httpRequest = new HttpPost(URL);
                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString((Object)licenseRequest);
                LOGGER.debug((Object)("Sending JSON: " + json));
                StringEntity params = new StringEntity(json);
                httpRequest.addHeader("content-type", "application/json");
                httpRequest.setEntity((HttpEntity)params);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
                InputStream in = httpResponse.getEntity().getContent();
                licenseResponse = (LicenseKeyResponse)mapper.readValue(in, LicenseKeyResponse.class);
                if (licenseResponse == null) {
                    throw new IOException("Invalid response received from the server.");
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException("Error communicating with the server", ex);
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return licenseResponse;
    }
}

