/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public final class TargetVersionInfo
implements Externalizable {
    private static final int END = -1001;
    private static final long serialVersionUID = -1317481352301375854L;
    public static final int SAME = 1;
    public static final int OLDER = 2;
    public static final int NEWER = 3;
    public static final int MIXED = 4;
    private Map<Integer, Integer> map = new HashMap<Integer, Integer>();

    public boolean equals(Object object) {
        int n;
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TargetVersionInfo targetVersionInfo = (TargetVersionInfo)object;
        int n2 = this.hashCode();
        return n2 == (n = targetVersionInfo.hashCode());
    }

    public int testCompatibility(TargetVersionInfo targetVersionInfo) {
        ValidationHelper.checkForNull("Version object", targetVersionInfo);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (Integer n : this.map.keySet()) {
            int n2 = n;
            int n3 = this.getVersion(n2);
            int n4 = targetVersionInfo.getVersion(n2);
            if (n4 == 0) continue;
            if (bl2 && n3 != n4) {
                bl2 = false;
            }
            if (bl3 && n4 < n3) {
                bl3 = false;
            }
            if (!bl || n4 <= n3) continue;
            bl = false;
        }
        if (bl2) {
            return 1;
        }
        if (bl3) {
            return 3;
        }
        if (bl) {
            return 2;
        }
        return 4;
    }

    public int hashCode() {
        int n = 1;
        for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
            int n2 = entry.getKey();
            int n3 = entry.getValue();
            n += n2 * n3;
        }
        return n;
    }

    public int getVersion(int n) {
        Integer n2 = this.map.get(new Integer(n));
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public void setVersion(int n, int n2) {
        this.map.put(new Integer(n), new Integer(n2));
    }

    public int getCommon() {
        return this.getVersion(29);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
            objectOutput.writeInt(entry.getKey());
            objectOutput.writeInt(entry.getValue());
        }
        objectOutput.writeInt(-1001);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        while ((n = objectInput.readInt()) != -1001) {
            int n2 = objectInput.readInt();
            this.setVersion(n, n2);
        }
        return;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TargetVersionInfo@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append(" size: ");
        stringBuffer.append(this.map.size());
        stringBuffer.append("\n");
        for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
            int n = entry.getKey();
            int n2 = entry.getValue();
            stringBuffer.append("\t");
            stringBuffer.append(InstalledProduct.getDescription(n));
            stringBuffer.append(": ");
            stringBuffer.append(n2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

