/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public enum SizeUnit implements Serializable
{
    BYTES(0),
    KILOBYTES(1),
    MEGABYTES(2),
    GIGABYTES(3),
    TERABYTES(4),
    PETABYTES(5),
    EXABYTES(6),
    ZETABYTES(7),
    YOTTABYTES(8);

    private int multiplier;

    private SizeUnit(int n2) {
        this.multiplier = n2;
    }

    public double getSizeInBytes(double d) {
        return this.convert(d, BYTES);
    }

    public String getAbbreviation() {
        switch (this.multiplier) {
            case 0: {
                return "bytes";
            }
            case 1: {
                return "KB";
            }
            case 2: {
                return "MB";
            }
            case 3: {
                return "GB";
            }
            case 4: {
                return "TB";
            }
            case 5: {
                return "PB";
            }
            case 6: {
                return "EB";
            }
            case 7: {
                return "ZB";
            }
            case 8: {
                return "YB";
            }
        }
        throw new IllegalArgumentException("Unknown multiplier: " + this.multiplier);
    }

    public String toString() {
        return this.getAbbreviation();
    }

    public String toString(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        ((NumberFormat)decimalFormat).setGroupingUsed(false);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(0);
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(2);
        return decimalFormat.format(d) + " " + this.getAbbreviation();
    }

    public double convert(double d, SizeUnit sizeUnit) {
        double d2 = d;
        int n = this.multiplier - sizeUnit.multiplier;
        while (n != 0) {
            if (n > 0) {
                d2 /= 1024.0;
                --n;
                continue;
            }
            d2 *= 1024.0;
            ++n;
        }
        if (this.multiplier == 0) {
            d2 = Math.floor(d2);
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        double d = MEGABYTES.convert(1.23456789E8, BYTES);
        System.out.println("meg = " + d);
        System.out.println(MEGABYTES.toString(d));
        d = BYTES.convert(d, MEGABYTES);
        System.out.println("bytes = " + d);
        System.out.println(BYTES.toString(d));
    }
}

