/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.Parameter;
import junit.framework.TestCase;

public class ParameterTest
extends TestCase {
    private Parameter p;

    protected void setUp() throws Exception {
        super.setUp();
        this.p = new Parameter(1, "x");
    }

    protected void tearDown() throws Exception {
        this.p = null;
        super.tearDown();
    }

    public void testGetRawString() {
        this.p.setRawString("abcdef");
        ParameterTest.assertEquals((String)"abcdef", (String)this.p.getRawString());
    }

    public void testParse() {
        try {
            Parameter.parse(0, "-p", "-p");
            ParameterTest.fail((String)"parse() accepted parameter that was not longer than the prefix");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Parameter.parse(0, "-p", "-xyz");
            ParameterTest.fail((String)"parse() accepted parameter that did not begin with the prefix");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Parameter.parse(0, "-p", "-p=23");
            ParameterTest.fail((String)"parse() accepted parameter with value but no name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Parameter parameter = Parameter.parse(5, "-p", "-pxyz");
        ParameterTest.assertEquals((String)"xyz", (String)parameter.getName());
        ParameterTest.assertEquals((String)"", (String)parameter.getValue());
        try {
            Parameter.parse(0, "-p", "-px=");
            ParameterTest.fail((String)"parse() accepted parameter with name but no value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Parameter parameter2 = Parameter.parse(12, "-", "-xyz=234");
        ParameterTest.assertEquals((String)"xyz", (String)parameter2.getName());
        ParameterTest.assertEquals((String)"234", (String)parameter2.getValue());
        ParameterTest.assertEquals((String)"-xyz=234", (String)parameter2.getRawString());
    }

    public void testGetPosition() {
        this.p.setPosition(13);
        ParameterTest.assertEquals((int)13, (int)this.p.getPosition());
    }

    public void testGetName() {
        try {
            this.p.setName(null);
            ParameterTest.fail((String)"setName() allowed null value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.p.setName("param1");
        ParameterTest.assertEquals((String)"param1", (String)this.p.getName());
    }

    public void testGetValue() {
        this.p.setValue("value1");
        ParameterTest.assertEquals((String)"value1", (String)this.p.getValue());
    }

    public void testToString() {
        Parameter parameter = new Parameter(13, "param1", "value1");
        ParameterTest.assertEquals((String)"Parameter at position 13 is named param1 with value: value1", (String)parameter.toString());
        Parameter parameter2 = new Parameter(12, "param1", null);
        ParameterTest.assertEquals((String)"Parameter at position 12 is named param1", (String)parameter2.toString());
    }

    public void testConstructorWithoutValue() {
        Parameter parameter = new Parameter(5, "p1");
        ParameterTest.assertEquals((String)"Parameter at position 5 is named p1 with value: ", (String)parameter.toString());
    }
}

