/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ObjectNameValidator {
    public static final int MAX_LENGTH_OBJECT_NAME = 10;
    public static final int MAX_LENGTH_LIBRARY_NAME = 10;
    private static final Set<Character> primaryCharMap;
    private static final Set<Character> secondaryCharMap;
    private static final Set<Character> allPossibleLibraryOrObjectCharacters;

    private ObjectNameValidator() {
    }

    public static void chkValidHSName(String string) {
        if (string == null) {
            throw new NullPointerException("The name is null.");
        }
        String string2 = string.trim();
        if (string2.length() < 1) {
            throw new IllegalArgumentException("The name cannot be blank.");
        }
        if (string2.length() > 10) {
            throw new IllegalArgumentException(string2 + " exceeds 10 characters.");
        }
        Character c = new Character(string2.charAt(0));
        if (!primaryCharMap.contains(c)) {
            throw new IllegalArgumentException(string2 + " does not start with a valid letter.");
        }
        for (int i = 1; i < string2.length(); ++i) {
            Character c2 = new Character(string2.charAt(i));
            if (secondaryCharMap.contains(c2)) continue;
            int n = i + 1;
            throw new IllegalArgumentException(string2 + " contains an invalid character (" + c2 + ") at position " + n + ".");
        }
    }

    public static Set<Character> getAllPossibleValidObjectOrLibraryNameCharacters() {
        return allPossibleLibraryOrObjectCharacters;
    }

    static {
        HashSet<Character> hashSet = new HashSet<Character>(30);
        hashSet.add(new Character('A'));
        hashSet.add(new Character('B'));
        hashSet.add(new Character('C'));
        hashSet.add(new Character('D'));
        hashSet.add(new Character('E'));
        hashSet.add(new Character('F'));
        hashSet.add(new Character('G'));
        hashSet.add(new Character('H'));
        hashSet.add(new Character('I'));
        hashSet.add(new Character('J'));
        hashSet.add(new Character('K'));
        hashSet.add(new Character('L'));
        hashSet.add(new Character('M'));
        hashSet.add(new Character('N'));
        hashSet.add(new Character('O'));
        hashSet.add(new Character('P'));
        hashSet.add(new Character('Q'));
        hashSet.add(new Character('R'));
        hashSet.add(new Character('S'));
        hashSet.add(new Character('T'));
        hashSet.add(new Character('U'));
        hashSet.add(new Character('V'));
        hashSet.add(new Character('W'));
        hashSet.add(new Character('X'));
        hashSet.add(new Character('Y'));
        hashSet.add(new Character('Z'));
        primaryCharMap = Collections.unmodifiableSet(hashSet);
        HashSet<Character> hashSet2 = new HashSet<Character>(primaryCharMap.size() + 15);
        hashSet2.addAll(primaryCharMap);
        hashSet2.add(new Character('0'));
        hashSet2.add(new Character('1'));
        hashSet2.add(new Character('2'));
        hashSet2.add(new Character('3'));
        hashSet2.add(new Character('4'));
        hashSet2.add(new Character('5'));
        hashSet2.add(new Character('6'));
        hashSet2.add(new Character('7'));
        hashSet2.add(new Character('8'));
        hashSet2.add(new Character('9'));
        hashSet2.add(new Character('_'));
        secondaryCharMap = Collections.unmodifiableSet(hashSet2);
        HashSet<Character> hashSet3 = new HashSet<Character>();
        hashSet3.addAll(hashSet2);
        hashSet3.add(new Character('.'));
        hashSet3.add(new Character('_'));
        hashSet3.add(new Character('@'));
        hashSet3.add(new Character('#'));
        hashSet3.add(new Character('$'));
        hashSet3.add(new Character('*'));
        hashSet3.add(new Character('/'));
        allPossibleLibraryOrObjectCharacters = Collections.unmodifiableSet(hashSet3);
    }
}

