/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.ValidationHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class NetworkUtils {
    private static Logger logger = Logger.getLogger(NetworkUtils.class);

    private NetworkUtils() {
    }

    public static InetAddress resolveAndConnect(String string, int n) throws UnknownHostException, IOException {
        ValidationHelper.checkForNullAndBlank("Hostname", string);
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        IOException iOException = null;
        for (int i = 0; i < inetAddressArray.length; ++i) {
            try {
                NetworkUtils.connect(inetAddressArray[i], n);
                logger.debug((Object)("Resolved to ip address " + inetAddressArray[i].getHostAddress()));
                return inetAddressArray[i];
            }
            catch (IOException iOException2) {
                if (iOException != null) continue;
                iOException = iOException2;
                continue;
            }
        }
        throw iOException;
    }

    public static void connect(InetAddress inetAddress, int n) throws UnknownHostException, IOException {
        ValidationHelper.checkForNull("Internet Address", inetAddress);
        try (Socket socket = null;){
            socket = new Socket(inetAddress.getHostAddress(), n);
        }
    }
}

