/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ResourceBundleHandler;

public class PacketDistributionRequest
extends CommonVersionedObject {
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(PacketDistributionRequest.class);
    private static final long serialVersionUID = -8009213674504560560L;
    public static final int ACTION_INSTALL = 1;
    public static final int ACTION_REVERSE = 2;
    private static final String ACTION_INSTALL_STRING = rbh.getText("install");
    private static final String ACTION_REVERSE_STRING = rbh.getText("reverse");
    private static final String ACTION_UNKNOWN_STRING = "!" + rbh.getText("unknown");
    public static final int PACKET_TYPE_UPDATE = 1;
    public static final int PACKET_TYPE_DELETE = 2;
    private static final String PACKET_TYPE_UPDATE_STRING = rbh.getText("update");
    private static final String PACKET_TYPE_DELETE_STRING = rbh.getText("delete");
    private static final String PACKET_TYPE_UNKNOWN_STRING = "!" + rbh.getText("unknown");
    private int packetOID;
    private int packetDistributionOID;
    private int targetHostSIID;
    private int productHeaderOID;
    private int productIID;
    private byte[][] payload;
    private int packetType;
    private int action;
    private String productRelease;

    public void setPacketOID(int n) {
        this.packetOID = n;
    }

    public int getPacketOID() {
        return this.packetOID;
    }

    public void setPacketDistributionOID(int n) {
        this.packetDistributionOID = n;
    }

    public int getPacketDistributionOID() {
        return this.packetDistributionOID;
    }

    public void setTargetHostOID(int n) {
        this.targetHostSIID = n;
    }

    public int getTargetHostSIID() {
        return this.targetHostSIID;
    }

    public void setProductHeaderOID(int n) {
        this.productHeaderOID = n;
    }

    public int getProductHeaderOID() {
        return this.productHeaderOID;
    }

    public void setProductIID(int n) {
        this.productIID = n;
    }

    public int getProductIID() {
        return this.productIID;
    }

    public void setPayload(byte[][] byArray) {
        this.payload = byArray;
    }

    public byte[][] getPayload() {
        return this.payload;
    }

    public void setPacketType(int n) {
        this.packetType = n;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public String getPacketTypeString() {
        switch (this.packetType) {
            case 1: {
                return PACKET_TYPE_UPDATE_STRING;
            }
            case 2: {
                return PACKET_TYPE_DELETE_STRING;
            }
        }
        return PACKET_TYPE_UNKNOWN_STRING;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public int getAction() {
        return this.action;
    }

    public String getActionString() {
        switch (this.action) {
            case 1: {
                return ACTION_INSTALL_STRING;
            }
            case 2: {
                return ACTION_REVERSE_STRING;
            }
        }
        return ACTION_UNKNOWN_STRING;
    }

    public void setProductRelease(String string) {
        this.productRelease = string;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        PacketDistributionRequest packetDistributionRequest = (PacketDistributionRequest)object;
        return Equal.isEqual(this.packetOID, packetDistributionRequest.packetOID) && Equal.isEqual(this.packetDistributionOID, packetDistributionRequest.packetDistributionOID) && Equal.isEqual(this.targetHostSIID, packetDistributionRequest.targetHostSIID) && Equal.isEqual(this.productHeaderOID, packetDistributionRequest.productHeaderOID) && Equal.isEqual(this.productIID, packetDistributionRequest.productIID) && Equal.isEqual(this.payload, packetDistributionRequest.payload) && Equal.isEqual(this.packetType, packetDistributionRequest.packetType) && Equal.isEqual(this.action, packetDistributionRequest.action) && Equal.isEqual(this.productRelease, packetDistributionRequest.productRelease);
    }
}

