/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.message;

import com.helpsystems.common.core.event.RoutableEvent;
import com.helpsystems.common.core.message.MessageEvent;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class MessageQueue {
    private static final Logger logger = Logger.getLogger(MessageQueue.class);
    private ArrayList<MessageEvent> messageQueue;
    private Object lockObject = new Object();
    private Thread messageQueueEvictorThread;

    public MessageQueue() {
        this.messageQueue = new ArrayList();
        this.messageQueueEvictorThread = new Thread();
        this.messageQueueEvictorThread.setPriority(4);
        Timer timer = new Timer();
        logger.trace((Object)"Our Message Queue Evictor is being started.");
        timer.schedule((TimerTask)new MessageQueueEvictorThread(), 5000L, 180000L);
    }

    public void addMessage(RoutableEvent routableEvent, String string) {
        if (routableEvent == null) {
            throw new IllegalArgumentException("Routable Event must not be null.");
        }
        logger.debug((Object)("====> Adding message " + string));
        MessageEvent messageEvent = new MessageEvent(routableEvent.getGUID(), routableEvent.getActionRequest());
        messageEvent.setMessage(string);
        this.addMessage(messageEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(MessageEvent messageEvent) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Message: " + messageEvent));
        }
        Object object = this.messageQueue;
        synchronized (object) {
            int n = this.messageQueue.indexOf(messageEvent);
            if (n == -1) {
                this.messageQueue.add(messageEvent);
            } else {
                this.messageQueue.get(n).setMessage(messageEvent.getMessage());
            }
        }
        object = this.lockObject;
        synchronized (object) {
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEvent getMessage(String string, long l) {
        MessageEvent messageEvent = null;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Message requested for GUID: " + string));
        }
        MessageEvent messageEvent2 = new MessageEvent(string, l);
        Object object = this.messageQueue;
        synchronized (object) {
            int n = this.messageQueue.indexOf(messageEvent2);
            if (n < 0 || this.messageQueue.size() < 1) {
                return null;
            }
            messageEvent = this.messageQueue.get(n);
            messageEvent.setServiced(true);
            this.messageQueue.remove(n);
        }
        object = this.lockObject;
        synchronized (object) {
            this.lockObject.notifyAll();
        }
        return messageEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEvent[] getAllMessagesForGUID(String string, boolean bl) {
        ArrayList<MessageEvent> arrayList = new ArrayList<MessageEvent>();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Requesting messages for GUID: " + string));
        }
        MessageEvent[] messageEventArray = this.messageQueue;
        synchronized (messageEventArray) {
            for (int i = 0; i < this.messageQueue.size(); ++i) {
                MessageEvent messageEvent = this.messageQueue.get(i);
                if (!messageEvent.getGUID().equals(string)) continue;
                messageEvent.setServiced(!bl);
                if (!bl) {
                    this.messageQueue.remove(i);
                }
                arrayList.add(messageEvent);
            }
        }
        messageEventArray = this.lockObject;
        synchronized (messageEventArray) {
            this.lockObject.notifyAll();
        }
        messageEventArray = new MessageEvent[arrayList.size()];
        return arrayList.toArray(messageEventArray);
    }

    public String getInfoHTML(String string) {
        MessageEvent[] messageEventArray = this.getAllMessagesForGUID(string, true);
        String string2 = "<table><tr><th>Action Request</th><th>Message</th></tr>";
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = messageEventArray.length;
        if (n < 1) {
            stringBuffer.append("<tr><td>None present</td><td>No messages currently pending...</td></tr>");
        } else {
            for (int i = 0; i < messageEventArray.length; ++i) {
                stringBuffer.append("<tr><td>");
                stringBuffer.append(messageEventArray[i].getActionRequest());
                stringBuffer.append("</td><td>");
                stringBuffer.append(messageEventArray[i].getMessage());
                stringBuffer.append("</td></tr>");
            }
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessages(String string) {
        MessageEvent messageEvent = null;
        ArrayList<MessageEvent> arrayList = new ArrayList<MessageEvent>();
        ArrayList<MessageEvent> arrayList2 = this.messageQueue;
        synchronized (arrayList2) {
            int n;
            for (n = 0; n < this.messageQueue.size(); ++n) {
                messageEvent = this.messageQueue.get(n);
                if (!messageEvent.getGUID().equals(string)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Clearing messages for GUID: " + messageEvent.getGUID()));
                }
                messageEvent.setServiced(false);
                arrayList.add(messageEvent);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                messageEvent = (MessageEvent)arrayList.get(n);
                this.messageQueue.remove(messageEvent);
            }
            arrayList.clear();
            this.messageQueue.notifyAll();
        }
    }

    class MessageQueueEvictorThread
    extends TimerTask {
        private static final long MESSAGE_LIMIT = 60000L;

        MessageQueueEvictorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MessageEvent messageEvent = null;
                ArrayList arrayList = MessageQueue.this.messageQueue;
                synchronized (arrayList) {
                    for (int i = 0; i < MessageQueue.this.messageQueue.size(); ++i) {
                        messageEvent = (MessageEvent)MessageQueue.this.messageQueue.get(i);
                        if (!messageEvent.shouldExpire(60000L)) continue;
                        messageEvent.setServiced(false);
                        MessageQueue.this.messageQueue.remove(i);
                    }
                    MessageQueue.this.messageQueue.notifyAll();
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"The Message Queue Evictor thread is no longer running", throwable);
            }
        }
    }
}

