/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.busobj.RoutableBasicIdentifier;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import java.io.Serializable;

public class RoutingIdentifier
extends CommonVersionedObject
implements RoutableBasicIdentifier,
XMLSerializable {
    private String hardwareHash;
    private Serializable instanceIdentifier;

    public RoutingIdentifier(String string, Serializable serializable) {
        ValidationHelper.checkForNullAndBlank("Hardware Hashcode", string);
        this.hardwareHash = string;
        ValidationHelper.checkForNull("Instance Identifier", serializable);
        this.instanceIdentifier = serializable;
    }

    public int hashCode() {
        return this.hardwareHash.hashCode() * this.instanceIdentifier.hashCode();
    }

    @Override
    public String getHardwareHash() {
        return this.hardwareHash;
    }

    @Override
    public Serializable getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RoutingIdentifier)) {
            return false;
        }
        RoutingIdentifier routingIdentifier = (RoutingIdentifier)object;
        return Equal.isEqual(routingIdentifier.hardwareHash, this.hardwareHash) && Equal.isEqual(routingIdentifier.instanceIdentifier, this.instanceIdentifier);
    }

    public String toString() {
        return "RoutingIdentifier " + this.instanceIdentifier + "@" + this.hardwareHash;
    }

    @Override
    public String[] doNotInvoke() {
        return null;
    }
}

