/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.InstalledProduct;
import junit.framework.TestCase;

public class InstalledProductTest
extends TestCase {
    InstalledProduct ip;

    protected void setUp() throws Exception {
        super.setUp();
        this.ip = new InstalledProduct();
    }

    protected void tearDown() throws Exception {
        this.ip = null;
        super.tearDown();
    }

    public void testGetLibraryName() {
        this.ip = new InstalledProduct("RBT", "RELMOD", null);
        InstalledProductTest.assertEquals((String)"", (String)this.ip.getLibraryName());
        this.ip = new InstalledProduct("RBT", "RELMOD", "");
        InstalledProductTest.assertEquals((String)"", (String)this.ip.getLibraryName());
        this.ip = new InstalledProduct("RBT", "RELMOD", "SOMELIB");
        InstalledProductTest.assertEquals((String)"SOMELIB", (String)this.ip.getLibraryName());
        this.ip.setLibraryName("NEWLIB");
        InstalledProductTest.assertEquals((String)"NEWLIB", (String)this.ip.getLibraryName());
    }

    public void testGetApplCode() {
        this.ip = new InstalledProduct("RBT", "RELMOD", "ROBOTLIB");
        InstalledProductTest.assertEquals((String)"RBT", (String)this.ip.getApplCode());
        this.ip.setApplCode("CON");
        InstalledProductTest.assertEquals((String)"CON", (String)this.ip.getApplCode());
    }

    public void testGetDescription() {
        this.ip = new InstalledProduct(0, "", "SOMELIB");
        InstalledProductTest.assertEquals((String)"Unknown", (String)this.ip.getDescription());
    }

    public void testIsInstalled() {
        this.ip.setRelMod("");
        this.ip.setLibraryName("");
        InstalledProductTest.assertFalse((boolean)this.ip.isInstalled());
        this.ip.setRelMod("X");
        this.ip.setLibraryName("L");
        InstalledProductTest.assertFalse((boolean)this.ip.isInstalled());
        this.ip.setRelMod("XYZ");
        this.ip.setLibraryName("");
        InstalledProductTest.assertFalse((boolean)this.ip.isInstalled());
        this.ip.setRelMod("");
        this.ip.setLibraryName("SOMELIB");
        InstalledProductTest.assertFalse((boolean)this.ip.isInstalled());
        this.ip.setRelMod("XYZ");
        this.ip.setLibraryName("SOMELIB");
        InstalledProductTest.assertTrue((boolean)this.ip.isInstalled());
    }

    public void testGetRelMod() {
        this.ip = new InstalledProduct("RBT", "R10M02  ", "ROBOTLIB");
        InstalledProductTest.assertEquals((String)"R10M02", (String)this.ip.getRelMod());
        this.ip.setRelMod("R10M03");
        InstalledProductTest.assertEquals((String)"R10M03", (String)this.ip.getRelMod());
        this.ip.setRelMod("  SQUIGGLE  ");
        InstalledProductTest.assertEquals((String)"  SQUIGGLE  ", (String)this.ip.getRelMod());
    }

    public void testGetNumApps() {
        InstalledProductTest.assertEquals((int)41, (int)InstalledProduct.getNumApps());
    }

    public void testGetDescriptionString() {
        InstalledProductTest.assertEquals((String)"Unknown", (String)InstalledProduct.getDescription("UNK"));
        InstalledProductTest.assertEquals((String)"Robot/SCHEDULE", (String)InstalledProduct.getDescription("RBT"));
        InstalledProductTest.assertNull((Object)InstalledProduct.getDescription("666"));
    }

    public void testGetApplCodeInt() {
        InstalledProductTest.assertEquals((String)"UNK", (String)InstalledProduct.getApplCode(0));
        InstalledProductTest.assertEquals((String)"RBT", (String)InstalledProduct.getApplCode(1));
        InstalledProductTest.assertEquals((String)"CON", (String)InstalledProduct.getApplCode(3));
        try {
            InstalledProduct.getApplCode(-1);
            InstalledProductTest.fail((String)"getApplCode(int) returned value for negative application code");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            InstalledProduct.getApplCode(2423423);
            InstalledProductTest.fail((String)"getApplCode(int) returned value for invalid application code");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDescriptionInt() {
        InstalledProductTest.assertEquals((String)"Unknown", (String)InstalledProduct.getDescription(0));
        InstalledProductTest.assertEquals((String)"Robot/SCHEDULE", (String)InstalledProduct.getDescription(1));
        InstalledProductTest.assertEquals((String)"Robot/CONSOLE", (String)InstalledProduct.getDescription(3));
        try {
            InstalledProduct.getDescription(-1);
            InstalledProductTest.fail((String)"getDescription(int) returned value for negative application code");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            InstalledProduct.getDescription(2423423);
            InstalledProductTest.fail((String)"getDescription(int) returned value for invalid application code");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetProductCodes() {
        String[] stringArray = InstalledProduct.getProductCodes();
        InstalledProductTest.assertTrue((boolean)InstalledProductTest.arrayContains(stringArray, "UNK"));
        InstalledProductTest.assertTrue((boolean)InstalledProductTest.arrayContains(stringArray, "RBT"));
        InstalledProductTest.assertTrue((boolean)InstalledProductTest.arrayContains(stringArray, "CON"));
        InstalledProductTest.assertFalse((boolean)InstalledProductTest.arrayContains(stringArray, "666"));
    }

    public void testGetIDFromApplCode() {
        InstalledProductTest.assertEquals((int)0, (int)InstalledProduct.getIDFromApplCode("UNK"));
        InstalledProductTest.assertEquals((int)1, (int)InstalledProduct.getIDFromApplCode("RBT"));
        InstalledProductTest.assertEquals((int)3, (int)InstalledProduct.getIDFromApplCode("CON"));
        try {
            InstalledProduct.getIDFromApplCode("666");
            InstalledProductTest.fail((String)"getIDFromApplCode(String) returned value for invalid application code");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.ip.doNotInvoke();
        InstalledProductTest.assertEquals((int)2, (int)stringArray.length);
        InstalledProductTest.assertTrue((boolean)InstalledProductTest.arrayContains(stringArray, "getDescription"));
        InstalledProductTest.assertTrue((boolean)InstalledProductTest.arrayContains(stringArray, "isInstalled"));
    }

    public void testEqualsObject() {
        InstalledProductTest.assertFalse((boolean)this.ip.equals(new Object()));
        InstalledProductTest.assertTrue((boolean)this.ip.equals(this.ip));
        this.ip.setApplCode("RBT");
        InstalledProduct installedProduct = new InstalledProduct(1, "", "");
        InstalledProductTest.assertTrue((boolean)this.ip.equals(installedProduct));
        this.ip.setApplCode("CON");
        InstalledProductTest.assertFalse((boolean)this.ip.equals(installedProduct));
    }

    private static boolean arrayContains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

