/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.alert;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.ValidationHelper;

public class AlertMessageInfo
extends CommonVersionedObject {
    public static final int MAXLEN_DEVICE_NAME = 10;
    public static final int MAXLEN_MESSAGE_TEXT = 1000;
    public static final int MAXLEN_SUBJECT = 256;
    public static final int MAXLEN_ATTACH_PATH = 256;
    public static final int RESP_REQ_SETUP = 0;
    public static final int RESP_REQ_NO = 1;
    public static final int RESP_REQ_YES = 2;
    private String deviceName = null;
    private String messageText = null;
    private String subject = null;
    private String attachmentPath = null;
    private int responseRequired = 0;

    public AlertMessageInfo() {
    }

    public AlertMessageInfo(String string, String string2) {
        this.setDeviceName(string);
        this.setMessageText(string2);
    }

    public String buildSndMsgCommand() {
        if (this.deviceName == null) {
            throw new IllegalStateException("Alert device name is null.");
        }
        if (this.messageText == null) {
            throw new IllegalStateException("Alert message text is null.");
        }
        String string = "RBASNDMSG MSG('" + this.messageText.replaceAll("'", "''") + "') TOPG('" + this.deviceName.replaceAll("'", "''") + "')";
        String string2 = "*SETUP";
        switch (this.responseRequired) {
            case 1: {
                string2 = "*NO";
                break;
            }
            case 2: {
                string2 = "*YES";
            }
        }
        string = string + " RSP(" + string2 + ")";
        string = string + " TRUNCATE(*YES)";
        if (this.subject != null) {
            string = string + " SUBJECT('" + this.subject.replaceAll("'", "''") + "')";
        }
        if (this.attachmentPath != null) {
            string = string + " ATTACH('" + this.attachmentPath.replaceAll("'", "''") + "')";
        }
        return string;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String string) {
        String string2 = "Alert Device Name";
        ValidationHelper.checkForNull(string2, string);
        String string3 = Convert.trimR(string);
        ValidationHelper.checkForBlankIgnoreNull(string2, string3);
        ValidationHelper.validateLength(string2, 10, string3);
        this.deviceName = string3.toUpperCase();
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String string) {
        String string2 = "Message Text";
        ValidationHelper.checkForNull(string2, string);
        String string3 = Convert.trimR(string);
        ValidationHelper.checkForBlankIgnoreNull(string2, string3);
        ValidationHelper.validateLength(string2, 1000, string3);
        this.messageText = string3;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        String string2 = "Message Subject";
        if (string == null) {
            this.subject = null;
        } else {
            String string3 = Convert.trimR(string);
            ValidationHelper.validateLength(string2, 256, string3);
            this.subject = string3;
        }
    }

    public String getAttachmentPath() {
        return this.attachmentPath;
    }

    public void setAttachmentPath(String string) {
        String string2 = "Alert Message Attachment Path";
        if (string == null) {
            this.attachmentPath = null;
        } else {
            ValidationHelper.validateLength(string2, 256, string);
            this.attachmentPath = string;
        }
    }

    public int getResponseRequired() {
        return this.responseRequired;
    }

    public void setResponseRequired(int n) {
        this.responseRequired = n;
    }
}

