/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.OutputDistributionHistory;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.OutputDistributionAM;
import com.helpsystems.enterprise.core.dm.OutputDistributionHistoryDM;
import com.helpsystems.enterprise.scheduler.executors.AbstractPurgeRunner;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class OutputDistributionHistoryPurgeRunner
extends AbstractPurgeRunner {
    @Override
    public String getName() {
        return RosettaMsg.OUTPUT_DISTRIBUTION_HISTORY.newLogEntry().getMessageText();
    }

    @Override
    public boolean isOkToRunPurge(SystemSetup systemSetup) {
        return true;
    }

    @Override
    public void doPurge(SystemSetup systemSetup) throws ResourceUnavailableException, DataException, SQLException {
        OutputDistributionAM outputDistributionAM = (OutputDistributionAM)ManagerRegistry.getManager((String)"ENTERPRISE.OutputDistributionAM");
        OutputDistributionHistoryDM outputDistributionHistoryDM = (OutputDistributionHistoryDM)ManagerRegistry.getManager((String)"ENTERPRISE.OutputDistributionHistoryDM");
        String string = DateTranslator.packTime((Date)new Date(System.currentTimeMillis()));
        int n = Integer.parseInt(string);
        try {
            OutputDistributionHistory[] outputDistributionHistoryArray = outputDistributionHistoryDM.getByKeepUntil((long)n);
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (OutputDistributionHistory outputDistributionHistory : outputDistributionHistoryArray) {
                if (outputDistributionHistory.getKeepUntil() == 0L || outputDistributionHistory.getKeepUntil() == -1L) continue;
                outputDistributionAM.purgeOutputDistributionHistoryFiles(outputDistributionHistory);
                arrayList.add(outputDistributionHistory.getOid());
            }
            outputDistributionHistoryDM.massDelete(null, arrayList, 0L);
        }
        catch (DataException dataException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error deleting output distribution history", (Throwable)dataException);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)"Error deleting output distribution history", (Throwable)resourceUnavailableException);
        }
    }
}

