/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.CrossAppenderLogger;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.DateObjectDM;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DateObjectExpirationRunner
implements Runnable {
    static Logger logger = Logger.getLogger(DateObjectExpirationRunner.class);
    private static final int START_WARNING = 28;
    private static final int FOUR_WEEK_WARNING = 28;
    private static final int THREE_WEEK_WARNING = 21;
    private static final int TWO_WEEK_WARNING = 14;
    private static final int LAST_WEEK_WARNING = 7;

    @Override
    public void run() {
        int n = 0;
        logger.debug((Object)"Checking for expiring Date Lists...");
        Date date = new Date(System.currentTimeMillis());
        try {
            DateObjectDM dateObjectDM = (DateObjectDM)ManagerRegistry.getManager((String)"ENTERPRISE.DateObjectDM");
            DateObject[] dateObjectArray = dateObjectDM.getList();
            if (dateObjectArray != null && dateObjectArray.length > 0) {
                for (int i = 0; i < dateObjectArray.length; ++i) {
                    boolean bl = false;
                    int n2 = -1;
                    DateObject dateObject = dateObjectArray[i];
                    if (!dateObject.isNotifyBeforeExpiration()) continue;
                    int[] nArray = dateObject.getDates();
                    int n3 = 0;
                    if (nArray.length > 0) {
                        n3 = nArray[nArray.length - 1];
                        Date date2 = new SimpleDateFormat("yyyyMMddhhmmss").parse(Integer.toString(n3, 0) + "235959");
                        long l = date2.getTime() - date.getTime();
                        double d = l / 86400000L;
                        n2 = (int)d;
                        if (logger.isTraceEnabled()) {
                            if (l >= 0L) {
                                logger.trace((Object)("Date List " + dateObject.getName() + " expires in " + n2 + " days (" + date2 + ")."));
                            } else {
                                logger.trace((Object)("Date List " + dateObject.getName() + " expired " + Math.abs(n2) + " days ago (" + date2 + ")."));
                            }
                        }
                        if (l >= 0L && n2 >= 0 && n2 <= 28) {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    ++n;
                    this.sendExpiringNotification(n2, dateObject);
                }
            }
        }
        catch (Exception exception) {
            this.sendFailedMessage(exception);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + n + " Date Lists expiring soon."));
        }
    }

    private void sendExpiringNotification(int n, DateObject dateObject) {
        if (n == 28 || n == 28 || n == 21 || n == 14 || n <= 7) {
            ScheduleLogEntry scheduleLogEntry;
            String[] stringArray = new String[]{dateObject.getName(), Integer.toString(n)};
            SystemMessage systemMessage = null;
            SystemMessage systemMessage2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE.newSystemMessage();
            if (n > 0) {
                if (n > 1) {
                    scheduleLogEntry = RosettaMsg.DATE_OBJECT_EXPIRING_DAYS.newLogEntry(stringArray);
                    systemMessage = RosettaMsg.DATE_OBJECT_EXPIRING_DAYS.newSystemMessage(stringArray);
                    systemMessage2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_DAYS.newSystemMessage(stringArray);
                } else {
                    scheduleLogEntry = RosettaMsg.DATE_OBJECT_EXPIRING_TOMORROW.newLogEntry(stringArray);
                    systemMessage = RosettaMsg.DATE_OBJECT_EXPIRING_TOMORROW.newSystemMessage(stringArray);
                    systemMessage2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_TOMORROW.newSystemMessage(stringArray);
                }
            } else {
                scheduleLogEntry = RosettaMsg.DATE_OBJECT_EXPIRING_TODAY.newLogEntry(stringArray);
                systemMessage = RosettaMsg.DATE_OBJECT_EXPIRING_TODAY.newSystemMessage(stringArray);
                systemMessage2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE_DATE_OBJECT_EXPIRING_TODAY.newSystemMessage(stringArray);
            }
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            SystemMessageQueue.write((SystemMessage)systemMessage, (SystemMessage)systemMessage2);
            logger.warn((Object)scheduleLogEntry.getMessageText());
            CrossAppenderLogger.logMessage((Log4jID)Log4jID.SCHEDULER, (Level)Level.WARN, (String)scheduleLogEntry.getMessageText());
        }
    }

    private void sendFailedMessage(Exception exception) {
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.FAILED_TO_RUN.newLogEntry(this.getNameForRosettaMsg());
        logger.debug((Object)scheduleLogEntry.getMessageText(), (Throwable)exception);
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    public String toString() {
        return RosettaMsg.RUNNER_NAME.newLogEntry(this.getNameForRosettaMsg()).getMessageText();
    }

    private String[] getNameForRosettaMsg() {
        String[] stringArray = new String[]{this.getName()};
        return stringArray;
    }

    public String getName() {
        return RosettaMsg.EXPIRING_DATE_OBJECT_NAME.newLogEntry().getMessageText();
    }
}

