/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.MissedAgentJob;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobMonitorAM;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.ScheduledJobsList;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.scheduler.Drivable;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import com.helpsystems.enterprise.scheduler.PrereqEvaluator;
import com.helpsystems.enterprise.scheduler.ReactivityMonitor;
import com.helpsystems.enterprise.scheduler.RunMissedJobs;
import com.helpsystems.enterprise.scheduler.SchedulerAMImpl;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class Scheduler
implements Drivable {
    private static final Logger logger = Logger.getLogger(Scheduler.class);
    private PrereqEvaluator prereqEvaluator;
    private ScheduledTimeDM scheduledTimeDM;
    private Object waitLock = new Object();
    private boolean sleeping;
    private Calendar earliestNST;
    private boolean isSet_earliestNST;
    private long waitTime;
    private long minWaitTime = 1000L;
    private long maxWaitTime = 120000L;
    private long previousNanoTimerReading;
    private long previousTimePerClock;
    private long maxClockAdjustmentAllowedBeforeErrorIssued_InSeconds = TimeUnit.HOURS.toSeconds(2L);
    private boolean shutdown;
    private ScheduledJobsList list;
    Set<MissedAgentJob> missedAgentJobs = null;
    Map<Long, Calendar> alreadyProcessed = new HashMap<Long, Calendar>();
    Map<Long, Calendar> blackballed = new HashMap<Long, Calendar>();
    private boolean ignoreMissedJobs = false;
    private Date ignoreMissedJobsBeforeDate = null;

    public Scheduler(ScheduledTimeDM scheduledTimeDM, PrereqEvaluator prereqEvaluator, Set<MissedAgentJob> set, boolean bl, Date date) {
        ValidationHelper.checkForNull((String)"ScheduledTimeDM", (Object)scheduledTimeDM);
        ValidationHelper.checkForNull((String)"PrereqEvaluator", (Object)prereqEvaluator);
        this.scheduledTimeDM = scheduledTimeDM;
        this.prereqEvaluator = prereqEvaluator;
        this.missedAgentJobs = set;
        this.ignoreMissedJobs = bl;
        this.ignoreMissedJobsBeforeDate = date;
    }

    @Override
    public void start() {
        MDC.put((String)"MDC_LOG_ID", (String)Log4jID.SCHEDULER.getMDCKeyValue());
        this.processMissedJobs();
        this.notifyJobMonitorManager();
        this.notifySAPInterceptedJobMonitor();
    }

    @Override
    public void prepareForRestart() {
        logger.info((Object)"Preparing to restart the Scheduler.");
        if (this.list != null) {
            this.list.close();
            this.list = null;
        }
    }

    @Override
    public void run() {
        this.mainLoop();
    }

    private void notifyJobMonitorManager() {
        JobMonitorManagerAM jobMonitorManagerAM = MRHelper.getJobMonitorManagerAM();
        if (jobMonitorManagerAM != null) {
            jobMonitorManagerAM.setMissedJobsProcessComplete(true);
        }
    }

    private void notifySAPInterceptedJobMonitor() {
        SAPInterceptedJobMonitorAM sAPInterceptedJobMonitorAM = (SAPInterceptedJobMonitorAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.SAPInterceptedJobMonitorAM");
        if (sAPInterceptedJobMonitorAM != null) {
            sAPInterceptedJobMonitorAM.setMissedJobsProcessComplete(true);
        }
    }

    @Override
    public String getName() {
        return "Scheduler";
    }

    @Override
    public boolean isShuttingDown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.shutdown) {
            Object object;
            this.shutdown = true;
            logger.info((Object)"Scheduler shutdown requested.");
            try {
                object = (SchedulerAMImpl)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SchedulerAM");
                NSTCalculator nSTCalculator = object.getNSTCalculator();
                nSTCalculator.setScheduler(null);
            }
            catch (Exception exception) {
                try {
                    logger.warn((Object)"Error clearing the NSTCalculator scheduler reference.");
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            object = this.waitLock;
            synchronized (object) {
                if (this.sleeping) {
                    this.waitLock.notify();
                }
            }
        }
    }

    private void processMissedJobs() {
        Calendar calendar = RunMissedJobs.getStartTime();
        RunMissedJobs runMissedJobs = new RunMissedJobs();
        runMissedJobs.processMissedJobs(calendar, this.missedAgentJobs, this, this.ignoreMissedJobs, this.ignoreMissedJobsBeforeDate);
        this.missedAgentJobs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        try {
            while (!this.shutdown) {
                Object object = this.waitLock;
                synchronized (object) {
                    while (!this.arrivedAtNST() && !this.shutdown) {
                        this.setWaitTime();
                        this.sleeping = true;
                        try {
                            this.waitLock.wait(this.waitTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.sleeping = false;
                    }
                    this.isSet_earliestNST = false;
                }
                if (this.shutdown) continue;
                this.process();
            }
            this.cleanup();
        }
        catch (ClockAdjustmentException clockAdjustmentException) {
        }
        catch (Exception exception) {
            String string = "Scheduler error ...";
            logger.error((Object)string, (Throwable)exception);
        }
    }

    private boolean arrivedAtNST() {
        if (this.earliestNST == null) {
            try {
                if (this.list == null) {
                    this.list = this.scheduledTimeDM.getScheduledJobsList();
                } else {
                    this.list.reload();
                }
                while (this.list.next() && this.earliestNST == null) {
                    Calendar calendar = this.list.getNextScheduledTime();
                    if (this.isBlackballed(this.list.getJobNumber(), this.list.getSystem(), calendar)) continue;
                    this.earliestNST = calendar;
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)("Error checking NST: " + resourceUnavailableException.getMessage()), (Throwable)resourceUnavailableException);
            }
        }
        if (this.earliestNST == null) {
            return false;
        }
        long l = this.earliestNST.getTimeInMillis();
        return this.currentTime() >= l;
    }

    private void process() throws ResourceUnavailableException {
        long l = this.currentTime();
        this.alreadyProcessed.clear();
        if (this.list == null) {
            this.list = this.scheduledTimeDM.getScheduledJobsList();
        } else {
            this.list.reload();
        }
        while (this.list.next() && !this.shutdown) {
            Calendar calendar = this.list.getNextScheduledTime();
            long l2 = calendar.getTimeInMillis();
            if (l2 <= l) {
                this.processJob(this.list.getJobNumber(), this.list.getSystem(), calendar);
                continue;
            }
            l = this.currentTime();
            if (l2 > l) break;
            this.processJob(this.list.getJobNumber(), this.list.getSystem(), calendar);
        }
        this.setEarliestNST();
    }

    private void cleanup() {
        this.closeList();
        this.prereqEvaluator.shutDown();
    }

    private void closeList() {
        if (this.list != null) {
            this.list.close();
        }
    }

    private long currentTime() {
        long l = System.currentTimeMillis();
        this.detectClockAdjustment(l);
        return l;
    }

    private void detectClockAdjustment(long l) {
        long l2;
        if (this.previousTimePerClock == 0L) {
            this.previousTimePerClock = l;
            this.previousNanoTimerReading = System.nanoTime();
            return;
        }
        long l3 = System.nanoTime();
        long l4 = this.roundToNearestMilliSecond(l3 - this.previousNanoTimerReading);
        long l5 = Math.abs(l4 - (l2 = l - this.previousTimePerClock));
        if (l5 > this.maxClockAdjustmentAllowedBeforeErrorIssued_InSeconds * 1000L) {
            String[] stringArray = new String[]{this.formatMaxClockAdjustmentAllowed()};
            RosettaMsg rosettaMsg = RosettaMsg.CLOCK_ADJUSTMENT_EXCEEDED_MAX_ALLOWED;
            ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            SystemMessage systemMessage = RosettaMsg.CLOCK_ADJUSTMENT_EXCEEDED_MAX_ALLOWED.newSystemMessage(stringArray);
            SystemMessageQueue.write((SystemMessage)systemMessage);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            String string = MessageUtil.formatMsg((String)"A clock adjustment was detected that exceeded {0}. As a safety precaution, the Scheduler was automatically stopped. The Scheduler read the clock at {1}. {2} later, when the clock was read again, the expected date/time was {3}. However, the date/time that the clock reported was {4}.", (Object[])new Object[]{this.formatMaxClockAdjustmentAllowed(), simpleDateFormat.format(new Date(this.previousTimePerClock)), this.formatElapsedTimePerNanoTimer(l4), simpleDateFormat.format(new Date(this.previousTimePerClock + l4)), simpleDateFormat.format(new Date(l))});
            logger.error((Object)string);
            this.shutdown();
            this.stopReactivityMonitor();
            throw new ClockAdjustmentException();
        }
        this.previousTimePerClock = l;
        this.previousNanoTimerReading = l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOfPossibleEarliestNST(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        Object object = this.waitLock;
        synchronized (object) {
            if (this.sleeping) {
                if (this.earliestNST == null || calendar.before(this.earliestNST)) {
                    this.earliestNST = calendar;
                    this.waitLock.notify();
                }
            } else if (this.isSet_earliestNST && (this.earliestNST == null || calendar.before(this.earliestNST))) {
                this.earliestNST = calendar;
            }
        }
    }

    private void processJob(int n, int n2, Calendar calendar) {
        if (!this.isBlackballed(n, n2, calendar)) {
            this.alreadyProcessed.put(this.encodeKey(n, n2), calendar);
            this.prereqEvaluator.timerEvent(n, n2, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEarliestNST() throws ResourceUnavailableException {
        Object object = this.waitLock;
        synchronized (object) {
            this.list.reload();
            this.earliestNST = null;
            while (this.list.next() && this.earliestNST == null) {
                Calendar calendar;
                int n;
                int n2 = this.list.getJobNumber();
                if (this.isBlackballed(n2, n = this.list.getSystem(), calendar = this.list.getNextScheduledTime())) continue;
                if (this.alreadyProcessedDuringThisWakeup(n2, n, calendar)) {
                    this.blackballed.put(this.encodeKey(n2, n), calendar);
                    this.logBlackballed(n2, n, calendar);
                    continue;
                }
                this.earliestNST = calendar;
            }
            this.isSet_earliestNST = true;
        }
    }

    private void setWaitTime() {
        long l = this.currentTime();
        if (this.earliestNST == null) {
            this.waitTime = this.maxWaitTime;
        } else {
            long l2 = this.earliestNST.getTimeInMillis();
            this.waitTime = this.roundToNearestSecond(l2 - l);
            if (this.waitTime > this.maxWaitTime) {
                this.waitTime = this.maxWaitTime;
            } else if (this.waitTime < this.minWaitTime) {
                this.waitTime = this.minWaitTime;
            }
        }
    }

    private void stopReactivityMonitor() {
        try {
            Object object;
            ReactivityAM reactivityAM = (ReactivityAM)ManagerRegistry.getManager((String)"ENTERPRISE.ReactivityAM");
            if (reactivityAM != null && (object = reactivityAM.getReactivityMonitor()) != null && object instanceof ReactivityMonitor) {
                ((ReactivityMonitor)object).shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatElapsedTimePerNanoTimer(long l) {
        int n = (int)l;
        int n2 = (n + 500) / 1000;
        if (n2 % 60 == 0) {
            return MessageUtil.formatMsg((String)"{0} minutes", (Object[])new Object[]{n2 / 60});
        }
        return MessageUtil.formatMsg((String)"{0} seconds", (Object[])new Object[]{n2});
    }

    private String formatMaxClockAdjustmentAllowed() {
        int n = (int)this.maxClockAdjustmentAllowedBeforeErrorIssued_InSeconds;
        if (n == 3600) {
            return "1 hour";
        }
        if (n % 3600 == 0) {
            return MessageUtil.formatMsg((String)"{0} hours", (Object[])new Object[]{n / 3600});
        }
        if (n % 60 == 0) {
            return MessageUtil.formatMsg((String)"{0} minutes", (Object[])new Object[]{n / 60});
        }
        return MessageUtil.formatMsg((String)"{0} seconds", (Object[])new Object[]{n});
    }

    private long roundToNearestSecond(long l) {
        return (l + 500L) / 1000L * 1000L;
    }

    private long roundToNearestMilliSecond(long l) {
        return (l + 500000L) / 1000000L;
    }

    private boolean alreadyProcessedDuringThisWakeup(int n, int n2, Calendar calendar) {
        long l = this.encodeKey(n, n2);
        return this.alreadyProcessed.containsKey(l) && this.alreadyProcessed.get(l).getTimeInMillis() == calendar.getTimeInMillis();
    }

    private long encodeKey(int n, int n2) {
        try {
            if (n < 0 || n2 < 0) {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"The arguments must both be positive numbers. Values received: {0} and {1}.", (Object[])new Object[]{n, n2}));
            }
            long l = n;
            l <<= 32;
            int n3 = (int)((l += (long)n2) >> 32);
            if (n3 != n) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Expected left integer = {0}. Actual = {1}.", (Object[])new Object[]{n, n3}));
            }
            int n4 = (int)l;
            if (n4 != n2) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Expected right integer = {0}. Actual = {1}.", (Object[])new Object[]{n2, n4}));
            }
            return l;
        }
        catch (Exception exception) {
            String string = "Program error while encoding the key used for rerun prevention.";
            logger.error((Object)string, (Throwable)exception);
            return 0L;
        }
    }

    private boolean isBlackballed(int n, int n2, Calendar calendar) {
        long l = this.encodeKey(n, n2);
        if (this.blackballed.containsKey(l)) {
            Calendar calendar2 = this.blackballed.get(l);
            if (calendar2.getTimeInMillis() == calendar.getTimeInMillis()) {
                return true;
            }
            if (calendar.after(calendar2)) {
                this.blackballed.remove(l);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
                simpleDateFormat.setTimeZone(calendar2.getTimeZone());
                logger.debug((Object)MessageUtil.formatMsg((String)"The rerun prevention feature of the scheduler has removed the {0} occurrence of job {1} on agent {2} from the do-not-run list. New list size = {3}.", (Object[])new Object[]{simpleDateFormat.format(calendar2.getTime()), n, n2, this.blackballed.size()}));
                return false;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            String string = MessageUtil.formatMsg((String)"Unexpected program state while trying to determine if the {0} occurrence of job {1} on agent {2} has already been processed. The date/time of the candidate occurrence ({0}) is less than that of the do-not-run occurrence ({3}).", (Object[])new Object[]{simpleDateFormat.format(calendar.getTime()), n, n2, simpleDateFormat.format(calendar2.getTime())});
            logger.error((Object)string);
        }
        return false;
    }

    private void logBlackballed(int n, int n2, Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        String[] stringArray = new String[]{Integer.toString(n), Integer.toString(n2), simpleDateFormat.format(calendar.getTime())};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.SCHEDULER_BYPASSED_JOB.newLogEntry(stringArray, (long)n2, (long)n);
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        String string = MessageUtil.formatMsg((String)"The rerun prevention feature of the scheduler has moved the {0} occurrence of job {1} on agent {2} to a do-not-run list. It is suspected that the job was processed but that the next date/time that the job should run was not successfully calculated and saved to the database.", (Object[])new Object[]{simpleDateFormat.format(calendar.getTime()), n, n2});
        logger.error((Object)string);
    }

    class ClockAdjustmentException
    extends RuntimeException {
        private static final long serialVersionUID = 4739885327593798524L;

        ClockAdjustmentException() {
        }
    }
}

