/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.ex;

import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.tl.PeerDescriptor;
import java.io.Serializable;

public class RemoteManagerNotFoundException
extends ManagerNotFoundException
implements Serializable {
    private static final long serialVersionUID = 368148106277615850L;
    public static final int NO_EXTENDED_ERROR = 0;
    public static final int PEER_NOT_CONNECTED = 1;
    public static final int AMBIGOUS_MATCH = 2;
    public static final int NO_PROVIDER = 3;
    public static final int SPECIAL_MESSAGE = 4;
    private String message;
    private PeerDescriptor who;
    private int extendedErrorCode;

    public RemoteManagerNotFoundException(PeerDescriptor peerDescriptor, String string, int n) {
        this(peerDescriptor, string, n, null);
    }

    public RemoteManagerNotFoundException(String string, String string2, Throwable throwable) {
        this(null, string, 4, throwable);
        this.message = string2;
    }

    public RemoteManagerNotFoundException(PeerDescriptor peerDescriptor, String string, int n, Throwable throwable) {
        super(string, throwable);
        this.extendedErrorCode = n;
        this.who = peerDescriptor != null ? peerDescriptor : new PeerDescriptor();
    }

    public PeerDescriptor getPeerDescriptor() {
        return this.who;
    }

    public int getExtendedErrorCode() {
        return this.extendedErrorCode;
    }

    public String getMessage() {
        switch (this.extendedErrorCode) {
            default: {
                return "Unable to access the Data Manager " + this.getManagerName() + " on peer " + this.who;
            }
            case 0: {
                return "The Data Manager " + this.getManagerName() + " is not available on peer " + this.who;
            }
            case 1: {
                return "The peer " + this.who + " is not currently connected," + " and is unable to provide the data manager " + this.getManagerName();
            }
            case 2: {
                return "Two or more peers match the criteria for " + this.who + ", a non-unique provider could not be found for the data manager " + this.getManagerName();
            }
            case 3: {
                return "None of the connected servers is able to provide access to " + this.getManagerName();
            }
            case 4: 
        }
        return "Unable to access the Data Manager " + this.getManagerName() + "\n" + this.message;
    }
}

