/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.busobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.server.file.FileBlock;
import com.helpsystems.common.tl.busobj.TunnelEndpointSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class TunnelEndpointSocketImpl
implements TunnelEndpointSocket,
Runnable {
    private static final Logger logger = Logger.getLogger(TunnelEndpointSocket.class);
    private Socket socket;
    private ServerSocket serverSocket;
    private byte[] receiveBuffer;
    private Object writeLock = new Object();
    private InputStream in;
    private OutputStream out;
    private TunnelEndpointSocket remoteEndpoint;

    private TunnelEndpointSocketImpl() {
    }

    public TunnelEndpointSocketImpl(ServerSocket serverSocket) throws IOException {
        this();
        this.serverSocket = serverSocket;
        this.receiveBuffer = new byte[0];
    }

    public TunnelEndpointSocketImpl(Socket socket) throws IOException {
        this();
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    public int getListenPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    @Override
    public void close() {
        this.localClose();
        if (this.remoteEndpoint != null) {
            this.remoteEndpoint.remoteEndpointClosed();
        }
    }

    private void localClose() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void remoteEndpointClosed() {
        this.localClose();
        this.remoteEndpoint = null;
    }

    @Override
    public void attach(TunnelEndpointSocket tunnelEndpointSocket) throws ActionFailedException {
        this.checkIfClosed();
        if (this.remoteEndpoint != null) {
            throw new ActionFailedException("Remote endpoint is already set.");
        }
        this.remoteEndpoint = tunnelEndpointSocket;
        Thread thread = new Thread(this);
        thread.start();
    }

    private void checkIfClosed() throws ActionFailedException {
        if (this.serverSocket != null) {
            return;
        }
        if (this.socket.isClosed()) {
            throw new ActionFailedException("Socket is closed.");
        }
    }

    public FileBlock read(int n) throws ActionFailedException {
        this.checkIfClosed();
        try {
            byte[] byArray = new byte[n];
            int n2 = this.in.read(byArray);
            return new FileBlock(byArray, n2);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to read from socket.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FileBlock fileBlock) throws ActionFailedException {
        this.checkIfClosed();
        Object object = this.writeLock;
        synchronized (object) {
            if (this.receiveBuffer != null) {
                byte[] byArray = fileBlock.getBytes();
                int n = fileBlock.getLength();
                byte[] byArray2 = new byte[this.receiveBuffer.length + n];
                System.arraycopy(this.receiveBuffer, 0, byArray2, 0, this.receiveBuffer.length);
                System.arraycopy(byArray, 0, byArray2, this.receiveBuffer.length, n);
                this.receiveBuffer = byArray2;
                return;
            }
        }
        try {
            this.out.write(fileBlock.getBytes(), 0, fileBlock.getLength());
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to write to socket.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object;
            if (this.serverSocket != null) {
                this.socket = this.serverSocket.accept();
                this.serverSocket.close();
                this.serverSocket = null;
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
                object = this.writeLock;
                synchronized (object) {
                    this.out.write(this.receiveBuffer);
                    this.receiveBuffer = null;
                }
            }
            while (!this.socket.isClosed()) {
                object = this.read(10000);
                if (object == null) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.remoteEndpoint == null) {
                    logger.debug((Object)"Remote Endpoint no longer available.");
                    this.remoteEndpointClosed();
                    return;
                }
                this.remoteEndpoint.write((FileBlock)object);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Endpoint error", (Throwable)exception);
        }
        finally {
            this.close();
        }
    }
}

