/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.access;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.Identifiable;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.DestinationCache;
import com.helpsystems.common.tl.access.TLInvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TLInvocationDelegator
extends TLInvocationHandler {
    private Map<String, String> hostMethodMap;
    private DestinationCache cache;
    private String interfaceName;

    public TLInvocationDelegator(Peer peer, String string, String[] stringArray) {
        super(peer);
        this.interfaceName = string;
        this.hostMethodMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            this.hostMethodMap.put(stringArray[i], "hi");
        }
        this.cache = new DestinationCache();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (!(object instanceof IAbstractManager)) {
            throw new IllegalArgumentException("The proxy class " + object.getClass().getName() + " that was passed in is not" + " valid - it must be an IAbstractManager implementation.");
        }
        if ("getName".equals(method.getName())) {
            return this.interfaceName;
        }
        if ("managerRemoved".equals(method.getName())) {
            this.cache.clear();
            return null;
        }
        if (this.hostMethodMap.containsKey(method.getName())) {
            PeerID[] peerIDArray = this.localPeer.getHostsFromRoutingTable();
            if (peerIDArray.length == 0) {
                throw new ResourceUnavailableException("The local peer does not have any hosts in its routing table.", null);
            }
            if (peerIDArray.length > 1) {
                throw new ResourceUnavailableException("The local peer is  connected to " + peerIDArray.length + " hosts.", null);
            }
            String string = this.figureOutManagerName("HOST");
            return this.doInvoke(peerIDArray[0], string, object, method, objectArray);
        }
        BasicIdentifier basicIdentifier = this.findIdentifier(objectArray, null);
        if (basicIdentifier == null) {
            throw new IllegalArgumentException("Unable to locate an identifier within the parameters.");
        }
        if (basicIdentifier == ProductIID.HOST_PIID) {
            throw new IllegalStateException("The identifier specified a Host, but the method " + method + " is on a Node.");
        }
        DestinationCache.CacheValue cacheValue = null;
        cacheValue = this.cache.lookupIdentifier(this.localPeer, basicIdentifier);
        if (cacheValue == null) {
            throw new NullPointerException("Unable to lookup the info for  identifier " + basicIdentifier);
        }
        String string = this.figureOutManagerName(cacheValue.getLibraryName());
        return this.doInvoke(cacheValue.getPeerID(), string, object, method, objectArray);
    }

    protected String figureOutManagerName(String string) {
        if (string == null) {
            return this.interfaceName;
        }
        return this.interfaceName + "." + string;
    }

    private BasicIdentifier findIdentifier(Object[] objectArray, Class clazz) {
        if (objectArray == null) {
            return null;
        }
        BasicIdentifier basicIdentifier = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            if (object instanceof Identifiable) {
                basicIdentifier = ((Identifiable)object).getIdentifier();
            } else if (object instanceof BasicIdentifier) {
                basicIdentifier = (BasicIdentifier)object;
            }
            if (basicIdentifier == null) continue;
            if (clazz == null) {
                return basicIdentifier;
            }
            if (!clazz.isAssignableFrom(clazz.getClass())) continue;
            return basicIdentifier;
        }
        return null;
    }
}

