/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.busobj.RoutableBasicIdentifier;
import com.helpsystems.common.core.encryption.MD5;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.PeerDescriptor;
import java.io.Serializable;

public final class PeerID
extends CommonVersionedObject
implements Cloneable,
RoutableBasicIdentifier {
    private static final long serialVersionUID = -5811300739698866176L;
    private String hardwareKey;
    private String hardwareHash;
    private Serializable instanceIdentifier;
    private int hashcode;
    private PeerDescriptor peerDescriptor;

    public PeerID() {
    }

    PeerID(String string, Serializable serializable) {
        ValidationHelper.checkForNullAndBlank((String)"Hardware Key", (String)string);
        ValidationHelper.checkForNull((String)"Instance identifier", (Object)serializable);
        this.hardwareKey = string.endsWith("\n") ? string.substring(0, string.length() - 1) : string;
        this.instanceIdentifier = serializable;
        try {
            this.hardwareHash = MD5.shortHash((String)string);
            this.hashcode = serializable.hashCode() * this.hardwareHash.hashCode();
        }
        catch (Exception exception) {
            this.hashcode = serializable.hashCode() * string.hashCode();
        }
    }

    public static PeerID createPeerID(String string, Serializable serializable, PeerDescriptor peerDescriptor) {
        PeerID peerID = new PeerID(string, serializable);
        ValidationHelper.checkForNull((String)"Peer Descriptor", (Object)peerDescriptor);
        if (!peerDescriptor.isValid()) {
            throw new IllegalArgumentException("The peer descriptor is not valid.");
        }
        peerID.setPeerDescriptor(peerDescriptor);
        return peerID;
    }

    public Object clone() {
        try {
            PeerID peerID = (PeerID)super.clone();
            peerID.peerDescriptor = (PeerDescriptor)this.peerDescriptor.clone();
            return peerID;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone failed", cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        PeerID peerID = (PeerID)object;
        return Equal.isEqual((Object)this.hardwareHash, (Object)peerID.hardwareHash) && Equal.isEqual((Object)this.instanceIdentifier, (Object)peerID.instanceIdentifier);
    }

    public String getHardwareKey() {
        return this.hardwareKey;
    }

    public String getHardwareHash() {
        return this.hardwareHash;
    }

    public Serializable getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        if (this.peerDescriptor != null) {
            String string = this.peerDescriptor.toString();
            if (this.peerDescriptor.getType() == 3) {
                string = string + " (" + this.instanceIdentifier + ")";
            } else if (this.peerDescriptor.getType() == 10) {
                string = string + " (" + this.instanceIdentifier + ")";
            }
            return string;
        }
        String string = this.hardwareKey;
        if (this.hardwareKey.length() > 15 && this.hardwareHash != null) {
            string = this.hardwareHash;
        }
        return string + ":" + this.instanceIdentifier;
    }

    public PeerDescriptor getPeerDescriptor() {
        return this.peerDescriptor;
    }

    public void setPeerDescriptor(PeerDescriptor peerDescriptor) {
        this.peerDescriptor = peerDescriptor;
    }
}

