/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.tl.NetworkInterfaceTester;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;

public final class PeerDescriptor
extends CommonVersionedObject
implements XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 887444929099592853L;
    public static final String AGENT_NAME_KEY = "HS_AGENT_ALIAS";
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(PeerDescriptor.class);
    public static final int UNKNOWN = 0;
    public static final int HOST = 1;
    public static final int NODE = 2;
    public static final int UI = 3;
    public static final int AGENT = 4;
    public static final int SCHENT_SERVER = 6;
    public static final int AGENT_SERVICE_MANAGER = 7;
    public static final int SCHENT_SERVER_SERVICE = 8;
    public static final int SCHENT_STANDBY_SERVER = 9;
    public static final int SKYBOT_COMMAND_PEER = 10;
    private TreeSet<String> addressList = new TreeSet();
    private int port;
    private int peerType;
    private String computerName;
    private String osName;
    private InetAddress preferredInetAddress;
    private static transient InetAddress[] localAddresses;

    public PeerDescriptor() {
    }

    public PeerDescriptor(String string, int n, int n2, String string2) {
        this.addAddress(string);
        this.setPort(n);
        this.setType(n2);
        this.setOSName(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddress(String string) {
        Object object;
        String string2 = string.trim().toUpperCase();
        if (string2.indexOf(":") > -1) {
            try {
                object = InetAddress.getByName(string2);
                if (object instanceof Inet6Address) {
                    string2 = ((InetAddress)object).getHostAddress().toUpperCase();
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (PeerDescriptor.isLoopbackAddress(string2)) {
            object = this.getLocalAddresses();
            for (int i = 0; i < ((Object)object).length; ++i) {
                TreeSet<String> treeSet;
                string2 = ((InetAddress)object[i]).getHostAddress();
                if (!PeerDescriptor.isLoopbackAddress(string2)) {
                    treeSet = this.addressList;
                    synchronized (treeSet) {
                        this.addressList.add(string2);
                    }
                }
                if (PeerDescriptor.isLoopbackAddress(string2 = ((InetAddress)object[i]).getHostName())) continue;
                treeSet = this.addressList;
                synchronized (treeSet) {
                    this.addressList.add(string2);
                    continue;
                }
            }
            return;
        }
        object = this.addressList;
        synchronized (object) {
            this.addressList.add(string2);
        }
    }

    public void clearAddresses() {
        this.addressList.clear();
    }

    public Object clone() {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.peerType = this.peerType;
        peerDescriptor.port = this.port;
        peerDescriptor.osName = this.osName;
        peerDescriptor.addressList = new TreeSet<String>((SortedSet<String>)this.addressList);
        peerDescriptor.computerName = this.computerName;
        peerDescriptor.preferredInetAddress = this.preferredInetAddress;
        return peerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerDescriptor createLocalPeerDescriptor(int n, int n2) {
        TreeSet<String> treeSet;
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setPort(n);
        peerDescriptor.setType(n2);
        peerDescriptor.setOSName(PeerDescriptor.getLocalOSName());
        peerDescriptor.addAddress(PeerDescriptor.getLocalHostname());
        InetAddress[] inetAddressArray = peerDescriptor.getLocalAddresses();
        for (int i = 0; i < inetAddressArray.length; ++i) {
            if (!PeerDescriptor.isLoopbackAddress(inetAddressArray[i].getHostAddress())) {
                treeSet = peerDescriptor.addressList;
                synchronized (treeSet) {
                    peerDescriptor.addressList.add(inetAddressArray[i].getHostAddress());
                }
            }
            if (PeerDescriptor.isLoopbackAddress(inetAddressArray[i].getHostName())) continue;
            treeSet = peerDescriptor.addressList;
            synchronized (treeSet) {
                peerDescriptor.addressList.add(inetAddressArray[i].getHostName());
                continue;
            }
        }
        peerDescriptor.addAddress("localhost");
        String string = System.getenv().get("COMPUTERNAME");
        treeSet = System.getenv().get(AGENT_NAME_KEY);
        peerDescriptor.computerName = treeSet != null && ((String)((Object)treeSet)).length() > 0 ? string + "_" + treeSet : string;
        return peerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAddress(String string) {
        if (string == null) {
            throw new NullPointerException("The address passed in is null.");
        }
        TreeSet<String> treeSet = this.addressList;
        synchronized (treeSet) {
            return this.addressList.contains(string.trim().toUpperCase());
        }
    }

    public boolean containsAddress(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("The address array passed in is null.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.containsAddress(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public String[] doNotInvoke() {
        return new String[]{"getLocalAddresses", "getLocalHostname", "getLocalOSName", "getOSName", "getTypeAsString", "getPeerName"};
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PeerDescriptor)) {
            return false;
        }
        PeerDescriptor peerDescriptor = (PeerDescriptor)object;
        if (peerDescriptor == this) {
            return true;
        }
        if (this.port != peerDescriptor.port || this.peerType != peerDescriptor.peerType) {
            return false;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.addressList);
        treeSet.addAll(peerDescriptor.addressList);
        if (treeSet.size() < this.addressList.size() + peerDescriptor.addressList.size()) {
            return true;
        }
        String[] stringArray = this.getAddresses();
        String[] stringArray2 = peerDescriptor.getAddresses();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].indexOf(":") > -1) {
                stringArray[i] = null;
                continue;
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j] == null) continue;
                if (stringArray2[j].indexOf(":") > -1) {
                    stringArray2[j] = null;
                    continue;
                }
                if (!stringArray2[j].startsWith(stringArray[i] + ".") && !stringArray[i].startsWith(stringArray2[j] + ".")) continue;
                return true;
            }
        }
        return false;
    }

    public String findIPAddress() {
        String string = null;
        for (String string2 : this.getAddresses()) {
            if (!string2.matches("[\\d]{0,3}\\.[\\d]{0,3}\\.[\\d]{0,3}\\.[\\d]{0,3}") || PeerDescriptor.isLoopbackAddress(string2)) continue;
            string = string2;
            break;
        }
        if (string == null) {
            string = this.findPrintableAddress();
        }
        return string;
    }

    public String findPrintableAddress() {
        String[] stringArray = this.getAddresses();
        if (stringArray.length == 0) {
            return "null";
        }
        for (int i = stringArray.length - 1; i > -1; --i) {
            if (PeerDescriptor.isLoopbackAddress(stringArray[i]) || stringArray[i].indexOf(":") != -1) continue;
            return stringArray[i];
        }
        return this.addressList.first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAddresses() {
        TreeSet<String> treeSet = this.addressList;
        synchronized (treeSet) {
            String[] stringArray = new String[this.addressList.size()];
            this.addressList.toArray(stringArray);
            return stringArray;
        }
    }

    public String getComputerName() {
        return this.computerName;
    }

    public void setComputerName(String string) {
        this.computerName = string;
    }

    public String findName() {
        String string = this.getComputerName();
        if (string != null) {
            return string;
        }
        return this.findPrintableAddress();
    }

    public synchronized InetAddress[] getLocalAddresses() {
        if (localAddresses != null) {
            return localAddresses;
        }
        if (this.peerType == 3) {
            try {
                localAddresses = new InetAddress[]{InetAddress.getLocalHost()};
                return localAddresses;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NetworkInterfaceTester networkInterfaceTester = new NetworkInterfaceTester(this);
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    networkInterfaceTester.test(inetAddress);
                }
            }
            localAddresses = networkInterfaceTester.getValidAddresses();
            return localAddresses;
        }
        catch (SocketException socketException) {
            throw new RuntimeException("Unable to retrieve the network interface information for this system.", socketException);
        }
    }

    public static String getLocalHostname() {
        String string = null;
        UnknownHostException unknownHostException = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getCanonicalHostName().toUpperCase();
        }
        catch (UnknownHostException unknownHostException2) {
            unknownHostException = unknownHostException2;
        }
        if (string == null) {
            throw new RuntimeException("Could not determine the hostname of this machine.", unknownHostException);
        }
        return string;
    }

    public static String getLocalOSName() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public String getOSName() {
        return this.osName;
    }

    public int getPort() {
        return this.port;
    }

    public int getType() {
        return this.peerType;
    }

    public String getTypeAsString() {
        return PeerDescriptor.getTypeAsString(this.peerType);
    }

    public int hashCode() {
        long l = this.addressList.hashCode();
        return (int)l * this.port * (this.peerType + 1);
    }

    public static boolean isLoopbackAddress(String string) {
        return string.startsWith("127.") || string.equals("0:0:0:0:0:0:0:1") || string.startsWith("0:0:0:0:0:0:0:1:") || string.equals("::1") || string.equalsIgnoreCase("LOOPBACK") || string.equalsIgnoreCase("LOCALHOST");
    }

    public boolean isGateway() {
        return this.peerType == 1 || this.peerType == 6;
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public boolean isValid(boolean bl) {
        if (this.addressList.size() == 0) {
            return false;
        }
        if (bl && this.peerType == 0) {
            return false;
        }
        return this.port >= 1 || this.port == -1234;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoopbackAddresses() {
        String[] stringArray = this.getAddresses();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!PeerDescriptor.isLoopbackAddress(stringArray[i])) continue;
            TreeSet<String> treeSet = this.addressList;
            synchronized (treeSet) {
                this.addressList.remove(stringArray[i]);
                continue;
            }
        }
    }

    public InetAddress getPreferredInetAddress() {
        return this.preferredInetAddress;
    }

    public void setPreferredInetAddress(InetAddress inetAddress) {
        this.preferredInetAddress = inetAddress;
    }

    public void setOSName(String string) {
        this.osName = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setType(int n) {
        this.peerType = n;
    }

    public void setType(String string) {
        if (string == null || string.length() == 0) {
            this.peerType = 0;
            return;
        }
        if ("unknown".equalsIgnoreCase(string)) {
            this.peerType = 0;
            return;
        }
        if ("node".equalsIgnoreCase(string)) {
            this.peerType = 2;
            return;
        }
        if ("host".equalsIgnoreCase(string)) {
            this.peerType = 1;
            return;
        }
        if ("ui".equalsIgnoreCase(string)) {
            this.peerType = 3;
            return;
        }
        if ("schentServer".equalsIgnoreCase(string)) {
            this.peerType = 6;
            return;
        }
        if ("agent-service-manager".equalsIgnoreCase(string)) {
            this.peerType = 7;
            return;
        }
        if ("agent".equalsIgnoreCase(string)) {
            this.peerType = 4;
            return;
        }
        if ("service".equalsIgnoreCase(string)) {
            this.peerType = 8;
            return;
        }
        throw new IllegalArgumentException("The type '" + string + "' is not valid.");
    }

    public static String getTypeAsString(int n) {
        if (n == 1) {
            return rbh.getStdMsg("host_noun");
        }
        if (n == 2) {
            return rbh.getStdMsg("node_noun");
        }
        if (n == 3) {
            return rbh.getStdMsg("gui");
        }
        if (n == 4) {
            return rbh.getStdMsg("agent");
        }
        if (n == 6) {
            return rbh.getStdMsg("schentServer");
        }
        if (n == 7) {
            return rbh.getStdMsg("agent-service-manager");
        }
        if (n == 8) {
            return rbh.getStdMsg("schentServerService");
        }
        if (n == 9) {
            return rbh.getStdMsg("schentServerStandby");
        }
        if (n == 10) {
            return rbh.getStdMsg("skybot-command-peer");
        }
        return rbh.getStdMsg("unknown");
    }

    public String getPeerName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.computerName == null || this.computerName.length() == 0) {
            stringBuffer.append(this.findPrintableAddress());
        } else {
            stringBuffer.append(this.computerName);
        }
        if (this.port > 0) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPeerName());
        String string = PeerDescriptor.getTypeAsString(this.peerType);
        if (!string.equals(rbh.getStdMsg("unknown"))) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        PeerDescriptor peerDescriptor = new PeerDescriptor("a.b.c.d", 1234, 1, "a");
        PeerDescriptor peerDescriptor2 = new PeerDescriptor("a.B.c.D", 1234, 1, "b");
        PeerDescriptor peerDescriptor3 = new PeerDescriptor("x.y.Z", 1234, 1, "c");
        PeerDescriptor peerDescriptor4 = new PeerDescriptor("x.y.Z", 1234, 2, "d");
        PeerDescriptor peerDescriptor5 = new PeerDescriptor("a.b.c.d", 1235, 1, "e");
        System.out.print("comparing 1a to 1b - should be true: ");
        System.out.println(peerDescriptor.equals(peerDescriptor2));
        System.out.print("comparing 1b to 1a - should be true: ");
        System.out.println(peerDescriptor2.equals(peerDescriptor));
        System.out.print("comparing 1a to 2a - should be false: ");
        System.out.println(peerDescriptor.equals(peerDescriptor3));
        System.out.print("comparing 1a to 3a - should be false: ");
        System.out.println(peerDescriptor.equals(peerDescriptor4));
        System.out.print("comparing 1a to 4a - should be false: ");
        System.out.println(peerDescriptor.equals(peerDescriptor5));
    }

    protected boolean isIBMiAgent() {
        return this.getOSName().startsWith("OS/400");
    }
}

