/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.tl.PeerDescriptor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

class NetworkInterfaceTester {
    private static final Logger logger = Logger.getLogger(NetworkInterfaceTester.class);
    private HashMap<String, TestRunner> addressMap = new HashMap();
    private int timeoutInSeconds = 30;
    private int portNumber = 63317;
    private static final int DEFAULT_PORT_NUMBER = 63317;

    NetworkInterfaceTester(PeerDescriptor peerDescriptor) {
        this.portNumber += peerDescriptor.getType() * 100;
        if (peerDescriptor.getType() == 4) {
            this.portNumber = NetworkInterfaceTester.randomPortNumber();
        }
    }

    private static int randomPortNumber() {
        int n = (int)(Math.random() * 62000.0) + 1024;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void test(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        HashMap<String, TestRunner> hashMap = this.addressMap;
        synchronized (hashMap) {
            if (this.addressMap.get(string) != null) {
                return;
            }
            TestRunner testRunner = new TestRunner(inetAddress, this.portNumber);
            this.portNumber = this.portNumber >= 65535 ? 63317 : ++this.portNumber;
            this.addressMap.put(string, testRunner);
            Thread thread = new Thread(testRunner);
            thread.setDaemon(true);
            thread.setPriority(1);
            thread.start();
        }
    }

    void setTimeout(int n) {
        this.timeoutInSeconds = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetAddress[] getValidAddresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        long l = System.currentTimeMillis();
        while (true) {
            arrayList.clear();
            boolean bl = false;
            HashMap<String, TestRunner> hashMap = this.addressMap;
            synchronized (hashMap) {
                for (TestRunner testRunner : this.addressMap.values()) {
                    if (testRunner.getState() == 0) {
                        bl = true;
                    }
                    if (testRunner.getState() != 1) continue;
                    arrayList.add(testRunner.getInetAddress());
                }
            }
            long l2 = System.currentTimeMillis();
            if (l + (long)(this.timeoutInSeconds * 1000) < l2) {
                logger.trace((Object)"Timeout testing Network Interfaces!");
                break;
            }
            if (!bl) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        InetAddress[] inetAddressArray = new InetAddress[arrayList.size()];
        arrayList.toArray(inetAddressArray);
        return inetAddressArray;
    }

    class TestRunner
    implements Runnable {
        InetAddress inetAddress;
        int state;
        int localPortNumber;

        TestRunner(InetAddress inetAddress, int n) {
            this.inetAddress = inetAddress;
            this.localPortNumber = n;
        }

        int getState() {
            return this.state;
        }

        InetAddress getInetAddress() {
            return this.inetAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("Testing interface " + this.inetAddress.getHostAddress());
            ServerSocket serverSocket = null;
            Socket socket = null;
            int n = 5;
            while (true) {
                try {
                    serverSocket = new ServerSocket(this.localPortNumber, 0, this.inetAddress);
                }
                catch (BindException bindException) {
                    this.localPortNumber += 53;
                    if (this.localPortNumber <= 65535) continue;
                    this.localPortNumber = NetworkInterfaceTester.randomPortNumber();
                    if (--n != -1) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("After several tests, Network Interface " + this.inetAddress.getHostAddress() + " does not appear to be usable"), (Throwable)bindException);
                    }
                    this.state = -1;
                    return;
                }
                catch (Exception exception) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Could not bind socket, Network Interface " + this.inetAddress.getHostAddress() + " does not appear to be usable."), (Throwable)exception);
                    }
                    this.state = -1;
                    return;
                }
                catch (Throwable throwable) {
                    logger.debug((Object)("Error testing Network Interface " + this.inetAddress.getHostAddress()), throwable);
                    this.state = -1;
                    return;
                }
                break;
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Testing Network Interface " + this.inetAddress.getHostAddress() + " using port number " + this.localPortNumber));
                }
                if ("OS/400".equals(System.getProperty("os.name"))) {
                    socket = new Socket(this.inetAddress, this.localPortNumber);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Network Interface " + this.inetAddress.getHostAddress() + " appears to be usable."));
                }
                this.state = 1;
            }
            catch (Exception exception) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Network Interface " + this.inetAddress.getHostAddress() + " does not appear to be usable."), (Throwable)exception);
                }
                this.state = -1;
            }
            finally {
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {}
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

