/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.network.INetworkHostInfoManager;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.network.ProductProxy;
import com.helpsystems.common.core.network.SystemIID;
import com.helpsystems.common.core.network.SystemProxy;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.tl.LoadHost;
import com.helpsystems.common.tl.LoadNode;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import java.io.Serializable;

public class LoadNetworkHostInfoDM
extends AbstractManager
implements INetworkHostInfoManager {
    LoadHost hostPeer;

    LoadNetworkHostInfoDM(LoadHost loadHost) {
        this.hostPeer = loadHost;
        this.setName("COMMON.NetworkHostInfoManager");
    }

    public ProductIID getProductIID() throws ResourceUnavailableException {
        return new ProductIID(this.hostPeer.getRemotePeerID().getPeerDescriptor().getPort());
    }

    public SystemIID getSystemIID() throws ResourceUnavailableException {
        return new SystemIID(this.hostPeer.getRemotePeerID().getPeerDescriptor().getPort());
    }

    public ProductProxy get(ProductIID productIID) throws ResourceUnavailableException, DataException {
        int n = productIID.getID();
        ProductProxy productProxy = new ProductProxy();
        if (n >= 2000 && n <= 2999) {
            productProxy.setName("NETHOST");
            productProxy.setDescription("Network Host");
        } else if (n >= 3000 && n <= 3999) {
            productProxy.setName("NETNODE");
            productProxy.setDescription("Network Node");
        } else {
            productProxy = null;
        }
        if (productProxy != null) {
            productProxy.setIdentifier((BasicIdentifier)productIID);
            productProxy.setLocation(LoadNode.FAKE_LIBRARY + n);
        }
        return productProxy;
    }

    public SystemProxy get(SystemIID systemIID) throws ResourceUnavailableException, DataException {
        SystemProxy systemProxy = new SystemProxy();
        systemProxy.setIdentifier((BasicIdentifier)systemIID);
        PeerID peerID = this.bs();
        systemProxy.setName(peerID.toString());
        systemProxy.setDescription(peerID.toString());
        systemProxy.setHardwareKey(peerID.getHardwareHash());
        systemProxy.setAddress(peerID.getPeerDescriptor().getAddresses()[0]);
        return systemProxy;
    }

    public String getDateFormatForSystem(String string) throws ResourceUnavailableException, DataException {
        return "MDY";
    }

    public RelMod getNodeRelMod(String string) throws ResourceUnavailableException, DataException {
        return new RelMod();
    }

    public SystemProxy[] listSystems() throws ResourceUnavailableException, DataException {
        return new SystemProxy[0];
    }

    public ProductProxy[] listProducts(SystemIID systemIID) throws ResourceUnavailableException, DataException {
        return new ProductProxy[0];
    }

    public ProductProxy[] listProducts(String string) throws ResourceUnavailableException, DataException {
        return new ProductProxy[0];
    }

    public ProductProxy[] listProducts(SystemIID systemIID, String string) throws ResourceUnavailableException, DataException {
        return new ProductProxy[0];
    }

    public String[] listDistributionLists() throws ResourceUnavailableException, DataException {
        return new String[0];
    }

    public ProductProxy[] listNodes(String string) throws ResourceUnavailableException, DataException {
        return new ProductProxy[0];
    }

    public boolean isProductInstalledOnHost(String string) throws ResourceUnavailableException, DataException {
        return "NOD".equals(string);
    }

    public ProductProxy getHost(ProductProxy productProxy) throws ResourceUnavailableException, DataException {
        return null;
    }

    public UserIdentity verifyUserProfile(UserIdentity userIdentity, SystemIID systemIID, String string, char[] cArray) throws ResourceUnavailableException, SecurityException {
        throw new SecurityException("I don't like you");
    }

    public UserIdentity verifyUserProfile(String string, SystemIID systemIID, String string2, char[] cArray) throws ResourceUnavailableException, SecurityException {
        throw new SecurityException("I don't like you");
    }

    public UserIdentity verifyUserProfile(UserIdentity userIdentity, SystemIID systemIID, String string, char[] cArray, boolean bl) throws ResourceUnavailableException {
        throw new SecurityException("I don't like you");
    }

    public void authenticateUserIdentity(UserIdentity userIdentity, SystemIID systemIID, boolean bl) throws NoDataException, ResourceUnavailableException, SecurityException {
        throw new SecurityException("I don't like you");
    }

    public String[] getAddresses() throws ResourceUnavailableException {
        return new String[0];
    }

    public boolean isPermissionGranted(int n) throws ResourceUnavailableException {
        return false;
    }

    private PeerID bs() {
        PeerID peerID = this.hostPeer.getRemotePeerID();
        String string = peerID.getHardwareHash();
        int n = peerID.getPeerDescriptor().getPort() + 1;
        if (n > 3004) {
            n = 3000;
        }
        String string2 = LoadNode.FAKE_LIBRARY + n;
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setPort(n);
        peerDescriptor.setType(2);
        peerDescriptor.addAddress("localhost");
        PeerID peerID2 = PeerID.createPeerID(string, (Serializable)((Object)string2), peerDescriptor);
        return peerID2;
    }

    public String[] getAddressesForHostname(String string) {
        return new String[]{string};
    }
}

